/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class DeckBeatSlicesPanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = 4592460224014948518L;
    private static final Logger logger = Logger.getLogger(DeckBeatSlicesPanel.class.getName());
    private ColorButtonStyle styleBeatSlice;
    private ColorButtonStyle styleBeatSliceActive;
    private ColorButton[] sliceButtons = new ColorButton[0];
    private DvsButtonsPanel buttonsPanel;

    public DeckBeatSlicesPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Beat Slices");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = this.sliceButtons.length + 2;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponents((JComponent[])this.sliceButtons, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        int oldCount;
        ScratchDeck scratchDeck = this.scratchDeck;
        int newCount = 0;
        if (scratchDeck != null) {
            newCount = scratchDeck.getBeatSliceCount();
        }
        if (newCount != (oldCount = this.sliceButtons.length)) {
            ColorButton[] arr = new ColorButton[newCount];
            int num = Math.min(oldCount, newCount);
            System.arraycopy(this.sliceButtons, 0, arr, 0, num);
            for (int i = num; i < newCount; ++i) {
                ColorButton button = this.createDvsColorButton("BeatSlice#" + i, String.valueOf(i + 1), this.styleBeatSlice);
                button.addColorButtonListener((ColorButtonListener)new BeatSliceButtonHandler(i));
                button.setToolTipText("Beat-Slice " + button.getText());
                button.setToolTipEnabled(false);
                button.setDisarmed(true);
                button.setRequestFocusEnabled(false);
                arr[i] = button;
            }
            this.sliceButtons = arr;
        }
        this.buttonsPanel.setButtons((Component[])this.sliceButtons);
        boolean slicerActive = false;
        if (scratchDeck != null) {
            slicerActive = scratchDeck.isBeatSlicerActive();
        }
        if (slicerActive) {
            this.beatSlicerStarted(scratchDeck);
        } else {
            this.beatSlicerStopped(scratchDeck);
        }
    }

    @Override
    protected synchronized void refreshViewSettings() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsBeatSliceColor();
        this.styleBeatSlice = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        col = viewSettings.getDvsBeatSliceActiveColor();
        this.styleBeatSliceActive = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        ColorButton[] buttons = this.sliceButtons;
        if (buttons != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshBeatSliceButton(i);
            }
        }
    }

    protected void refreshBeatSliceButton(int index) {
        ColorButton button;
        ColorButton[] buttons = this.sliceButtons;
        if (index >= 0 && index < buttons.length && (button = buttons[index]) != null) {
            ColorButtonStyle style = this.styleBeatSlice;
            if (style == null) {
                style = this.defaultButtonStyle;
            }
            button.setColorButtonStyle(style);
            this.midiMapper.registerMidiAction(button, "SlicerJump-" + String.valueOf(index + 1));
        }
    }

    protected void handleBeatSlicePressed(int index) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicePressed: #" + index);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.beatSliceTriggered(index);
        }
    }

    protected void handleBeatSliceReleased(int index) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSliceReleased: #" + index);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.beatSliceReleased(index);
        }
    }

    protected void handleBeatSlicerTogglePressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerTogglePressed");
        }
        if ((deck = this.scratchDeck) != null) {
            if (deck.isBeatSlicerActive()) {
                deck.stopBeatSlicer();
            } else {
                deck.startBeatSlicer();
            }
        }
    }

    protected void handleBeatSlicerToggleReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerToggleReleased");
        }
    }

    protected void handleBeatSlicerLoopPressed() {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerLoopPressed");
        }
        if ((deck = this.scratchDeck) != null) {
            deck.setBeatSlicerLoopMode(!deck.isBeatSlicerLoopMode());
        }
    }

    protected void handleBeatSlicerLoopReleased() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleBeatSlicerLoopReleased");
        }
    }

    public void beatSlicerStarted(ScratchDeck deck) {
        ColorButton[] buttons = this.sliceButtons;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setEnabled(true);
        }
    }

    public void beatSlicerStopped(ScratchDeck deck) {
        ColorButton[] buttons = this.sliceButtons;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setEnabled(false);
        }
    }

    public void beatSliceActivated(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.sliceButtons;
        if (index >= 0 && index < buttons.length) {
            buttons[index].setColorButtonStyle(this.styleBeatSliceActive);
            buttons[index].setSelected(true);
        }
    }

    public void beatSliceEntered(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.sliceButtons;
        if (index >= 0 && index < buttons.length) {
            buttons[index].setColorButtonStyle(this.styleBeatSlice);
            buttons[index].setSelected(true);
        }
    }

    public void beatSliceExited(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.sliceButtons;
        if (index >= 0 && index < buttons.length) {
            buttons[index].setColorButtonStyle(this.styleBeatSlice);
            buttons[index].setSelected(false);
        }
    }

    protected class BeatSliceButtonHandler
    extends ColorButtonAdapter {
        private int beatSliceIndex;

        public BeatSliceButtonHandler(int beatSliceIndex) {
            this.beatSliceIndex = beatSliceIndex;
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicesPanel.this.handleBeatSlicePressed(this.beatSliceIndex);
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckBeatSlicesPanel.this.handleBeatSlicePressed(this.beatSliceIndex);
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicesPanel.this.handleBeatSliceReleased(this.beatSliceIndex);
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckBeatSlicesPanel.this.handleBeatSliceReleased(this.beatSliceIndex);
        }
    }
}

