/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DeckCuePointsPanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = 1278422017481646967L;
    private static final Logger logger = Logger.getLogger(DeckCuePointsPanel.class.getName());
    private ColorButtonStyle[] buttonStyles;
    private ColorButtonStyle buttonStyleDefault;
    private ColorButtonStyle buttonStyleEmpty;
    private ColorButton[] cuePointButtons = new ColorButton[0];
    private DvsButtonsPanel buttonsPanel;

    public DeckCuePointsPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Cue Points");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = this.cuePointButtons.length;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponents((JComponent[])this.cuePointButtons, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        int oldCount;
        ScratchDeck scratchDeck = this.scratchDeck;
        int newCount = 0;
        if (scratchDeck != null) {
            newCount = scratchDeck.getCuePointCount();
        }
        if (newCount != (oldCount = this.cuePointButtons.length)) {
            int i;
            ColorButton[] arr = new ColorButton[newCount];
            int num = Math.min(oldCount, newCount);
            System.arraycopy(this.cuePointButtons, 0, arr, 0, num);
            for (i = num; i < newCount; ++i) {
                ColorButton button = this.createDvsColorButton("CuePoint#" + i, String.valueOf(i + 1), this.buttonStyleDefault);
                button.addColorButtonListener((ColorButtonListener)new CuePointButtonHandler(i));
                button.setToolTipText("Cue-Point " + button.getText());
                button.setToolTipEnabled(false);
                button.setDisarmed(true);
                button.setRequestFocusEnabled(false);
                arr[i] = button;
            }
            this.cuePointButtons = arr;
            for (i = 0; i < newCount; ++i) {
                this.refreshCuePointButton(i);
            }
        }
        this.buttonsPanel.setButtons((Component[])this.cuePointButtons);
    }

    @Override
    protected synchronized void refreshViewSettings() {
        ColorButton[] buttons;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsCuePointDefaultColor();
        this.buttonStyleDefault = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        col = viewSettings.getDvsCuePointEmptyColor();
        this.buttonStyleEmpty = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        Color[] cuePointColors = viewSettings.getDvsCuePointColors();
        if (cuePointColors != null) {
            int num = cuePointColors.length;
            ColorButtonStyle[] arr = new ColorButtonStyle[num];
            for (int i = 0; i < num; ++i) {
                ColorButtonStyle style;
                col = cuePointColors[i];
                arr[i] = style = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
            }
            this.buttonStyles = arr;
        }
        if ((buttons = this.cuePointButtons) != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshCuePointButton(i);
            }
        }
    }

    protected void refreshCuePointButton(int index) {
        ColorButton button;
        ColorButton[] buttons = this.cuePointButtons;
        if (index >= 0 && index < buttons.length && (button = buttons[index]) != null) {
            ColorButtonStyle style = this.buttonStyleEmpty;
            if (button.isSelected()) {
                if (this.buttonStyles != null && index < this.buttonStyles.length) {
                    style = this.buttonStyles[index];
                }
                if (style == null) {
                    style = this.buttonStyleDefault;
                }
            }
            button.setColorButtonStyle(style);
            this.midiMapper.registerMidiAction(button, "JumpOrSetOrRemoveCuePoint-" + String.valueOf(index + 1));
        }
    }

    protected void handleCuePointPressed(int index, boolean delete) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleCuePointPressed: #" + index + ", delete=" + delete);
        }
        if ((deck = this.scratchDeck) != null) {
            if (delete) {
                deck.removeCuePoint(index);
            } else {
                deck.jumpOrSetCuePoint(index);
            }
        }
    }

    protected void handleCuePointReleased(int index, boolean delete) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleCuePointReleased: #" + index + ", delete=" + delete);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.cuePointReleased(index);
        }
    }

    public void cuePointAdded(ScratchDeck deck, int index) {
        this.cuePointChanged(deck, index);
    }

    public void cuePointRemoved(ScratchDeck deck, int index) {
        this.cuePointChanged(deck, index);
    }

    public void cuePointChanged(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.cuePointButtons;
        if (index >= 0 && index < buttons.length) {
            double pos = this.scratchDeck.getCuePointPosition(index);
            boolean sel = !Double.isNaN(pos);
            buttons[index].setSelected(sel);
            this.refreshCuePointButton(index);
        }
    }

    protected class CuePointButtonHandler
    extends ColorButtonAdapter {
        private int cuePointIndex;

        public CuePointButtonHandler(int cuePointIndex) {
            this.cuePointIndex = cuePointIndex;
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            boolean delete = false;
            DeckCuePointsPanel.this.handleCuePointPressed(this.cuePointIndex, delete);
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            boolean delete = SwingUtilities.isRightMouseButton(event);
            DeckCuePointsPanel.this.handleCuePointPressed(this.cuePointIndex, delete);
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            boolean delete = false;
            DeckCuePointsPanel.this.handleCuePointReleased(this.cuePointIndex, delete);
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            boolean delete = SwingUtilities.isRightMouseButton(event);
            DeckCuePointsPanel.this.handleCuePointReleased(this.cuePointIndex, delete);
        }
    }
}

