/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class DeckLoopRollsPanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = -4540095638184053211L;
    private static final Logger logger = Logger.getLogger(DeckLoopRollsPanel.class.getName());
    private ColorButtonStyle styleLoopRoll;
    private ColorButton[] loopRollButtons = new ColorButton[0];
    private DvsButtonsPanel buttonsPanel;

    public DeckLoopRollsPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Loop Roll");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = this.loopRollButtons.length;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponents((JComponent[])this.loopRollButtons, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        int oldCount;
        ScratchDeck scratchDeck = this.scratchDeck;
        int newCount = 0;
        if (scratchDeck != null) {
            newCount = scratchDeck.getLoopRollCount();
        }
        if (newCount != (oldCount = this.loopRollButtons.length)) {
            ColorButton[] arr = new ColorButton[newCount];
            int num = Math.min(oldCount, newCount);
            System.arraycopy(this.loopRollButtons, 0, arr, 0, num);
            for (int i = num; i < newCount; ++i) {
                ColorButton button = this.createDvsColorButton("LoopRoll#" + i, "", this.styleLoopRoll);
                button.addColorButtonListener((ColorButtonListener)new LoopRollButtonHandler(i));
                button.setToolTipText("Loop-Roll " + button.getText());
                button.setToolTipEnabled(false);
                button.setDisarmed(true);
                button.setRequestFocusEnabled(false);
                arr[i] = button;
            }
            this.loopRollButtons = arr;
        }
        this.buttonsPanel.setButtons((Component[])this.loopRollButtons);
    }

    @Override
    protected synchronized void refreshViewSettings() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsLoopRollColor();
        this.styleLoopRoll = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        ColorButton[] buttons = this.loopRollButtons;
        if (buttons != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshLoopRollButton(i);
            }
        }
    }

    protected void refreshLoopRollButton(int index) {
        ColorButton button;
        ColorButton[] buttons = this.loopRollButtons;
        if (index >= 0 && index < buttons.length && (button = buttons[index]) != null) {
            ColorButtonStyle style = this.styleLoopRoll;
            if (style == null) {
                style = this.defaultButtonStyle;
            }
            button.setColorButtonStyle(style);
            this.midiMapper.registerMidiAction(button, "LoopRoll-" + String.valueOf(index + 1));
        }
    }

    protected void handleLoopRollPressed(int index) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleLoopRollPressed: #" + index);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.startLoopRoll(index);
        }
    }

    protected void handleLoopRollReleased(int index) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleLoopRollReleased: #" + index);
        }
        if ((deck = this.scratchDeck) != null) {
            deck.stopLoopRoll(index);
        }
    }

    public void loopRollStarted(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.loopRollButtons;
        if (index >= 0 && index < buttons.length) {
            buttons[index].setSelected(true);
        }
    }

    public void loopRollStopped(ScratchDeck deck, int index) {
        ColorButton[] buttons = this.loopRollButtons;
        if (index >= 0 && index < buttons.length) {
            buttons[index].setSelected(false);
        }
    }

    protected class LoopRollButtonHandler
    extends ColorButtonAdapter {
        private int loopRollIndex;

        public LoopRollButtonHandler(int loopRollIndex) {
            this.loopRollIndex = loopRollIndex;
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckLoopRollsPanel.this.handleLoopRollPressed(this.loopRollIndex);
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckLoopRollsPanel.this.handleLoopRollPressed(this.loopRollIndex);
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckLoopRollsPanel.this.handleLoopRollReleased(this.loopRollIndex);
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckLoopRollsPanel.this.handleLoopRollReleased(this.loopRollIndex);
        }
    }
}

