/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.media.control.FaderControlPanel;
import com.waxmonster.waxlab.PitchModeControl;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeckPitchInfoPanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = 4746697826305616380L;
    private static final Logger logger = Logger.getLogger(DeckPitchInfoPanel.class.getName());
    private JLabel lblPitchMode;
    private JPanel panelPitchControl;
    private FaderControlPanel customPitchFaderPanel;

    public DeckPitchInfoPanel() {
        this.setTitle("Pitch");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelPitch = new JPanel();
        panelPitch.setOpaque(false);
        GridBagConstraints gbc_panelPitch = new GridBagConstraints();
        gbc_panelPitch.insets = new Insets(4, 4, 4, 4);
        gbc_panelPitch.weighty = 1.0;
        gbc_panelPitch.weightx = 1.0;
        gbc_panelPitch.fill = 1;
        gbc_panelPitch.gridx = 0;
        gbc_panelPitch.gridy = 0;
        this.add((Component)panelPitch, gbc_panelPitch);
        GridBagLayout gbl_panelPitch = new GridBagLayout();
        gbl_panelPitch.columnWidths = new int[]{0, 0, 0};
        gbl_panelPitch.rowHeights = new int[]{0, 0};
        gbl_panelPitch.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelPitch.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelPitch.setLayout(gbl_panelPitch);
        this.lblPitchMode = new JLabel("Pitch Mode");
        GridBagConstraints gbc_lblPitchMode = new GridBagConstraints();
        gbc_lblPitchMode.insets = new Insets(0, 0, 0, 5);
        gbc_lblPitchMode.gridx = 0;
        gbc_lblPitchMode.gridy = 0;
        panelPitch.add((Component)this.lblPitchMode, gbc_lblPitchMode);
        this.panelPitchControl = new JPanel();
        this.panelPitchControl.setOpaque(false);
        GridBagConstraints gbc_panelPitchControl = new GridBagConstraints();
        gbc_panelPitchControl.weightx = 1.0;
        gbc_panelPitchControl.fill = 1;
        gbc_panelPitchControl.gridx = 1;
        gbc_panelPitchControl.gridy = 0;
        panelPitch.add((Component)this.panelPitchControl, gbc_panelPitchControl);
        this.panelPitchControl.setLayout(new GridLayout(1, 0, 0, 0));
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = 1.0;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        PitchModeControl control;
        ScratchDeck scratchDeck = this.scratchDeck;
        Object mode = null;
        if (scratchDeck != null && (control = scratchDeck.getPitchModeControl()) != null) {
            mode = control.getValue();
        }
    }

    @Override
    protected synchronized void refreshViewSettings() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = Color.WHITE;
        this.lblPitchMode.setForeground(col);
    }

    public void pitchModeChanged(ScratchDeck deck, int mode) {
        PitchModeControl control;
        Object modeValue = null;
        if (this.scratchDeck != null && (control = this.scratchDeck.getPitchModeControl()) != null) {
            modeValue = control.getValue();
        }
        String modeText = String.valueOf(modeValue);
        this.lblPitchMode.setText(modeText);
    }

    public void primaryPitchChanged(ScratchDeck deck, double pitch) {
    }

    public void secondaryPitchChanged(ScratchDeck deck, double pitch) {
    }

    protected JLabel getLblPitchMode() {
        return this.lblPitchMode;
    }

    protected JPanel getPanelPitchControl() {
        return this.panelPitchControl;
    }
}

