/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.PitchModeControl;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.impl.AbstractPitchModeControl;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class DeckPitchModePanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = -5188587740510097632L;
    private static final Logger logger = Logger.getLogger(DeckPitchModePanel.class.getName());
    private ColorButtonStyle[] buttonStyles;
    private ColorButtonStyle buttonStyleDefault;
    private ColorButton[] pitchModeButtons = new ColorButton[0];
    private DvsButtonsPanel buttonsPanel;

    public DeckPitchModePanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Pitch Mode");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = this.pitchModeButtons.length;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponents((JComponent[])this.pitchModeButtons, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        int oldCount;
        int newCount;
        PitchModeControl control;
        ScratchDeck scratchDeck = this.scratchDeck;
        Object[] modes = null;
        if (scratchDeck != null && (control = scratchDeck.getPitchModeControl()) != null) {
            modes = control.getValues();
        }
        if ((newCount = modes == null ? 0 : modes.length) != (oldCount = this.pitchModeButtons.length)) {
            ColorButton[] arr = new ColorButton[newCount];
            int num = Math.min(oldCount, newCount);
            System.arraycopy(this.pitchModeButtons, 0, arr, 0, num);
            for (int i = num; i < newCount; ++i) {
                Object mode = modes[i];
                String modeName = String.valueOf(mode);
                String modeText = modeName.length() > 0 ? modeName.substring(0, 1) : String.valueOf(i + 1);
                ColorButton button = this.createDvsColorButton("PitchMode#" + i, modeText, this.buttonStyleDefault);
                button.addColorButtonListener((ColorButtonListener)new PitchModeButtonHandler(i, mode));
                button.setToolTipText("Scratch-Mode: " + modeName);
                button.setToolTipEnabled(false);
                button.setDisarmed(true);
                button.setRequestFocusEnabled(false);
                arr[i] = button;
                this.midiMapper.registerMidiAction(button, this.getPitchModeMidiAction(modeName));
            }
            this.pitchModeButtons = arr;
        }
        this.buttonsPanel.setButtons((Component[])this.pitchModeButtons);
    }

    protected String getPitchModeMidiAction(String modeName) {
        int pitchMode = AbstractPitchModeControl.getScratchPlayerPitchMode((String)modeName);
        switch (pitchMode) {
            case 0: {
                return "PitchMode-Normal";
            }
            case 2: {
                return "PitchMode-BPM";
            }
            case 3: {
                return "PitchMode-Deck";
            }
        }
        return "PitchMode-Custom";
    }

    @Override
    protected synchronized void refreshViewSettings() {
        ColorButton[] buttons;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsPitchModeDefaultColor();
        this.buttonStyleDefault = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        Color[] pitchModeColors = viewSettings.getDvsPitchModeColors();
        if (pitchModeColors != null) {
            int num = pitchModeColors.length;
            ColorButtonStyle[] arr = new ColorButtonStyle[num];
            for (int i = 0; i < num; ++i) {
                ColorButtonStyle style;
                col = pitchModeColors[i];
                arr[i] = style = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
            }
            this.buttonStyles = arr;
        }
        if ((buttons = this.pitchModeButtons) != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshPitchModeButton(i);
            }
        }
    }

    protected void refreshPitchModeButton(int index) {
        ColorButton button;
        PitchModeControl control;
        ScratchDeck scratchDeck = this.scratchDeck;
        Object[] modes = null;
        Object mode = null;
        if (scratchDeck != null && (control = scratchDeck.getPitchModeControl()) != null) {
            modes = control.getValues();
            mode = control.getValue();
        }
        ColorButton[] buttons = this.pitchModeButtons;
        if (index >= 0 && index < buttons.length && (button = buttons[index]) != null) {
            boolean selected = false;
            if (mode != null && modes != null && index < modes.length) {
                selected = mode.equals(modes[index]);
            }
            if (selected != button.isSelected()) {
                button.setSelected(selected);
            }
            ColorButtonStyle style = this.buttonStyleDefault;
            if (button.isSelected()) {
                if (this.buttonStyles != null && index < this.buttonStyles.length) {
                    style = this.buttonStyles[index];
                }
                if (style == null) {
                    style = this.buttonStyleDefault;
                }
            }
            button.setColorButtonStyle(style);
        }
    }

    protected void handlePitchModePressed(int index, Object modeValue) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handlePitchModePressed: #" + index + " -> " + modeValue);
        }
        if ((deck = this.scratchDeck) == null) {
            return;
        }
        PitchModeControl control = deck.getPitchModeControl();
        if (control == null) {
            return;
        }
        if (control.isValueSupported(modeValue)) {
            control.setValue(modeValue);
        }
    }

    protected void handlePitchModeReleased(int index, Object modeValue) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handlePitchModeReleased: #" + index + " -> " + modeValue);
        }
    }

    public void pitchModeChanged(ScratchDeck deck, int mode) {
        ColorButton[] buttons = this.pitchModeButtons;
        if (buttons != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshPitchModeButton(i);
            }
        }
    }

    protected class PitchModeButtonHandler
    extends ColorButtonAdapter {
        private int pitchModeIndex;
        private Object pitchModeValue;

        public PitchModeButtonHandler(int pitchModeIndex, Object pitchModeValue) {
            this.pitchModeIndex = pitchModeIndex;
            this.pitchModeValue = pitchModeValue;
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckPitchModePanel.this.handlePitchModePressed(this.pitchModeIndex, this.pitchModeValue);
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckPitchModePanel.this.handlePitchModePressed(this.pitchModeIndex, this.pitchModeValue);
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckPitchModePanel.this.handlePitchModeReleased(this.pitchModeIndex, this.pitchModeValue);
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckPitchModePanel.this.handlePitchModeReleased(this.pitchModeIndex, this.pitchModeValue);
        }
    }
}

