/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioSlice;
import com.waxmonster.view.AbstractView;
import com.waxmonster.waxlab.CuePoint;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class DeckScratchCuePointsView
extends AbstractView {
    private int deckLayout = 1;
    private ScratchDeck scratchDeck;
    private double zoomRate;
    private WaxLabViewSettings viewSettings;
    private Color loopSliceColor = Color.CYAN;
    private CuePointInfo[] cuePointArray;
    private int cuePointCount;
    private Rectangle rect;
    private int[] polyX = new int[8];
    private int[] polyY = new int[8];
    private int cuePointSizeDivisor = 12;

    public DeckScratchCuePointsView() {
        this.rect = new Rectangle();
    }

    public void paint(Graphics2D g) {
        int num;
        AudioScratchModel model;
        AudioSlice slice;
        int w = this.bounds.width;
        int h = this.bounds.height;
        this.rect = g.getClipBounds(this.rect);
        boolean horiz = this.deckLayout == 0;
        ScratchDeck scratchDeck = this.scratchDeck;
        AudioSlice audioSlice = slice = scratchDeck == null ? null : scratchDeck.getLoopSlice();
        if (slice != null && (model = scratchDeck.getScratchModel()) != null) {
            double ofs = slice.getOffset() - model.getAnchor();
            double end = ofs + slice.getLength();
            double pixOfs = ofs * this.zoomRate / 1000.0;
            double pixEnd = end * this.zoomRate / 1000.0;
            if (horiz) {
                if (pixEnd > (double)this.rect.x && pixOfs < (double)(this.rect.x + this.rect.width)) {
                    g.setColor(this.loopSliceColor);
                    g.fillRect((int)pixOfs, 0, (int)(pixEnd - pixOfs + 1.0), h);
                }
            } else if (pixEnd > (double)this.rect.y && pixOfs < (double)(this.rect.y + this.rect.height)) {
                g.setColor(this.loopSliceColor);
                g.fillRect(0, (int)pixOfs, w, (int)(pixEnd - pixOfs + 1.0));
            }
        }
        if ((num = this.cuePointCount) > 0) {
            int pixMax;
            int pixMin;
            int polyW;
            int polyH;
            if (horiz) {
                polyH = h / this.cuePointSizeDivisor;
                polyW = polyH * 2 / 3;
                pixMin = this.rect.x - polyW;
                pixMax = pixMin + this.rect.width + polyW;
            } else {
                polyW = w / this.cuePointSizeDivisor;
                polyH = polyW * 2 / 3;
                pixMin = this.rect.y - polyH;
                pixMax = pixMin + this.rect.height + polyH;
            }
            CuePointInfo[] arr = this.cuePointArray;
            boolean antiAlias = true;
            for (int i = 0; i < num; ++i) {
                CuePointInfo info = arr[i];
                double pix = info.pix;
                if (pix < (double)pixMin) continue;
                if (pix > (double)pixMax) break;
                if (antiAlias) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    antiAlias = false;
                }
                g.setColor(info.col);
                if (horiz) {
                    int x;
                    this.polyX[0] = x = (int)pix;
                    this.polyY[0] = polyH;
                    this.polyX[1] = x - polyW;
                    this.polyY[1] = 0;
                    this.polyX[2] = x + polyW;
                    this.polyY[2] = 0;
                    this.polyX[3] = x;
                    this.polyY[3] = polyH;
                    this.polyX[4] = x;
                    this.polyY[4] = h - 1 - polyH;
                    this.polyX[5] = x - polyW;
                    this.polyY[5] = h - 1;
                    this.polyX[6] = x + polyW;
                    this.polyY[6] = h - 1;
                    this.polyX[7] = x;
                    this.polyY[7] = h - 1 - polyH;
                    g.fillPolygon(this.polyX, this.polyY, 8);
                    g.drawPolygon(this.polyX, this.polyY, 8);
                    continue;
                }
                int y = (int)pix;
                this.polyX[0] = polyW;
                this.polyY[0] = y;
                this.polyX[1] = 0;
                this.polyY[1] = y - polyH;
                this.polyX[2] = 0;
                this.polyY[2] = y + polyH;
                this.polyX[3] = polyW;
                this.polyY[3] = y;
                this.polyX[4] = w - 1 - polyW;
                this.polyY[4] = y;
                this.polyX[5] = w - 1;
                this.polyY[5] = y - polyH;
                this.polyX[6] = w - 1;
                this.polyY[6] = y + polyH;
                this.polyX[7] = w - 1 - polyW;
                this.polyY[7] = y;
                g.fillPolygon(this.polyX, this.polyY, 8);
                g.drawPolygon(this.polyX, this.polyY, 8);
            }
        }
    }

    public void flush() {
    }

    public void cuePointAdded(ScratchDeck deck, int index) {
        this.refreshCuePoints();
    }

    public void cuePointRemoved(ScratchDeck deck, int index) {
        this.refreshCuePoints();
    }

    public void cuePointChanged(ScratchDeck deck, int index) {
        this.refreshCuePoints();
    }

    public void refreshCuePoints() {
        ScratchDeck scratchDeck = this.scratchDeck;
        int num = scratchDeck == null ? 0 : scratchDeck.getCuePointCount();
        CuePointInfo[] arr = this.cuePointArray;
        if (arr == null || arr.length < num) {
            arr = new CuePointInfo[num];
            for (int i = 0; i < num; ++i) {
                arr[i] = new CuePointInfo();
            }
        }
        int newCount = 0;
        if (this.viewSettings != null) {
            double pos;
            CuePoint qp;
            Color cuePointDefaultColor = this.viewSettings.getDvsCuePointDefaultColor();
            Color[] cuePointColors = this.viewSettings.getDvsCuePointColors();
            for (int i = 0; i < num && (qp = scratchDeck.getSortedCuePointAt(i)) != null && !Double.isNaN(pos = qp.getPosition()); ++i) {
                Color col;
                double pix = pos * this.zoomRate / 1000.0;
                int idx = qp.getIndex();
                Color color = col = idx < cuePointColors.length ? cuePointColors[idx] : null;
                if (col == null) {
                    col = cuePointDefaultColor;
                }
                arr[newCount].pix = pix;
                arr[newCount].col = col;
                ++newCount;
            }
        }
        this.cuePointArray = arr;
        this.cuePointCount = newCount;
    }

    public ScratchDeck getScratchDeck() {
        return this.scratchDeck;
    }

    public void setScratchDeck(ScratchDeck scratchDeck) {
        this.scratchDeck = scratchDeck;
        this.refreshCuePoints();
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        this.deckLayout = deckLayout;
        this.refreshCuePoints();
    }

    public double getZoomRate() {
        return this.zoomRate;
    }

    public void setZoomRate(double zoomRate) {
        this.zoomRate = zoomRate;
        this.refreshCuePoints();
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        if (viewSettings != null) {
            this.loopSliceColor = viewSettings.getDvsLoopSliceColor();
        }
        this.refreshCuePoints();
    }

    protected class CuePointInfo {
        protected double pix;
        protected Color col;

        protected CuePointInfo() {
        }
    }
}

