/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchModeControl;
import com.waxmonster.waxlab.dvs.AbstractControlElementPanel;
import com.waxmonster.waxlab.dvs.DvsButtonsPanel;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class DeckScratchModePanel
extends AbstractControlElementPanel {
    private static final long serialVersionUID = 4297647228916692220L;
    private static final Logger logger = Logger.getLogger(DeckScratchModePanel.class.getName());
    private ColorButtonStyle[] buttonStyles;
    private ColorButtonStyle buttonStyleDefault;
    private ColorButton[] scratchModeButtons = new ColorButton[0];
    private DvsButtonsPanel buttonsPanel;

    public DeckScratchModePanel() {
        this.setLayout(new GridLayout(1, 1));
        this.setTitle("Scratch Mode");
        this.buttonsPanel = new DvsButtonsPanel();
        this.add(this.buttonsPanel);
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        dst.width = this.scratchModeButtons.length;
        dst.height = 1.0;
    }

    @Override
    public void setVariableFactor(double variableFactor) {
        super.setVariableFactor(variableFactor);
        this.resizeComponents((JComponent[])this.scratchModeButtons, variableFactor);
        this.buttonsPanel.invalidate();
    }

    @Override
    protected synchronized void refreshScratchDeck() {
        int oldCount;
        int newCount;
        ScratchModeControl control;
        ScratchDeck scratchDeck = this.scratchDeck;
        Object[] modes = null;
        if (scratchDeck != null && (control = scratchDeck.getScratchModeControl()) != null) {
            modes = control.getValues();
        }
        if ((newCount = modes == null ? 0 : modes.length) != (oldCount = this.scratchModeButtons.length)) {
            ColorButton[] arr = new ColorButton[newCount];
            int num = Math.min(oldCount, newCount);
            System.arraycopy(this.scratchModeButtons, 0, arr, 0, num);
            for (int i = num; i < newCount; ++i) {
                Object mode = modes[i];
                String modeName = String.valueOf(mode);
                String modeText = modeName.length() > 0 ? modeName.substring(0, 1) : String.valueOf(i + 1);
                ColorButton button = this.createDvsColorButton("ScratchMode#" + i, modeText, this.buttonStyleDefault);
                button.addColorButtonListener((ColorButtonListener)new ScratchModeButtonHandler(i, mode));
                button.setToolTipText("Scratch-Mode: " + modeName);
                button.setToolTipEnabled(false);
                button.setDisarmed(true);
                button.setRequestFocusEnabled(false);
                arr[i] = button;
                this.midiMapper.registerMidiAction(button, this.getScratchModeMidiAction(modeName));
            }
            this.scratchModeButtons = arr;
        }
        this.buttonsPanel.setButtons((Component[])this.scratchModeButtons);
    }

    protected String getScratchModeMidiAction(String modeName) {
        int scratchMode = AbstractScratchModeControl.getTimecodeDecoderMode((String)modeName);
        switch (scratchMode) {
            case 2: {
                return "ScratchMode-Absolute";
            }
            case 1: {
                return "ScratchMode-Relative";
            }
            case 3: {
                return "ScratchMode-Splatter";
            }
            case 4: {
                return "ScratchMode-Ultimate";
            }
            case 0: {
                return "ScratchMode-Internal";
            }
        }
        return "ScratchMode-Relative";
    }

    @Override
    protected synchronized void refreshViewSettings() {
        ColorButton[] buttons;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Color col = viewSettings.getDvsScratchModeDefaultColor();
        this.buttonStyleDefault = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
        Color[] scratchModeColors = viewSettings.getDvsScratchModeColors();
        if (scratchModeColors != null) {
            int num = scratchModeColors.length;
            ColorButtonStyle[] arr = new ColorButtonStyle[num];
            for (int i = 0; i < num; ++i) {
                ColorButtonStyle style;
                col = scratchModeColors[i];
                arr[i] = style = col == null ? this.defaultButtonStyle : this.createColorButtonStyle(col);
            }
            this.buttonStyles = arr;
        }
        if ((buttons = this.scratchModeButtons) != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshScratchModeButton(i);
            }
        }
    }

    protected void refreshScratchModeButton(int index) {
        ColorButton button;
        ScratchModeControl control;
        ScratchDeck scratchDeck = this.scratchDeck;
        Object[] modes = null;
        Object mode = null;
        if (scratchDeck != null && (control = scratchDeck.getScratchModeControl()) != null) {
            modes = control.getValues();
            mode = control.getValue();
        }
        ColorButton[] buttons = this.scratchModeButtons;
        if (index >= 0 && index < buttons.length && (button = buttons[index]) != null) {
            boolean selected = false;
            if (mode != null && modes != null && index < modes.length) {
                selected = mode.equals(modes[index]);
            }
            if (selected != button.isSelected()) {
                button.setSelected(selected);
            }
            ColorButtonStyle style = this.buttonStyleDefault;
            if (button.isSelected()) {
                if (this.buttonStyles != null && index < this.buttonStyles.length) {
                    style = this.buttonStyles[index];
                }
                if (style == null) {
                    style = this.buttonStyleDefault;
                }
            }
            button.setColorButtonStyle(style);
        }
    }

    protected void handleScratchModePressed(int index, Object modeValue) {
        ScratchDeck deck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleScratchModePressed: #" + index + " -> " + modeValue);
        }
        if ((deck = this.scratchDeck) == null) {
            return;
        }
        ScratchModeControl control = deck.getScratchModeControl();
        if (control == null) {
            return;
        }
        if (control.isValueSupported(modeValue)) {
            control.setValue(modeValue);
        }
    }

    protected void handleScratchModeReleased(int index, Object modeValue) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("handleScratchModeReleased: #" + index + " -> " + modeValue);
        }
    }

    public void scratchModeChanged(ScratchDeck deck, int mode) {
        ColorButton[] buttons = this.scratchModeButtons;
        if (buttons != null) {
            for (int i = 0; i < buttons.length; ++i) {
                this.refreshScratchModeButton(i);
            }
        }
    }

    protected class ScratchModeButtonHandler
    extends ColorButtonAdapter {
        private int scratchModeIndex;
        private Object scratchModeValue;

        public ScratchModeButtonHandler(int scratchModeIndex, Object scratchModeValue) {
            this.scratchModeIndex = scratchModeIndex;
            this.scratchModeValue = scratchModeValue;
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DeckScratchModePanel.this.handleScratchModePressed(this.scratchModeIndex, this.scratchModeValue);
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DeckScratchModePanel.this.handleScratchModePressed(this.scratchModeIndex, this.scratchModeValue);
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
            DeckScratchModePanel.this.handleScratchModeReleased(this.scratchModeIndex, this.scratchModeValue);
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
            DeckScratchModePanel.this.handleScratchModeReleased(this.scratchModeIndex, this.scratchModeValue);
        }
    }
}

