/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.view.ScrollPos;
import com.waxmonster.view.ScrollView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewComponent;
import com.waxmonster.waxlab.dvs.DeckScratchCuePointsView;
import com.waxmonster.waxlab.dvs.DeckScratchMiddleView;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;

public class DeckScratchViewComponent
extends ViewComponent {
    private static final long serialVersionUID = 2664586781197091117L;
    private static final int MAX = 0x3FFFFFFF;
    private int deckLayout = 1;
    private boolean leftDeck;
    private View[] scratchViews = new View[0];
    private ScrollView scratchScrollView = new ScrollView();
    private TileView scratchTileView;
    private DeckScratchCuePointsView cuePointsView;
    private DeckScratchMiddleView middleLineView;
    private double zoomRate;
    private WaxLabViewSettings viewSettings;

    public DeckScratchViewComponent() {
        this.resetViews();
    }

    public void doLayout() {
        super.doLayout();
        this.adjustViews();
    }

    protected void resetViews() {
        View[] views = new View[]{this.scratchScrollView, this.middleLineView};
        this.setViews(views);
    }

    protected void adjustViews() {
        Rectangle bounds;
        Object view;
        int width = this.getWidth();
        int height = this.getHeight();
        TileView tileView = this.scratchTileView;
        int tileWidth = width;
        int tileHeight = height;
        if (tileView != null && (tileView.getTileWidth() != tileWidth || tileView.getTileHeight() != tileHeight)) {
            tileView.flush();
            tileView = null;
        }
        if (tileView == null && this.viewSettings != null) {
            int maxTileCacheCount = this.viewSettings.getDvsAudioTileCacheCount();
            if (maxTileCacheCount < 1) {
                maxTileCacheCount = 1;
            }
            Color audioLineBackground = this.viewSettings.getDvsAudioViewBackground();
            this.scratchTileView = tileView = new TileView(tileWidth, tileHeight, maxTileCacheCount, (Paint)audioLineBackground);
            this.scratchScrollView.setViews(new View[]{tileView, this.cuePointsView});
        }
        if (tileView != null) {
            tileView.replaceAllViews(this.scratchViews);
            tileView.invalidate();
        }
        if ((view = this.scratchScrollView) != null) {
            int viewHeight;
            int viewWidth;
            bounds = view.getBounds();
            bounds.x = 0;
            bounds.y = 0;
            bounds.width = width;
            bounds.height = height;
            view.setBounds(bounds);
            if (this.deckLayout == 0) {
                viewWidth = 0x3FFFFFFF;
                viewHeight = height;
            } else {
                viewWidth = width;
                viewHeight = 0x3FFFFFFF;
            }
            for (int i = 0; i < this.scratchViews.length; ++i) {
                bounds = this.scratchViews[i].getBounds();
                bounds.width = viewWidth;
                bounds.height = viewHeight;
                this.scratchViews[i].setBounds(bounds);
            }
            if (this.cuePointsView != null) {
                bounds = this.cuePointsView.getBounds();
                bounds.width = viewWidth;
                bounds.height = viewHeight;
                this.cuePointsView.setBounds(bounds);
            }
        }
        if ((view = this.middleLineView) != null) {
            bounds = view.getBounds();
            bounds.x = 0;
            bounds.y = 0;
            bounds.width = width;
            bounds.height = height;
            view.setBounds(bounds);
        }
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        this.deckLayout = deckLayout;
    }

    public boolean isLeftDeck() {
        return this.leftDeck;
    }

    public void setLeftDeck(boolean leftDeck) {
        this.leftDeck = leftDeck;
    }

    public DeckScratchCuePointsView getCuePointsView() {
        return this.cuePointsView;
    }

    public void setCuePointsView(DeckScratchCuePointsView cuePointsView) {
        this.cuePointsView = cuePointsView;
        this.resetViews();
        this.adjustViews();
    }

    public DeckScratchMiddleView getMiddleLineView() {
        return this.middleLineView;
    }

    public void setMiddleLineView(DeckScratchMiddleView middleLineView) {
        this.middleLineView = middleLineView;
        this.resetViews();
        this.adjustViews();
    }

    public View[] getScratchViews() {
        return this.scratchViews;
    }

    public void setScratchViews(View[] scratchViews) {
        this.scratchViews = scratchViews;
    }

    public double getZoomRate() {
        return this.zoomRate;
    }

    public synchronized void setZoomRate(double zoomRate) {
        if (this.zoomRate == zoomRate) {
            return;
        }
        this.zoomRate = zoomRate;
        TileView tileView = this.scratchTileView;
        if (tileView != null) {
            tileView.invalidate();
        }
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
    }

    public void scrollScratchView(double modelPosition) {
        double pix = modelPosition * this.zoomRate / 1000.0;
        ScrollPos p = this.scratchScrollView.getPosition();
        switch (this.deckLayout) {
            case 0: {
                p.x = (long)(pix - (double)this.scratchScrollView.getWidth() / 2.0);
                p.y = 0L;
                break;
            }
            case 1: {
                p.x = 0L;
                p.y = (long)(pix - (double)this.scratchScrollView.getHeight() / 2.0);
            }
        }
        this.scratchScrollView.setPosition(p);
    }
}

