/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.view.AbstractView;
import com.waxmonster.waxlab.ScratchDeck;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class DeckTrackPositionView
extends AbstractView {
    private int deckLayout = 1;
    private Color lineColor = Color.WHITE;
    private ScratchDeck scratchDeck;
    private boolean leftDeck;
    private int[] polyX = new int[5];
    private int[] polyY = new int[5];

    public void paint(Graphics2D g) {
        ScratchDeck deck = this.scratchDeck;
        if (deck == null) {
            return;
        }
        AudioScratchPlayer player = deck.getScratchPlayer();
        if (player == null) {
            return;
        }
        AudioScratchModel model = deck.getScratchModel();
        if (model == null) {
            return;
        }
        double duration = model.getDuration();
        double pos = player.getOffset() - model.getAnchor();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.deckLayout == 0) {
            int h = this.bounds.height;
            int w = this.bounds.width - 1;
            int x = (int)Math.round((double)w * pos / duration);
            if (x < 0) {
                x = 0;
            } else if (x > w) {
                x = w;
            }
            int polyH = h / 3;
            int polyW = polyH * 2 / 3;
            this.polyX[0] = x;
            this.polyY[0] = h;
            this.polyX[1] = x;
            this.polyY[1] = polyH;
            this.polyX[2] = x - polyW;
            this.polyY[2] = 0;
            this.polyX[3] = x + polyW;
            this.polyY[3] = 0;
            this.polyX[4] = x;
            this.polyY[4] = polyH;
            g.setColor(this.lineColor);
            g.fillPolygon(this.polyX, this.polyY, 5);
            g.drawPolygon(this.polyX, this.polyY, 5);
        } else {
            int w = this.bounds.width;
            int h = this.bounds.height - 1;
            int y = (int)Math.round((double)h * pos / duration);
            if (y < 0) {
                y = 0;
            } else if (y > h) {
                y = h;
            }
            int polyW = w / 3;
            int polyH = polyW * 2 / 3;
            if (this.leftDeck) {
                this.polyX[0] = 0;
                this.polyY[0] = y;
                this.polyX[1] = w - 1 - polyW;
                this.polyY[1] = y;
                this.polyX[2] = w - 1;
                this.polyY[2] = y - polyH;
                this.polyX[3] = w - 1;
                this.polyY[3] = y + polyH;
                this.polyX[4] = w - 1 - polyW;
                this.polyY[4] = y;
            } else {
                this.polyX[0] = w;
                this.polyY[0] = y;
                this.polyX[1] = polyW;
                this.polyY[1] = y;
                this.polyX[2] = 0;
                this.polyY[2] = y - polyH;
                this.polyX[3] = 0;
                this.polyY[3] = y + polyH;
                this.polyX[4] = polyW;
                this.polyY[4] = y;
            }
            g.setColor(this.lineColor);
            g.fillPolygon(this.polyX, this.polyY, 5);
            g.drawPolygon(this.polyX, this.polyY, 5);
        }
    }

    public void flush() {
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        this.deckLayout = deckLayout;
    }

    public ScratchDeck getScratchDeck() {
        return this.scratchDeck;
    }

    public void setScratchDeck(ScratchDeck scratchDeck) {
        this.scratchDeck = scratchDeck;
    }

    public boolean isLeftDeck() {
        return this.leftDeck;
    }

    public void setLeftDeck(boolean leftDeck) {
        this.leftDeck = leftDeck;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }
}

