/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.waxlab.CuePoint;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class DeckTrackTouchPanel
extends JComponent {
    private static final long serialVersionUID = 5914770830763947306L;
    private ScratchDeck scratchDeck;
    private boolean leftDeck;
    private WaxLabViewSettings viewSettings;
    private int deckLayout = 1;
    private Paint backPaint = Color.GREEN;
    private int[] polyX = new int[4];
    private int[] polyY = new int[4];

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[bounds=" + this.getBounds() + "]";
    }

    public ScratchDeck getScratchDeck() {
        return this.scratchDeck;
    }

    public void setScratchDeck(ScratchDeck scratchDeck) {
        this.scratchDeck = scratchDeck;
        this.refreshDeckInfo();
    }

    public void refreshDeckInfo() {
        this.repaint();
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.refreshViewSettings();
    }

    public void refreshViewSettings() {
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Paint paint = viewSettings.getDvsTouchBackground();
        if (paint != null) {
            this.setBackPaint(paint);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        double duration;
        ScratchDeck scratchDeck;
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        if (this.backPaint != null) {
            g2d.setPaint(this.backPaint);
            g2d.fillRect(0, 0, w, h);
        }
        if ((scratchDeck = this.scratchDeck) == null) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AudioScratchModel scratchModel = scratchDeck.getScratchModel();
        if (scratchModel != null && (duration = scratchModel.getDuration()) >= 0.0) {
            double pos;
            CuePoint qp;
            int polyW;
            int polyH;
            boolean horiz = this.deckLayout == 0;
            Color cuePointDefaultColor = this.viewSettings.getDvsCuePointDefaultColor();
            Color[] cuePointColors = this.viewSettings.getDvsCuePointColors();
            int num = scratchDeck.getCuePointCount();
            if (horiz) {
                polyH = h - 1;
                polyW = polyH * 2 / 3;
            } else {
                polyW = this.leftDeck ? 1 - w : w - 1;
                polyH = polyW * 2 / 3;
            }
            for (int i = 0; i < num && (qp = scratchDeck.getSortedCuePointAt(i)) != null && !Double.isNaN(pos = qp.getPosition()); ++i) {
                int y;
                int x;
                long pix;
                Color col;
                int idx = qp.getIndex();
                Color color = col = idx < cuePointColors.length ? cuePointColors[idx] : null;
                if (col == null) {
                    col = cuePointDefaultColor;
                }
                if (horiz) {
                    pix = Math.round((double)(w - 1) * pos / duration);
                    if (pix < 0L || pix >= (long)w) continue;
                    g2d.setColor(col);
                    x = (int)pix;
                    y = 0;
                    this.polyX[0] = x;
                    this.polyY[0] = y;
                    this.polyX[1] = x + polyW;
                    this.polyY[1] = y + polyH;
                    this.polyX[2] = x - polyW;
                    this.polyY[2] = y + polyH;
                    this.polyX[3] = x;
                    this.polyY[3] = y;
                    g2d.fillPolygon(this.polyX, this.polyY, 4);
                    continue;
                }
                pix = Math.round((double)(h - 1) * pos / duration);
                if (pix < 0L || pix >= (long)h) continue;
                x = this.leftDeck ? w - 1 : 0;
                y = (int)pix;
                g2d.setColor(col);
                this.polyX[0] = x;
                this.polyY[0] = y;
                this.polyX[1] = x + polyW;
                this.polyY[1] = y + polyH;
                this.polyX[2] = x + polyW;
                this.polyY[2] = y - polyH;
                this.polyX[3] = x;
                this.polyY[3] = y;
                g2d.fillPolygon(this.polyX, this.polyY, 4);
            }
        }
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }

    public void cuePointAdded(ScratchDeck deck, int index) {
        this.repaint();
    }

    public void cuePointRemoved(ScratchDeck deck, int index) {
        this.repaint();
    }

    public void cuePointChanged(ScratchDeck deck, int index) {
        this.repaint();
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        this.deckLayout = deckLayout;
        this.repaint();
    }

    public boolean isLeftDeck() {
        return this.leftDeck;
    }

    public void setLeftDeck(boolean leftDeck) {
        this.leftDeck = leftDeck;
        this.repaint();
    }
}

