/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewComponent;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;

public class DeckTrackViewComponent
extends ViewComponent {
    private static final long serialVersionUID = 2664586781197091117L;
    private int deckLayout = 1;
    private boolean leftDeck;
    private View[] trackViews = new View[0];
    private View positionLineView;
    private TileView trackTileView;
    private double zoomRate;

    public void doLayout() {
        super.doLayout();
        this.adjustViews();
    }

    public void adjustViews() {
        Rectangle bounds;
        int w = this.getWidth();
        int h = this.getHeight();
        TileView tileView = this.trackTileView;
        int tileWidth = w;
        int tileHeight = h;
        if (tileView != null && (tileView.getTileWidth() != tileWidth || tileView.getTileHeight() != tileHeight)) {
            tileView.flush();
            tileView = null;
        }
        if (tileView == null) {
            int maxTileCacheCount = 30;
            if (maxTileCacheCount < 1) {
                maxTileCacheCount = 1;
            }
            Color audioLineBackground = new Color(0.23f, 0.23f, 0.23f);
            this.trackTileView = tileView = new TileView(tileWidth, tileHeight, maxTileCacheCount, (Paint)audioLineBackground);
        }
        tileView.replaceAllViews(this.trackViews);
        tileView.invalidate();
        TileView view = this.trackTileView;
        if (view != null) {
            bounds = view.getBounds();
            bounds.x = 0;
            bounds.y = 0;
            bounds.width = w;
            bounds.height = h;
            view.setBounds(bounds);
            for (int i = 0; i < this.trackViews.length; ++i) {
                bounds = this.trackViews[i].getBounds();
                bounds.width = w;
                bounds.height = h;
                this.trackViews[i].setBounds(bounds);
            }
        }
        if ((view = this.positionLineView) != null) {
            bounds = view.getBounds();
            bounds.x = 0;
            bounds.y = 0;
            bounds.width = w;
            bounds.height = h;
            view.setBounds(bounds);
        }
        this.setViews(new View[]{this.trackTileView, this.positionLineView});
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        this.deckLayout = deckLayout;
    }

    public boolean isLeftDeck() {
        return this.leftDeck;
    }

    public void setLeftDeck(boolean leftDeck) {
        this.leftDeck = leftDeck;
    }

    public View getPositionLineView() {
        return this.positionLineView;
    }

    public void setPositionLineView(View positionLineView) {
        this.positionLineView = positionLineView;
    }

    public View[] getTrackViews() {
        return this.trackViews;
    }

    public void setTrackViews(View[] trackViews) {
        this.trackViews = trackViews;
    }

    public double getZoomRate() {
        return this.zoomRate;
    }

    public synchronized void setZoomRate(double zoomRate) {
        if (this.zoomRate == zoomRate) {
            return;
        }
        this.zoomRate = zoomRate;
        TileView tileView = this.trackTileView;
        if (tileView != null) {
            tileView.invalidate();
        }
    }
}

