/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.DefaultAudioChunk;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.model.view.ChunkModelLineView;
import com.waxmonster.model.view.ChunkRenderer;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.view.View;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchDeckListener;
import com.waxmonster.waxlab.dvs.DeckAutoLoopsPanel;
import com.waxmonster.waxlab.dvs.DeckBeatJumpPanel;
import com.waxmonster.waxlab.dvs.DeckBeatSlicerPanel;
import com.waxmonster.waxlab.dvs.DeckBeatSlicesPanel;
import com.waxmonster.waxlab.dvs.DeckClockViewComponent;
import com.waxmonster.waxlab.dvs.DeckCuePointsPanel;
import com.waxmonster.waxlab.dvs.DeckLoopRollsPanel;
import com.waxmonster.waxlab.dvs.DeckPitchInfoPanel;
import com.waxmonster.waxlab.dvs.DeckPitchModePanel;
import com.waxmonster.waxlab.dvs.DeckScratchCuePointsView;
import com.waxmonster.waxlab.dvs.DeckScratchMiddleView;
import com.waxmonster.waxlab.dvs.DeckScratchModePanel;
import com.waxmonster.waxlab.dvs.DeckScratchViewComponent;
import com.waxmonster.waxlab.dvs.DeckTrackPositionView;
import com.waxmonster.waxlab.dvs.DeckTrackTouchPanel;
import com.waxmonster.waxlab.dvs.DeckTrackViewComponent;
import com.waxmonster.waxlab.dvs.DvsDeckControlElement;
import com.waxmonster.waxlab.dvs.DvsDeckControlPanel;
import com.waxmonster.waxlab.dvs.DvsDeckControlTab;
import com.waxmonster.waxlab.dvs.DvsDeckHeaderPanel;
import com.waxmonster.waxlab.view.ChunkRendererUtil;
import com.waxmonster.waxlab.view.ClockScratchPositionView;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;

public class DvsDeck {
    public static final double DEFAULT_ZOOM_RATE = 150.0;
    private ScratchDeck scratchDeck;
    private boolean leftDeck;
    private int deckLayout = 1;
    private WaxLabViewSettings viewSettings;
    private int audioInitCapacity;
    private final ScratchDeckHandler scratchDeckHandler = new ScratchDeckHandler();
    private DvsDeckHeaderPanel deckHeaderPanel = new DvsDeckHeaderPanel();
    private DvsDeckControlPanel deckControlPanel = new DvsDeckControlPanel();
    private DeckScratchModePanel scratchModePanel = new DeckScratchModePanel();
    private DeckPitchModePanel pitchModePanel = new DeckPitchModePanel();
    private DeckPitchInfoPanel pitchInfoPanel = new DeckPitchInfoPanel();
    private DeckCuePointsPanel cuePointsPanel = new DeckCuePointsPanel();
    private DeckBeatJumpPanel beatJumpPanel = new DeckBeatJumpPanel();
    private DeckLoopRollsPanel loopRollsPanel = new DeckLoopRollsPanel();
    private DeckAutoLoopsPanel autoLoopsPanel = new DeckAutoLoopsPanel();
    private DeckBeatSlicerPanel beatSlicerPanel = new DeckBeatSlicerPanel();
    private DeckBeatSlicesPanel beatSlicesPanel = new DeckBeatSlicesPanel();
    private DeckClockViewComponent clockViewComponent;
    private ClockScratchPositionView clockScratchPositionView;
    private DeckTrackTouchPanel trackTouchPanel;
    private AudioScratchPlayer scratchPlayer;
    private AudioScratchModel scratchModel;
    private AudioModel audioModel;
    private MutableLineChunk audioChunk;
    private DefaultChunkModel chunkModel;
    private DeckTrackViewComponent trackViewComponent;
    private ChunkModelLineView trackChunkModelView;
    private ChunkRenderer trackChunkRenderer;
    private DeckTrackPositionView positionLineView;
    private DeckScratchViewComponent scratchViewComponent;
    private ChunkModelLineView scratchChunkModelView;
    private ChunkRenderer scratchChunkRenderer;
    private DeckScratchCuePointsView scratchCuePointsView;
    private DeckScratchMiddleView scratchMiddleView;
    private double zoomRate = 1.0;

    public DvsDeck(LockFactory lockFactory) {
        DvsDeckControlElement scratchModeElement = new DvsDeckControlElement(this.scratchModePanel, 0, 0);
        DvsDeckControlElement pitchModeElement = new DvsDeckControlElement(this.pitchModePanel, 1, 0);
        DvsDeckControlElement pitchInfoElement = new DvsDeckControlElement(this.pitchInfoPanel, 2, 0);
        pitchInfoElement.setWeightX(1.0);
        DvsDeckControlTab tab = new DvsDeckControlTab("Mode", "Mode", null, new DvsDeckControlElement[]{scratchModeElement, pitchModeElement, pitchInfoElement});
        this.deckControlPanel.addTab(tab);
        DvsDeckControlElement cuePointsElement = new DvsDeckControlElement(this.cuePointsPanel, 0, 0);
        DvsDeckControlElement beatJumpElement = new DvsDeckControlElement(this.beatJumpPanel, 1, 0);
        DvsDeckControlTab tab2 = new DvsDeckControlTab("Jump", "Jump", null, new DvsDeckControlElement[]{cuePointsElement, beatJumpElement});
        this.deckControlPanel.addTab(tab2);
        DvsDeckControlElement loopRollsElement = new DvsDeckControlElement(this.loopRollsPanel, 0, 0);
        DvsDeckControlElement autoLoopsElement = new DvsDeckControlElement(this.autoLoopsPanel, 1, 0);
        DvsDeckControlElement beatSlicerElement = new DvsDeckControlElement(this.beatSlicerPanel, 2, 0);
        DvsDeckControlElement beatSlicesElement = new DvsDeckControlElement(this.beatSlicesPanel, 3, 0);
        DvsDeckControlTab tab3 = new DvsDeckControlTab("Loop", "Loop", null, new DvsDeckControlElement[]{loopRollsElement, autoLoopsElement, beatSlicerElement, beatSlicesElement});
        this.deckControlPanel.addTab(tab3);
        this.clockScratchPositionView = new ClockScratchPositionView();
        this.clockScratchPositionView.setAutoHide(false);
        this.clockViewComponent = new DeckClockViewComponent();
        this.clockViewComponent.setOpaque(true);
        this.clockViewComponent.setViews(new View[]{this.clockScratchPositionView});
        this.clockViewComponent.setBack(Color.BLUE);
        this.clockViewComponent.setPreferredSize(new Dimension(200, 200));
        this.clockViewComponent.setMinimumSize(new Dimension(50, 50));
        this.trackTouchPanel = new DeckTrackTouchPanel();
        this.trackTouchPanel.setOpaque(true);
        this.trackTouchPanel.setBackPaint(Color.GREEN);
        this.trackTouchPanel.setPreferredSize(new Dimension(10, 10));
        this.trackTouchPanel.setMinimumSize(new Dimension(5, 5));
        this.trackTouchPanel.setCursor(Cursor.getPredefinedCursor(1));
        this.trackViewComponent = new DeckTrackViewComponent();
        this.trackViewComponent.setOpaque(true);
        this.trackViewComponent.setBack(Color.CYAN);
        this.trackViewComponent.setPreferredSize(new Dimension(50, 50));
        this.trackViewComponent.setMinimumSize(new Dimension(50, 10));
        this.trackViewComponent.setCursor(Cursor.getPredefinedCursor(1));
        int initChunkCapacity = 2;
        int initIntervalCapacity = 2;
        boolean fair = false;
        ReadWriteLock lock = lockFactory.createReadWriteLock(fair);
        this.chunkModel = new DefaultChunkModel(lock, initChunkCapacity, initIntervalCapacity);
        this.trackChunkModelView = new ChunkModelLineView();
        this.trackChunkModelView.setChunkModel((ChunkModel)this.chunkModel);
        this.positionLineView = new DeckTrackPositionView();
        this.trackViewComponent.setPositionLineView((View)this.positionLineView);
        this.scratchViewComponent = new DeckScratchViewComponent();
        this.scratchViewComponent.setOpaque(true);
        this.scratchViewComponent.setBack(Color.CYAN);
        this.scratchViewComponent.setPreferredSize(new Dimension(50, 50));
        this.scratchViewComponent.setMinimumSize(new Dimension(50, 10));
        this.scratchViewComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.scratchChunkModelView = new ChunkModelLineView();
        this.scratchChunkModelView.setChunkModel((ChunkModel)this.chunkModel);
        this.scratchChunkModelView.setZoomRate(this.zoomRate);
        this.scratchViewComponent.setScratchViews(new View[]{this.scratchChunkModelView});
        this.scratchCuePointsView = new DeckScratchCuePointsView();
        this.scratchViewComponent.setCuePointsView(this.scratchCuePointsView);
        this.scratchMiddleView = new DeckScratchMiddleView();
        this.scratchViewComponent.setMiddleLineView(this.scratchMiddleView);
        this.setZoomRate(150.0);
    }

    public ScratchDeck getScratchDeck() {
        return this.scratchDeck;
    }

    public synchronized void setScratchDeck(ScratchDeck newScratchDeck) {
        if (this.scratchDeck == newScratchDeck) {
            return;
        }
        if (this.scratchDeck != null) {
            this.scratchDeck.unregisterScratchDeckListener((ScratchDeckListener)this.scratchDeckHandler);
        }
        this.scratchDeck = newScratchDeck;
        if (this.scratchDeck != null) {
            this.scratchDeck.registerScratchDeckListener((ScratchDeckListener)this.scratchDeckHandler);
        }
        this.deckHeaderPanel.setScratchDeck(newScratchDeck);
        this.scratchModePanel.setScratchDeck(newScratchDeck);
        this.pitchModePanel.setScratchDeck(newScratchDeck);
        this.pitchInfoPanel.setScratchDeck(newScratchDeck);
        this.cuePointsPanel.setScratchDeck(newScratchDeck);
        this.beatJumpPanel.setScratchDeck(newScratchDeck);
        this.loopRollsPanel.setScratchDeck(newScratchDeck);
        this.autoLoopsPanel.setScratchDeck(newScratchDeck);
        this.beatSlicerPanel.setScratchDeck(newScratchDeck);
        this.beatSlicesPanel.setScratchDeck(newScratchDeck);
        this.trackTouchPanel.setScratchDeck(newScratchDeck);
        this.positionLineView.setScratchDeck(newScratchDeck);
        this.scratchCuePointsView.setScratchDeck(newScratchDeck);
    }

    public boolean isLeftDeck() {
        return this.leftDeck;
    }

    public void setLeftDeck(boolean leftDeck) {
        this.leftDeck = leftDeck;
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        this.deckLayout = deckLayout;
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public synchronized void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        if (viewSettings != null) {
            this.setAudioInitCapacity(viewSettings.getAudioInitCapacity());
            String audioRenderMode = "Colorized";
            this.trackChunkRenderer = ChunkRendererUtil.getInstance().createAudioChunkRenderer(audioRenderMode, this.audioInitCapacity, viewSettings);
            this.trackChunkModelView.setChunkRenderer(this.trackChunkRenderer);
            audioRenderMode = "Colorized";
            this.scratchChunkRenderer = ChunkRendererUtil.getInstance().createAudioChunkRenderer(audioRenderMode, this.audioInitCapacity, viewSettings);
            this.scratchChunkModelView.setChunkRenderer(this.scratchChunkRenderer);
            this.scratchViewComponent.setViewSettings(viewSettings);
            this.scratchCuePointsView.setViewSettings(viewSettings);
        }
    }

    public int getAudioInitCapacity() {
        return this.audioInitCapacity;
    }

    public void setAudioInitCapacity(int audioInitCapacity) {
        this.audioInitCapacity = audioInitCapacity;
    }

    public void scrollViews() {
        DeckScratchViewComponent scratchComp = this.scratchViewComponent;
        if (scratchComp != null) {
            AudioScratchModel model;
            double modelPosition = 0.0;
            AudioScratchPlayer player = this.scratchPlayer;
            if (player != null && (model = player.getAudioScratchModel()) != null) {
                double modelAnchor = model.getAnchor();
                double playerOffset = player.getOffset();
                modelPosition = playerOffset - modelAnchor;
            }
            scratchComp.scrollScratchView(modelPosition);
        }
    }

    public void repaintViews() {
        DeckTrackViewComponent trackComp;
        DeckScratchViewComponent scratchComp;
        DeckClockViewComponent clockComp = this.clockViewComponent;
        if (clockComp != null) {
            clockComp.repaint();
        }
        if ((scratchComp = this.scratchViewComponent) != null) {
            scratchComp.repaint();
        }
        if ((trackComp = this.trackViewComponent) != null) {
            trackComp.repaint();
        }
    }

    public void refreshDvsDeck() {
        ClockScratchPositionView clockView;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        this.deckHeaderPanel.setDeckLayout(this.deckLayout);
        this.deckHeaderPanel.setLeftDeck(this.leftDeck);
        this.deckHeaderPanel.setViewSettings(viewSettings);
        boolean horiz = this.deckLayout == 0;
        this.deckControlPanel.setButtonsConstraint(this.leftDeck | horiz ? "West" : "East");
        this.scratchModePanel.setViewSettings(viewSettings);
        this.pitchModePanel.setViewSettings(viewSettings);
        this.pitchInfoPanel.setViewSettings(viewSettings);
        this.cuePointsPanel.setViewSettings(viewSettings);
        this.beatJumpPanel.setViewSettings(viewSettings);
        this.loopRollsPanel.setViewSettings(viewSettings);
        this.autoLoopsPanel.setViewSettings(viewSettings);
        this.beatSlicerPanel.setViewSettings(viewSettings);
        this.beatSlicesPanel.setViewSettings(viewSettings);
        this.trackTouchPanel.setLeftDeck(this.leftDeck);
        this.trackTouchPanel.setViewSettings(viewSettings);
        this.trackTouchPanel.setDeckLayout(this.deckLayout);
        if (viewSettings != null) {
            Paint paint = viewSettings.getDvsBackground();
            if (paint != null) {
                this.clockViewComponent.setBack(paint);
            }
            if ((paint = viewSettings.getDvsTrackBackground()) != null) {
                this.trackViewComponent.setBack(paint);
                this.scratchViewComponent.setBack(paint);
            }
        }
        if ((clockView = this.clockScratchPositionView) != null) {
            clockView.setBounds(new Rectangle(0, 0, 100, 100));
            clockView.setViewSettings(viewSettings);
            clockView.setBeatRadarRendererEnabled(true);
            clockView.setBeatCompassLineRendererEnabled(false);
            clockView.setBeatCompassPolyRendererEnabled(false);
            this.clockViewComponent.setViews(new View[]{clockView});
        } else {
            this.clockViewComponent.setViews(new View[0]);
        }
        int orient = horiz ? 0 : 2;
        this.trackChunkModelView.setOrientation(orient);
        this.scratchChunkModelView.setOrientation(orient);
        DeckTrackPositionView positionLineView = this.positionLineView;
        positionLineView.setDeckLayout(this.deckLayout);
        positionLineView.setLeftDeck(this.leftDeck);
        DeckScratchCuePointsView cuePointsView = this.scratchCuePointsView;
        cuePointsView.setDeckLayout(this.deckLayout);
        DeckScratchMiddleView middleLineView = this.scratchMiddleView;
        middleLineView.setDeckLayout(this.deckLayout);
        if (viewSettings != null) {
            positionLineView.setLineColor(viewSettings.getDvsTrackPosCenterColor());
            middleLineView.setCenterLineColor(viewSettings.getDvsTrackPosCenterColor());
            middleLineView.setShadowLineColor(viewSettings.getDvsTrackPosShadowColor());
        }
        this.trackViewComponent.setDeckLayout(this.deckLayout);
        this.trackViewComponent.setLeftDeck(this.leftDeck);
        this.scratchViewComponent.setDeckLayout(this.deckLayout);
        this.scratchViewComponent.setLeftDeck(this.leftDeck);
    }

    public DvsDeckHeaderPanel getDeckHeaderPanel() {
        return this.deckHeaderPanel;
    }

    public DvsDeckControlPanel getDeckControlPanel() {
        return this.deckControlPanel;
    }

    public DeckClockViewComponent getClockViewComponent() {
        return this.clockViewComponent;
    }

    public DeckTrackTouchPanel getTrackTouchPanel() {
        return this.trackTouchPanel;
    }

    public DeckTrackViewComponent getTrackViewComponent() {
        return this.trackViewComponent;
    }

    public DeckScratchViewComponent getScratchViewComponent() {
        return this.scratchViewComponent;
    }

    protected void handleScratchPlayerChanged(ScratchDeck deck) {
        AudioScratchPlayer scratchPlayer;
        this.scratchPlayer = scratchPlayer = deck.getScratchPlayer();
        ClockScratchPositionView clockView = this.clockScratchPositionView;
        if (clockView != null) {
            clockView.setScratchPlayer(scratchPlayer);
        }
    }

    protected void handleScratchResourceHasChanged(ScratchDeck deck) {
        if (deck != this.scratchDeck) {
            return;
        }
        DvsDeckHeaderPanel panel = this.deckHeaderPanel;
        if (panel != null) {
            panel.scratchResourceHasChanged(deck);
        }
        AudioModel audioModel = null;
        if (deck != null) {
            SampleModel sampleModel;
            AudioScratchModel scratchModel;
            AudioScratchPlayer scratchPlayer;
            this.scratchPlayer = scratchPlayer = deck.getScratchPlayer();
            this.scratchModel = scratchModel = deck.getScratchModel();
            if (scratchModel != null && (sampleModel = scratchModel.getAudioModel()) != null && sampleModel instanceof AudioModel) {
                audioModel = (AudioModel)sampleModel;
            }
        }
        this.setAudioModel(audioModel);
        this.scrollViews();
        this.repaintViews();
    }

    public AudioModel getAudioModel() {
        return this.audioModel;
    }

    public synchronized void setAudioModel(AudioModel audioModel) {
        if (this.audioModel == audioModel) {
            return;
        }
        MutableLineChunk oldAudioChunk = this.audioChunk;
        this.audioModel = audioModel;
        DefaultAudioChunk audioChunk = null;
        if (audioModel != null) {
            long chunkOfs = 0L;
            long chunkEnd = Long.MAX_VALUE;
            long modelOfs = 0L;
            long modelEnd = Long.MAX_VALUE;
            audioChunk = new DefaultAudioChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, audioModel);
        }
        this.audioChunk = audioChunk;
        this.chunkModel.removeAllChunks();
        if (audioChunk != null) {
            this.chunkModel.addChunk(audioChunk);
        }
        if (oldAudioChunk != null) {
            oldAudioChunk.close();
        }
    }

    public synchronized double getZoomRate() {
        return this.zoomRate;
    }

    public synchronized void setZoomRate(double zoomRate) {
        if (this.zoomRate == zoomRate) {
            return;
        }
        this.zoomRate = zoomRate;
        this.scratchChunkModelView.setZoomRate(zoomRate);
        this.scratchViewComponent.setZoomRate(zoomRate);
        this.scratchCuePointsView.setZoomRate(zoomRate);
    }

    protected class ScratchDeckHandler
    implements ScratchDeckListener {
        protected ScratchDeckHandler() {
        }

        public void scratchPlayerChanged(ScratchDeck deck) {
            DvsDeck.this.handleScratchPlayerChanged(deck);
        }

        public void scratchResourceWillChange(ScratchDeck deck) {
        }

        public void scratchResourceHasChanged(ScratchDeck deck) {
            DvsDeck.this.handleScratchResourceHasChanged(deck);
        }

        public void deckStarted(ScratchDeck deck) {
        }

        public void deckStopped(ScratchDeck deck) {
        }

        public void scratchModeChanged(ScratchDeck deck, int mode) {
            DvsDeck.this.scratchModePanel.scratchModeChanged(deck, mode);
        }

        public void pitchModeChanged(ScratchDeck deck, int mode) {
            DvsDeck.this.pitchModePanel.pitchModeChanged(deck, mode);
            DvsDeck.this.pitchInfoPanel.pitchModeChanged(deck, mode);
        }

        public void primaryPitchChanged(ScratchDeck deck, double pitch) {
            DvsDeck.this.pitchInfoPanel.primaryPitchChanged(deck, pitch);
        }

        public void secondaryPitchChanged(ScratchDeck deck, double pitch) {
            DvsDeck.this.pitchInfoPanel.secondaryPitchChanged(deck, pitch);
        }

        public void slipModeEnabled(ScratchDeck deck) {
        }

        public void slipModeDisabled(ScratchDeck deck) {
        }

        public void beatJumpEnabled(ScratchDeck deck) {
            DvsDeck.this.beatJumpPanel.beatJumpEnabled(deck);
        }

        public void beatJumpDisabled(ScratchDeck deck) {
            DvsDeck.this.beatJumpPanel.beatJumpDisabled(deck);
        }

        public void jumpBeatsChanged(ScratchDeck deck) {
            DvsDeck.this.beatJumpPanel.jumpBeatsChanged(deck);
        }

        public void censorActivated(ScratchDeck deck) {
        }

        public void censorDeactivated(ScratchDeck deck) {
        }

        public void goofyModeActivated(ScratchDeck deck) {
        }

        public void goofyModeDeactivated(ScratchDeck deck) {
        }

        public void cuePointAdded(ScratchDeck deck, int index) {
            DvsDeck.this.cuePointsPanel.cuePointAdded(deck, index);
            DvsDeck.this.trackTouchPanel.cuePointAdded(deck, index);
            DvsDeck.this.scratchCuePointsView.cuePointAdded(deck, index);
        }

        public void cuePointRemoved(ScratchDeck deck, int index) {
            DvsDeck.this.cuePointsPanel.cuePointRemoved(deck, index);
            DvsDeck.this.trackTouchPanel.cuePointRemoved(deck, index);
            DvsDeck.this.scratchCuePointsView.cuePointRemoved(deck, index);
        }

        public void cuePointChanged(ScratchDeck deck, int index) {
            DvsDeck.this.cuePointsPanel.cuePointChanged(deck, index);
            DvsDeck.this.trackTouchPanel.cuePointChanged(deck, index);
            DvsDeck.this.scratchCuePointsView.cuePointChanged(deck, index);
        }

        public void loopRollStarted(ScratchDeck deck, int index) {
            DvsDeck.this.loopRollsPanel.loopRollStarted(deck, index);
        }

        public void loopRollStopped(ScratchDeck deck, int index) {
            DvsDeck.this.loopRollsPanel.loopRollStopped(deck, index);
        }

        public void autoLoopStarted(ScratchDeck deck, int index) {
            DvsDeck.this.autoLoopsPanel.autoLoopStarted(deck, index);
        }

        public void autoLoopStopped(ScratchDeck deck, int index) {
            DvsDeck.this.autoLoopsPanel.autoLoopStopped(deck, index);
        }

        public void sliceBeatsChanged(ScratchDeck deck) {
            DvsDeck.this.beatSlicerPanel.sliceBeatsChanged(deck);
        }

        public void beatSlicerEnabled(ScratchDeck deck) {
            DvsDeck.this.beatSlicerPanel.beatSlicerEnabled(deck);
        }

        public void beatSlicerDisabled(ScratchDeck deck) {
            DvsDeck.this.beatSlicerPanel.beatSlicerDisabled(deck);
        }

        public void beatSlicerStarted(ScratchDeck deck) {
            DvsDeck.this.beatSlicerPanel.beatSlicerStarted(deck);
            DvsDeck.this.beatSlicesPanel.beatSlicerStarted(deck);
        }

        public void beatSlicerStopped(ScratchDeck deck) {
            DvsDeck.this.beatSlicerPanel.beatSlicerStopped(deck);
            DvsDeck.this.beatSlicesPanel.beatSlicerStopped(deck);
        }

        public void beatSlicerLoopModeChanged(ScratchDeck deck, boolean loopMode) {
            DvsDeck.this.beatSlicerPanel.beatSlicerLoopModeChanged(deck, loopMode);
        }

        public void beatSliceActivated(ScratchDeck deck, int index) {
            DvsDeck.this.beatSlicesPanel.beatSliceActivated(deck, index);
        }

        public void beatSliceEntered(ScratchDeck deck, int index) {
            DvsDeck.this.beatSlicesPanel.beatSliceEntered(deck, index);
        }

        public void beatSliceExited(ScratchDeck deck, int index) {
            DvsDeck.this.beatSlicesPanel.beatSliceExited(deck, index);
        }
    }
}

