/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.waxlab.dvs.DvsDeckControlTab;
import com.waxmonster.waxlab.dvs.Scalable;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;

public class DvsDeckControlPanel
extends JPanel
implements Scalable {
    private static final long serialVersionUID = 3608896095429353385L;
    private BorderLayout borderLayout;
    private List tabList;
    private int selectedTabIndex = -1;
    private ColorButtonStyle buttonStyle;
    private JPanel buttonPanel;
    private ColorButton[] colorButtons;
    private String buttonsConstraint;
    private int tabGap;
    private int buttonGap;
    private JPanel centerPanel;
    private double variableFactor;

    public DvsDeckControlPanel() {
        this.setOpaque(false);
        this.borderLayout = new BorderLayout();
        this.setLayout(this.borderLayout);
        LineBorder lineBorder = new LineBorder(Color.GRAY, 1);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        BorderUIResource.CompoundBorderUIResource multiBorder = new BorderUIResource.CompoundBorderUIResource(lineBorder, emptyBorder);
        this.setBorder(multiBorder);
        this.tabList = new ArrayList();
        this.buttonStyle = new ColorButtonStyle(Color.GRAY);
        this.colorButtons = new ColorButton[0];
        this.setTabGap(5);
        this.centerPanel = new JPanel();
        this.centerPanel.setName("centerPanel");
        this.centerPanel.setOpaque(false);
        this.centerPanel.setLayout(new GridBagLayout());
        this.add((Component)this.centerPanel, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setOpaque(false);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.buttonPanel.setLayout(gbl_panel);
        this.setButtonsConstraint("West");
        this.setButtonGap(4);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[bounds=" + this.getBounds() + "]";
    }

    public synchronized void addTab(DvsDeckControlTab tab) {
        this.insertTabAt(tab, this.tabList.size());
    }

    public synchronized void insertTabAt(DvsDeckControlTab tab, int index) {
        if (tab == null) {
            return;
        }
        this.tabList.add(index, tab);
        this.refreshTabButtons();
        if (this.selectedTabIndex < 0) {
            this.setSelectedTabIndex(index);
        }
    }

    protected synchronized void refreshTabButtons() {
        this.buttonPanel.removeAll();
        int num = this.tabList.size();
        this.colorButtons = new ColorButton[num];
        for (int i = 0; i < num; ++i) {
            DvsDeckControlTab tab = (DvsDeckControlTab)this.tabList.get(i);
            String title = tab.getTitle();
            if (title == null) {
                title = "";
            }
            ColorButton colorButton1 = new ColorButton();
            colorButton1.setOpaque(false);
            colorButton1.setDisarmed(true);
            colorButton1.setRequestFocusEnabled(false);
            colorButton1.setToolTipEnabled(false);
            colorButton1.setSelected(i == this.selectedTabIndex);
            colorButton1.addColorButtonListener((ColorButtonListener)new ButtonHandler(i));
            colorButton1.setText(title);
            colorButton1.setToolTipText(tab.getTooltip());
            colorButton1.setIcon(tab.getIcon());
            colorButton1.setColorButtonStyle(this.buttonStyle);
            colorButton1.setForeground(Color.WHITE);
            GridBagConstraints gbc_colorButton1 = new GridBagConstraints();
            gbc_colorButton1.fill = 2;
            gbc_colorButton1.insets = new Insets(0, 0, this.buttonGap, 0);
            gbc_colorButton1.gridx = 0;
            gbc_colorButton1.gridy = i;
            this.buttonPanel.add((Component)colorButton1, gbc_colorButton1);
            this.colorButtons[i] = colorButton1;
        }
    }

    public ColorButtonStyle getButtonStyle() {
        return this.buttonStyle;
    }

    public void setButtonStyle(ColorButtonStyle buttonStyle) {
        this.buttonStyle = buttonStyle;
        this.refreshTabButtons();
    }

    public int getSelectedTabIndex() {
        return this.selectedTabIndex;
    }

    public synchronized void setSelectedTabIndex(int selectedTabIndex) {
        if (this.selectedTabIndex == selectedTabIndex) {
            return;
        }
        this.selectedTabIndex = selectedTabIndex;
        int num = this.colorButtons.length;
        for (int i = 0; i < num; ++i) {
            this.colorButtons[i].setSelected(i == selectedTabIndex);
        }
        this.centerPanel.removeAll();
        if (selectedTabIndex >= 0 && selectedTabIndex < this.tabList.size()) {
            DvsDeckControlTab tab = (DvsDeckControlTab)this.tabList.get(selectedTabIndex);
            tab.setVariableFactor(this.variableFactor);
            tab.layoutElements(this.centerPanel);
        }
        this.validate();
        this.repaint();
    }

    public String getButtonsConstraint() {
        return this.buttonsConstraint;
    }

    public synchronized void setButtonsConstraint(String buttonsConstraint) {
        if (this.buttonsConstraint == buttonsConstraint) {
            return;
        }
        this.buttonsConstraint = buttonsConstraint;
        this.remove(this.buttonPanel);
        this.add((Component)this.buttonPanel, buttonsConstraint);
        this.validate();
        this.repaint();
    }

    public int getTabGap() {
        return this.tabGap;
    }

    public synchronized void setTabGap(int tabGap) {
        if (this.tabGap == tabGap) {
            return;
        }
        this.tabGap = tabGap;
        this.borderLayout.setHgap(tabGap);
        this.setLayout(this.borderLayout);
    }

    public int getButtonGap() {
        return this.buttonGap;
    }

    public void setButtonGap(int buttonGap) {
        this.buttonGap = buttonGap;
        this.refreshTabButtons();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resized = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (resized) {
            this.validate();
        }
    }

    @Override
    public synchronized void validate() {
        int width = this.centerPanel.getWidth();
        int height = this.centerPanel.getHeight();
        int minWidth = 0;
        int minHeight = 0;
        int num = this.tabList.size();
        if (num > 0) {
            Dimension dim = new Dimension();
            for (int i = 0; i < num; ++i) {
                DvsDeckControlTab tab = (DvsDeckControlTab)this.tabList.get(i);
                dim = tab.getMinimumSize(dim);
                if (dim.width > minWidth) {
                    minWidth = dim.width;
                }
                if (dim.height <= minHeight) continue;
                minHeight = dim.height;
            }
        }
        ScalableWeight weight = new ScalableWeight();
        this.getVariableWeight(weight);
        double factor = 0.0;
        double xWeight = weight.width;
        double yWeight = weight.height;
        if (xWeight > 0.0 && yWeight > 0.0) {
            double xFactor = (double)(width - minWidth) / xWeight;
            double yFactor = (double)(height - minHeight) / yWeight;
            double d = factor = xFactor < yFactor ? xFactor : yFactor;
            if (factor < 0.0) {
                factor = 0.0;
            }
        }
        this.setVariableFactor(factor);
        super.validate();
    }

    protected void dump(Component comp, String indent) {
        Container cont;
        Component[] comps;
        System.out.println(indent + "- " + comp);
        if (comp instanceof Container && (comps = (cont = (Container)comp).getComponents()) != null) {
            indent = indent + "  ";
            for (int i = 0; i < comps.length; ++i) {
                this.dump(comps[i], indent);
            }
        }
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        Insets insets;
        Border border;
        int num;
        int width = 0;
        int height = 0;
        Dimension dim = this.buttonPanel.getPreferredSize();
        width += dim.width + this.tabGap;
        if (dim.height > height) {
            height = dim.height;
        }
        if ((num = this.tabList.size()) > 0) {
            for (int i = 0; i < num; ++i) {
                DvsDeckControlTab tab = (DvsDeckControlTab)this.tabList.get(i);
                dim = tab.getPreferredSize(dim);
                if (dim.width > width) {
                    width = dim.width;
                }
                if (dim.height <= height) continue;
                height = dim.height;
            }
        }
        if ((border = this.getBorder()) != null && (insets = border.getBorderInsets(this)) != null) {
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        dim.width = width;
        dim.height = height;
        return dim;
    }

    @Override
    public synchronized Dimension getMinimumSize() {
        Insets insets;
        Border border;
        int num;
        int width = 0;
        int height = 0;
        Dimension dim = this.buttonPanel.getMinimumSize();
        width += dim.width + this.tabGap;
        if (dim.height > height) {
            height = dim.height;
        }
        if ((num = this.tabList.size()) > 0) {
            for (int i = 0; i < num; ++i) {
                DvsDeckControlTab tab = (DvsDeckControlTab)this.tabList.get(i);
                dim = tab.getMinimumSize(dim);
                if (dim.width > width) {
                    width = dim.width;
                }
                if (dim.height <= height) continue;
                height = dim.height;
            }
        }
        if ((border = this.getBorder()) != null && (insets = border.getBorderInsets(this)) != null) {
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        dim.width = width;
        dim.height = height;
        return dim;
    }

    @Override
    public synchronized void getVariableWeight(ScalableWeight dst) {
        double width = 0.0;
        double height = 0.0;
        int num = this.tabList.size();
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                DvsDeckControlTab tab = (DvsDeckControlTab)this.tabList.get(i);
                tab.getVariableWeight(dst);
                if (dst.width > width) {
                    width = dst.width;
                }
                if (!(dst.height > height)) continue;
                height = dst.height;
            }
        }
        dst.width = width;
        dst.height = height;
    }

    @Override
    public double getVariableFactor() {
        return this.variableFactor;
    }

    @Override
    public synchronized void setVariableFactor(double factor) {
        if (this.variableFactor == factor) {
            return;
        }
        this.variableFactor = factor;
        int num = this.tabList.size();
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                DvsDeckControlTab tab = (DvsDeckControlTab)this.tabList.get(i);
                tab.setVariableFactor(factor);
            }
        }
    }

    protected class ButtonHandler
    extends ColorButtonAdapter {
        private int tabIndex;

        public ButtonHandler(int tabIndex) {
            this.tabIndex = tabIndex;
        }

        public void buttonPressed(ActionEvent event) {
            super.buttonPressed(event);
            DvsDeckControlPanel.this.setSelectedTabIndex(this.tabIndex);
        }

        public void buttonPressed(MouseEvent event) {
            super.buttonPressed(event);
            DvsDeckControlPanel.this.setSelectedTabIndex(this.tabIndex);
        }

        public void buttonReleased(ActionEvent event) {
            super.buttonReleased(event);
        }

        public void buttonReleased(MouseEvent event) {
            super.buttonReleased(event);
        }
    }
}

