/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.waxmonster.waxlab.dvs.DvsDeckControlElement;
import com.waxmonster.waxlab.dvs.Scalable;
import com.waxmonster.waxlab.dvs.ScalableWeight;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JPanel;

public class DvsDeckControlTab
implements Scalable {
    private String title;
    private String tooltip;
    private Icon icon;
    private DvsDeckControlElement[] elements;
    private int elementGapX = 4;
    private int elementGapY = 4;
    private Map rowMap;
    private GridBagLayout layout;
    private double variableFactor;

    public DvsDeckControlTab(String title, String tooltip, Icon icon, DvsDeckControlElement[] elements) {
        this.title = title;
        this.tooltip = tooltip;
        this.icon = icon;
        this.rowMap = new TreeMap();
        this.layout = new GridBagLayout();
        this.setElements(elements);
    }

    public String toString() {
        return super.toString() + "[tooltip=" + this.tooltip + "]";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public DvsDeckControlElement[] getElements() {
        return this.elements;
    }

    public void setElements(DvsDeckControlElement[] elements) {
        this.elements = elements;
        this.refreshRows();
    }

    public int getElementGapX() {
        return this.elementGapX;
    }

    public void setElementGapX(int elementGapX) {
        this.elementGapX = elementGapX;
    }

    public int getElementGapY() {
        return this.elementGapY;
    }

    public void setElementGapY(int elementGapY) {
        this.elementGapY = elementGapY;
    }

    protected synchronized void refreshRows() {
        this.rowMap.clear();
        DvsDeckControlElement[] elements = this.elements;
        int num = elements == null ? 0 : elements.length;
        for (int i = 0; i < num; ++i) {
            Column col;
            DvsDeckControlElement el = elements[i];
            if (el == null) continue;
            String rowKey = String.valueOf(el.getRow());
            String colKey = String.valueOf(el.getColumn());
            Row row = (Row)this.rowMap.get(rowKey);
            if (row == null) {
                row = new Row();
                this.rowMap.put(rowKey, row);
            }
            if ((col = (Column)row.columnMap.get(colKey)) == null) {
                col = new Column();
                row.columnMap.put(colKey, col);
            }
            col.element = el;
        }
    }

    public void layoutElements(Container parent) {
        parent.removeAll();
        GridBagLayout gbl = this.layout;
        parent.setLayout(gbl);
        int rowIndex = 0;
        for (Row row : this.rowMap.values()) {
            GridBagConstraints gbc;
            row.rowPanel.removeAll();
            int colIndex = 0;
            for (Column col : row.columnMap.values()) {
                Component comp;
                DvsDeckControlElement element = col.element;
                if (element == null || (comp = element.getComponent()) == null) continue;
                gbc = new GridBagConstraints();
                gbc.gridx = colIndex;
                gbc.gridy = 0;
                gbc.anchor = 18;
                gbc.weightx = element.getWeightX();
                gbc.weighty = element.getWeightY();
                gbc.fill = 1;
                gbc.insets.left = colIndex > 0 ? this.elementGapX : 0;
                row.rowPanel.add(comp, gbc);
                ++colIndex;
            }
            row.layout.columnWidths = new int[colIndex + 1];
            double[] columnWeights = new double[colIndex + 1];
            columnWeights[colIndex] = Double.MIN_VALUE;
            row.layout.columnWeights = columnWeights;
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = rowIndex;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets.top = rowIndex > 0 ? this.elementGapY : 0;
            parent.add((Component)row.rowPanel, gbc);
            ++rowIndex;
        }
        gbl.rowHeights = new int[rowIndex + 1];
        double[] rowWeights = new double[rowIndex + 1];
        rowWeights[rowIndex] = Double.MIN_VALUE;
        gbl.rowWeights = rowWeights;
    }

    public Dimension getPreferredSize(Dimension dim) {
        int width = 0;
        int height = 0;
        int rowIndex = 0;
        for (Row row : this.rowMap.values()) {
            int rowWidth = 0;
            int rowHeight = 0;
            int colIndex = 0;
            for (Column col : row.columnMap.values()) {
                Component comp;
                DvsDeckControlElement element = col.element;
                if (element == null || (comp = element.getComponent()) == null) continue;
                Dimension pref = comp.getPreferredSize();
                if (colIndex > 0) {
                    rowWidth += this.elementGapX;
                }
                rowWidth += pref.width;
                if (pref.height > rowHeight) {
                    rowHeight = pref.height;
                }
                ++colIndex;
            }
            if (rowWidth > width) {
                width = rowWidth;
            }
            if (rowIndex > 0) {
                height += this.elementGapY;
            }
            height += rowHeight;
            ++rowIndex;
        }
        dim.width = width;
        dim.height = height;
        return dim;
    }

    public Dimension getMinimumSize(Dimension dim) {
        int width = 0;
        int height = 0;
        int rowIndex = 0;
        for (Row row : this.rowMap.values()) {
            int rowWidth = 0;
            int rowHeight = 0;
            int colIndex = 0;
            for (Column col : row.columnMap.values()) {
                Component comp;
                DvsDeckControlElement element = col.element;
                if (element == null || (comp = element.getComponent()) == null) continue;
                Dimension pref = comp.getMinimumSize();
                if (colIndex > 0) {
                    rowWidth += this.elementGapX;
                }
                rowWidth += pref.width;
                if (pref.height > rowHeight) {
                    rowHeight = pref.height;
                }
                ++colIndex;
            }
            if (rowWidth > width) {
                width = rowWidth;
            }
            if (rowIndex > 0) {
                height += this.elementGapY;
            }
            height += rowHeight;
            ++rowIndex;
        }
        dim.width = width;
        dim.height = height;
        return dim;
    }

    @Override
    public void getVariableWeight(ScalableWeight dst) {
        double width = 0.0;
        double height = 0.0;
        for (Row row : this.rowMap.values()) {
            double rowWidth = 0.0;
            double rowHeight = 0.0;
            for (Column col : row.columnMap.values()) {
                Component comp;
                DvsDeckControlElement element = col.element;
                if (element == null || (comp = element.getComponent()) == null || !(comp instanceof Scalable)) continue;
                Scalable scalable = (Scalable)((Object)comp);
                dst.width = 0.0;
                dst.height = 0.0;
                scalable.getVariableWeight(dst);
                rowWidth += dst.width;
                if (!(dst.height > rowHeight)) continue;
                rowHeight = dst.height;
            }
            if (rowWidth > width) {
                width = rowWidth;
            }
            height += rowHeight;
        }
        dst.width = width;
        dst.height = height;
    }

    @Override
    public double getVariableFactor() {
        return this.variableFactor;
    }

    @Override
    public void setVariableFactor(double factor) {
        if (this.variableFactor == factor) {
            return;
        }
        this.variableFactor = factor;
        DvsDeckControlElement[] elements = this.elements;
        int num = elements == null ? 0 : elements.length;
        for (int i = 0; i < num; ++i) {
            Component comp;
            DvsDeckControlElement el = elements[i];
            if (el == null || (comp = el.getComponent()) == null || !(comp instanceof Scalable)) continue;
            Scalable scalable = (Scalable)((Object)comp);
            scalable.setVariableFactor(factor);
        }
    }

    protected class Column {
        protected DvsDeckControlElement element;

        protected Column() {
        }
    }

    protected class Row {
        protected Map columnMap = new TreeMap();
        protected JPanel rowPanel = new JPanel();
        protected GridBagLayout layout;

        public Row() {
            this.rowPanel.setOpaque(false);
            this.layout = new GridBagLayout();
            this.rowPanel.setLayout(this.layout);
        }
    }
}

