/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.impl.WaxLabLiveFeederResource;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DvsDeckHeaderPanel
extends JPanel {
    private static final long serialVersionUID = 3228870374177186925L;
    private final RefreshTrackInfo refreshTrackInfo = new RefreshTrackInfo();
    private ScratchDeck scratchDeck;
    private int deckLayout = 1;
    private boolean leftDeck;
    private WaxLabViewSettings viewSettings;
    private Paint backPaint;
    private JLabel lblDeckName;
    private JLabel lblTrackTitle;
    private JLabel lblTrackDetails;
    private JLabel lblTrackDuration;
    private JLabel lblTrackTempo;

    public DvsDeckHeaderPanel() {
        GridBagLayout gbl_panelTrack = new GridBagLayout();
        gbl_panelTrack.columnWidths = new int[]{0, 0, 0};
        gbl_panelTrack.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelTrack.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelTrack.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gbl_panelTrack);
        this.lblDeckName = new JLabel("Deck Name");
        this.lblTrackTitle = new JLabel("Track Title");
        this.lblTrackTitle.setToolTipText("Track Title");
        this.lblTrackTempo = new JLabel("BPM");
        this.lblTrackTempo.setToolTipText("Tempo (BPM)");
        this.lblTrackDetails = new JLabel("Track Details");
        this.lblTrackDetails.setToolTipText("Track Details");
        this.lblTrackDuration = new JLabel("Duration");
        this.lblTrackDuration.setToolTipText("Duration");
        this.layoutDeckHeaderPanel();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[bounds=" + this.getBounds() + "]";
    }

    public ScratchDeck getScratchDeck() {
        return this.scratchDeck;
    }

    public void setScratchDeck(ScratchDeck scratchDeck) {
        this.scratchDeck = scratchDeck;
        this.refreshDeckInfo();
    }

    protected void layoutDeckHeaderPanel() {
        this.removeAll();
        boolean leftDeck = this.leftDeck;
        if (this.deckLayout == 0) {
            leftDeck = true;
        }
        GridBagConstraints gbc_lblDeckName = new GridBagConstraints();
        gbc_lblDeckName.gridwidth = 2;
        gbc_lblDeckName.anchor = !leftDeck || this.deckLayout == 0 ? 17 : 13;
        gbc_lblDeckName.gridx = 0;
        gbc_lblDeckName.gridy = 0;
        this.add((Component)this.lblDeckName, gbc_lblDeckName);
        GridBagConstraints gbc_lblTrackTitle = new GridBagConstraints();
        gbc_lblTrackTitle.anchor = leftDeck ? 17 : 13;
        gbc_lblTrackTitle.weightx = 1.0;
        gbc_lblTrackTitle.gridx = leftDeck ? 0 : 1;
        gbc_lblTrackTitle.gridy = 1;
        this.add((Component)this.lblTrackTitle, gbc_lblTrackTitle);
        GridBagConstraints gbc_lblTrackDetails = new GridBagConstraints();
        gbc_lblTrackDetails.weightx = 1.0;
        gbc_lblTrackDetails.anchor = leftDeck ? 17 : 13;
        gbc_lblTrackDetails.gridx = leftDeck ? 0 : 1;
        gbc_lblTrackDetails.gridy = 2;
        this.add((Component)this.lblTrackDetails, gbc_lblTrackDetails);
        GridBagConstraints gbc_lblTrackTempo = new GridBagConstraints();
        gbc_lblTrackTempo.anchor = leftDeck ? 13 : 17;
        gbc_lblTrackTempo.gridx = leftDeck ? 1 : 0;
        gbc_lblTrackTempo.gridy = 1;
        this.add((Component)this.lblTrackTempo, gbc_lblTrackTempo);
        GridBagConstraints gbc_lblTrackDuration = new GridBagConstraints();
        gbc_lblTrackDuration.anchor = leftDeck ? 13 : 17;
        gbc_lblTrackDuration.gridx = leftDeck ? 1 : 0;
        gbc_lblTrackDuration.gridy = 2;
        this.add((Component)this.lblTrackDuration, gbc_lblTrackDuration);
    }

    public void refreshViewSettings() {
        Font font;
        Color col;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Paint paint = viewSettings.getDvsDeckBackground();
        if (paint != null) {
            this.setBackPaint(paint);
        }
        if ((col = viewSettings.getDvsDeckNameColor()) != null) {
            this.lblDeckName.setForeground(col);
        }
        if ((font = viewSettings.getDvsDeckNameFont()) != null) {
            this.lblDeckName.setFont(font);
        }
        if ((col = viewSettings.getDvsTitleColor()) != null) {
            this.lblTrackTitle.setForeground(col);
            this.lblTrackTempo.setForeground(col);
            this.lblTrackDetails.setForeground(col);
            this.lblTrackDuration.setForeground(col);
        }
        if ((font = viewSettings.getDvsTitleFont()) != null) {
            this.lblTrackTitle.setFont(font);
            this.lblTrackTempo.setFont(font);
        }
        if ((font = viewSettings.getDvsDetailsFont()) != null) {
            this.lblTrackDetails.setFont(font);
            this.lblTrackDuration.setFont(font);
        }
    }

    public void refreshDeckInfo() {
        ScratchDeck scratchDeck = this.scratchDeck;
        String deckName = null;
        if (scratchDeck != null) {
            deckName = scratchDeck.getName();
        }
        if (deckName == null) {
            deckName = "";
        }
        this.lblDeckName.setText(deckName);
    }

    public void refreshTrackInfo() {
        String album;
        String title;
        MediaEntry mediaEntry = null;
        Resource resource = null;
        ScratchDeck deck = this.scratchDeck;
        if (deck != null) {
            mediaEntry = deck.getMediaEntry();
            if (mediaEntry != null) {
                resource = mediaEntry.getResource();
            }
            if (resource == null) {
                resource = deck.getScratchResource();
            }
        }
        if ((title = this.getTrackTitle(mediaEntry, resource)) == null || title.length() < 1) {
            title = " ";
        }
        this.lblTrackTitle.setText(title);
        String details = "";
        String artist = this.getTrackArtist(mediaEntry, resource);
        if (artist != null && (artist = artist.trim()).length() > 0) {
            details = details + artist;
        }
        if ((album = this.getTrackAlbum(mediaEntry, resource)) != null && (album = album.trim()).length() > 0) {
            details = details.length() > 0 ? details + "  |  " + album : details + album;
        }
        if (details.length() < 1) {
            details = " ";
        }
        this.lblTrackDetails.setText(details);
        String tempo = null;
        double bpm = this.getTrackBpm(mediaEntry, resource);
        if (bpm > 0.0) {
            bpm = (double)Math.round(bpm * 100.0) / 100.0;
            tempo = String.valueOf(bpm);
        }
        if (tempo == null || tempo.length() < 1) {
            tempo = " ";
        }
        this.lblTrackTempo.setText(tempo);
        String sDuration = null;
        double duration = this.getTrackDuration(mediaEntry, resource);
        if (duration >= 0.0) {
            sDuration = this.formatTrackDuration(duration);
        }
        if (sDuration == null || sDuration.length() < 1) {
            sDuration = " ";
        }
        this.lblTrackDuration.setText(sDuration);
    }

    protected String getTrackTitle(MediaEntry mediaEntry, Resource resource) {
        String title;
        if (mediaEntry != null && (title = mediaEntry.getTitle()) != null && title.length() > 0) {
            return title;
        }
        if (resource != null) {
            if (resource instanceof WaxLabLiveFeederResource) {
                return "<Live-Feed>";
            }
            if (resource.isFile()) {
                try {
                    File file = resource.getFile();
                    if (file != null) {
                        return file.getName();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                URI uri = resource.getURI();
                if (uri != null) {
                    return uri.getPath();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getTrackAlbum(MediaEntry mediaEntry, Resource resource) {
        String album;
        if (mediaEntry != null && (album = mediaEntry.getAlbum()) != null && album.length() > 0) {
            return album;
        }
        return null;
    }

    protected String getTrackArtist(MediaEntry mediaEntry, Resource resource) {
        if (mediaEntry != null) {
            String artist = mediaEntry.getArtist();
            if (artist == null || artist.length() < 1) {
                artist = mediaEntry.getAlbumArtist();
            }
            if (artist != null && artist.length() > 0) {
                return artist;
            }
        }
        return null;
    }

    protected double getTrackBpm(MediaEntry mediaEntry, Resource resource) {
        AudioEntry ae;
        if (mediaEntry != null && (ae = mediaEntry.getAudioEntry()) != null) {
            return ae.getBpm();
        }
        return 0.0;
    }

    protected double getTrackDuration(MediaEntry mediaEntry, Resource resource) {
        if (mediaEntry != null) {
            return mediaEntry.getDuration();
        }
        return Double.NaN;
    }

    protected String formatTrackDuration(double duration) {
        if (duration < 0.0) {
            return null;
        }
        long secs = Math.round(duration);
        if (secs < 60L) {
            return "0:" + Integer.toString(100 + (int)secs).substring(1);
        }
        long mins = secs / 60L;
        return Integer.toString((int)mins) + ":" + Integer.toString(100 + (int)(secs %= 60L)).substring(1);
    }

    public void scratchResourceHasChanged(ScratchDeck deck) {
        SwingUtilities.invokeLater(this.refreshTrackInfo);
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.refreshViewSettings();
    }

    protected JLabel getLblTrackArtist() {
        return this.lblTrackDuration;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint p;
        Graphics2D g2d = (Graphics2D)g;
        if (this.isOpaque() && (p = this.backPaint) != null) {
            g2d.setPaint(p);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        if (this.deckLayout == deckLayout) {
            return;
        }
        this.deckLayout = deckLayout;
        this.layoutDeckHeaderPanel();
    }

    public boolean isLeftDeck() {
        return this.leftDeck;
    }

    public void setLeftDeck(boolean leftDeck) {
        if (this.leftDeck == leftDeck) {
            return;
        }
        this.leftDeck = leftDeck;
        this.layoutDeckHeaderPanel();
    }

    protected class RefreshTrackInfo
    implements Runnable {
        protected RefreshTrackInfo() {
        }

        @Override
        public void run() {
            DvsDeckHeaderPanel.this.refreshTrackInfo();
        }
    }
}

