/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.media.control.FaderSlider;
import com.waxmonster.waxlab.dvs.WaxLabDvsPanel;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DvsFooterPanel
extends JPanel {
    private static final long serialVersionUID = -4257031351154864794L;
    private static final String FOOTER_INFO_TEXT = "waxmonster.com";
    private WaxLabDvsPanel dvsPanel;
    private WaxLabViewSettings viewSettings;
    private Paint backPaint;
    private JLabel lblFooterInfo;
    private FaderSlider zoomFaderSlider;

    public DvsFooterPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelSouth = new JPanel();
        panelSouth.setOpaque(false);
        this.add((Component)panelSouth, "South");
        GridBagLayout gbl_panelSouth = new GridBagLayout();
        gbl_panelSouth.columnWidths = new int[]{60, 0};
        gbl_panelSouth.rowHeights = new int[]{16, 0};
        gbl_panelSouth.columnWeights = new double[]{0.0, 0.0};
        gbl_panelSouth.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelSouth.setLayout(gbl_panelSouth);
        this.lblFooterInfo = new JLabel("Footer Info");
        GridBagConstraints gbc_lblFooterInfo = new GridBagConstraints();
        gbc_lblFooterInfo.weightx = 1.0;
        gbc_lblFooterInfo.fill = 2;
        gbc_lblFooterInfo.anchor = 17;
        gbc_lblFooterInfo.gridx = 0;
        gbc_lblFooterInfo.gridy = 0;
        panelSouth.add((Component)this.lblFooterInfo, gbc_lblFooterInfo);
        this.zoomFaderSlider = new FaderSlider();
        this.zoomFaderSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DvsFooterPanel.this.handleZoomFaderChanged(e);
            }
        });
        this.zoomFaderSlider.setPreferredSize(new Dimension(80, 14));
        this.zoomFaderSlider.setToolTipText("Zoom");
        this.zoomFaderSlider.setOpaque(false);
        GridBagConstraints gbc_zoomFaderSlider = new GridBagConstraints();
        gbc_zoomFaderSlider.insets = new Insets(0, 5, 0, 5);
        gbc_zoomFaderSlider.fill = 1;
        gbc_zoomFaderSlider.gridx = 1;
        gbc_zoomFaderSlider.gridy = 0;
        panelSouth.add((Component)this.zoomFaderSlider, gbc_zoomFaderSlider);
    }

    protected JLabel getLblFooterInfo() {
        return this.lblFooterInfo;
    }

    public WaxLabDvsPanel getDvsPanel() {
        return this.dvsPanel;
    }

    public void setDvsPanel(WaxLabDvsPanel dvsPanel) {
        this.dvsPanel = dvsPanel;
        this.refresh();
    }

    public void refresh() {
        this.lblFooterInfo.setText(FOOTER_INFO_TEXT);
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.refreshViewSettings();
    }

    public void refreshViewSettings() {
        Font font;
        Color col;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Paint paint = viewSettings.getDvsBackground();
        if (paint != null) {
            this.setBackPaint(paint);
        }
        if ((col = viewSettings.getDvsFooterColor()) != null) {
            this.lblFooterInfo.setForeground(col);
        }
        if ((font = viewSettings.getDvsFooterFont()) != null) {
            this.lblFooterInfo.setFont(font);
        }
        this.zoomFaderSlider.setPreferredSize(null);
        Dimension dim = this.zoomFaderSlider.getPreferredSize();
        if (dim != null) {
            dim.width = viewSettings.getDvsZoomSliderWidth();
            this.zoomFaderSlider.setPreferredSize(dim);
        }
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint p;
        Graphics2D g2d = (Graphics2D)g;
        if (this.isOpaque() && (p = this.backPaint) != null) {
            g2d.setPaint(p);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected FaderSlider getZoomFaderSlider() {
        return this.zoomFaderSlider;
    }

    protected void handleZoomFaderChanged(ChangeEvent e) {
        WaxLabDvsPanel dvsPanel = this.dvsPanel;
        if (dvsPanel == null) {
            return;
        }
        int val = this.zoomFaderSlider.getValue();
        int min = this.zoomFaderSlider.getMinimum();
        int max = this.zoomFaderSlider.getMaximum();
        double normVal = (double)(val - min) / (double)(max - min);
        double minZoom = dvsPanel.getMinZoomRate();
        double maxZoom = dvsPanel.getMaxZoomRate();
        double zoomRate = minZoom + (maxZoom - minZoom) * normVal;
        dvsPanel.setZoomRate(zoomRate);
    }
}

