/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonAdapter;
import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.waxlab.dvs.WaxLabDvsPanel;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DvsHeaderPanel
extends JPanel {
    private static final long serialVersionUID = 8961393284053212785L;
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("HH:mm");
    private WaxLabDvsPanel dvsPanel;
    private WaxLabViewSettings viewSettings;
    private DateFormat dateFormat;
    private Date date;
    private Timer timer;
    private CurrentTimeUpdateTask currentTimeUpdateTask;
    private Icon iconFullscreen;
    private Icon iconWindowed;
    private Paint backPaint;
    private JLabel lblTitle;
    private JLabel lblTime;
    private ColorButton colorButtonLayoutVertical;
    private ColorButton colorButtonLayoutHorizontal;
    private ColorButton colorButtonToggleFullscreen;

    public DvsHeaderPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelHeader = new JPanel();
        panelHeader.setOpaque(false);
        GridBagConstraints gbc_panelHeader = new GridBagConstraints();
        gbc_panelHeader.insets = new Insets(0, 0, 5, 0);
        gbc_panelHeader.weighty = 1.0;
        gbc_panelHeader.weightx = 1.0;
        gbc_panelHeader.fill = 1;
        gbc_panelHeader.gridx = 0;
        gbc_panelHeader.gridy = 0;
        this.add((Component)panelHeader, gbc_panelHeader);
        GridBagLayout gbl_panelHeader = new GridBagLayout();
        gbl_panelHeader.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelHeader.rowHeights = new int[]{0, 0};
        gbl_panelHeader.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelHeader.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelHeader.setLayout(gbl_panelHeader);
        JPanel panelWest = new JPanel();
        GridBagConstraints gbc_panelWest = new GridBagConstraints();
        gbc_panelWest.anchor = 17;
        gbc_panelWest.insets = new Insets(0, 0, 0, 5);
        gbc_panelWest.gridx = 0;
        gbc_panelWest.gridy = 0;
        panelHeader.add((Component)panelWest, gbc_panelWest);
        panelWest.setOpaque(false);
        GridBagLayout gbl_panelWest = new GridBagLayout();
        gbl_panelWest.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelWest.rowHeights = new int[]{0, 0};
        gbl_panelWest.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelWest.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelWest.setLayout(gbl_panelWest);
        this.colorButtonLayoutVertical = new ColorButton();
        this.colorButtonLayoutVertical.setToolTipText("Vertical Layout");
        this.colorButtonLayoutVertical.addColorButtonListener((ColorButtonListener)new ColorButtonAdapter(){

            public void buttonPressed(ActionEvent event) {
                DvsHeaderPanel.this.setLayoutVertical();
            }

            public void buttonPressed(MouseEvent event) {
                DvsHeaderPanel.this.setLayoutVertical();
            }
        });
        this.colorButtonLayoutVertical.setDisarmed(true);
        this.colorButtonLayoutVertical.setRequestFocusEnabled(false);
        GridBagConstraints gbc_colorButtonLayoutVertical = new GridBagConstraints();
        gbc_colorButtonLayoutVertical.insets = new Insets(0, 0, 0, 5);
        gbc_colorButtonLayoutVertical.gridx = 1;
        gbc_colorButtonLayoutVertical.gridy = 0;
        panelWest.add((Component)this.colorButtonLayoutVertical, gbc_colorButtonLayoutVertical);
        this.colorButtonLayoutHorizontal = new ColorButton();
        this.colorButtonLayoutHorizontal.setToolTipText("Horizontal Layout");
        this.colorButtonLayoutHorizontal.addColorButtonListener((ColorButtonListener)new ColorButtonAdapter(){

            public void buttonPressed(ActionEvent event) {
                DvsHeaderPanel.this.setLayoutHorizontal();
            }

            public void buttonPressed(MouseEvent event) {
                DvsHeaderPanel.this.setLayoutHorizontal();
            }
        });
        this.colorButtonLayoutHorizontal.setDisarmed(true);
        this.colorButtonLayoutHorizontal.setRequestFocusEnabled(false);
        GridBagConstraints gbc_colorButtonLayoutHorizontal = new GridBagConstraints();
        gbc_colorButtonLayoutHorizontal.gridx = 2;
        gbc_colorButtonLayoutHorizontal.gridy = 0;
        panelWest.add((Component)this.colorButtonLayoutHorizontal, gbc_colorButtonLayoutHorizontal);
        this.lblTime = new JLabel("23:59");
        this.lblTime.setToolTipText("Current Time");
        GridBagConstraints gbc_lblTime = new GridBagConstraints();
        gbc_lblTime.insets = new Insets(0, 0, 0, 10);
        gbc_lblTime.gridx = 0;
        gbc_lblTime.gridy = 0;
        panelWest.add((Component)this.lblTime, gbc_lblTime);
        JPanel panelCenter = new JPanel();
        GridBagConstraints gbc_panelCenter = new GridBagConstraints();
        gbc_panelCenter.gridwidth = 3;
        gbc_panelCenter.weightx = 1.0;
        gbc_panelCenter.insets = new Insets(0, 0, 0, 5);
        gbc_panelCenter.gridx = 0;
        gbc_panelCenter.gridy = 0;
        panelHeader.add((Component)panelCenter, gbc_panelCenter);
        panelCenter.setOpaque(false);
        GridBagLayout gbl_panelCenter = new GridBagLayout();
        gbl_panelCenter.columnWidths = new int[]{0, 0};
        gbl_panelCenter.rowHeights = new int[]{0, 0};
        gbl_panelCenter.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelCenter.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelCenter.setLayout(gbl_panelCenter);
        this.lblTitle = new JLabel("Wax Lab DVS");
        GridBagConstraints gbc_lblTitle = new GridBagConstraints();
        gbc_lblTitle.gridx = 0;
        gbc_lblTitle.gridy = 0;
        panelCenter.add((Component)this.lblTitle, gbc_lblTitle);
        this.lblTitle.setFont(new Font("Dialog", 1, 16));
        JPanel panelEast = new JPanel();
        GridBagConstraints gbc_panelEast = new GridBagConstraints();
        gbc_panelEast.anchor = 13;
        gbc_panelEast.gridx = 2;
        gbc_panelEast.gridy = 0;
        panelHeader.add((Component)panelEast, gbc_panelEast);
        panelEast.setOpaque(false);
        GridBagLayout gbl_panelEast = new GridBagLayout();
        gbl_panelEast.columnWidths = new int[]{0, 0, 0};
        gbl_panelEast.rowHeights = new int[]{0, 0};
        gbl_panelEast.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelEast.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelEast.setLayout(gbl_panelEast);
        this.colorButtonToggleFullscreen = new ColorButton();
        this.colorButtonToggleFullscreen.setToolTipText("Toggle Full-Screen");
        this.colorButtonToggleFullscreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DvsHeaderPanel.this.toggleFullscreen();
                DvsHeaderPanel.this.colorButtonToggleFullscreen.setSelected(false);
            }
        });
        this.colorButtonToggleFullscreen.setRequestFocusEnabled(false);
        GridBagConstraints gbc_colorButtonToggleFullscreen = new GridBagConstraints();
        gbc_colorButtonToggleFullscreen.gridx = 1;
        gbc_colorButtonToggleFullscreen.gridy = 0;
        panelEast.add((Component)this.colorButtonToggleFullscreen, gbc_colorButtonToggleFullscreen);
        this.initDvsHeaderPanel();
    }

    protected void initDvsHeaderPanel() {
        Date date;
        this.dateFormat = DEFAULT_DATE_FORMAT;
        this.date = date = new Date();
        this.timer = Platform.getInstance().getTimer();
        this.lblTitle.setFocusable(true);
        this.lblTitle.setRequestFocusEnabled(true);
        this.addHierarchyListener(new HierarchyHandler());
        Icon iconLayoutVertical = Tools.getIcon(DvsHeaderPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/layout_vertical_icon16.png");
        this.colorButtonLayoutVertical.setSelectedIcon(iconLayoutVertical);
        this.colorButtonLayoutVertical.setIcon(iconLayoutVertical);
        this.colorButtonLayoutVertical.setIcon(this.colorButtonLayoutVertical.getDisabledIcon());
        Icon iconLayoutHorizontal = Tools.getIcon(DvsHeaderPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/layout_horizontal_icon16.png");
        this.colorButtonLayoutHorizontal.setSelectedIcon(iconLayoutHorizontal);
        this.colorButtonLayoutHorizontal.setIcon(iconLayoutHorizontal);
        this.colorButtonLayoutHorizontal.setIcon(this.colorButtonLayoutHorizontal.getDisabledIcon());
        this.iconFullscreen = Tools.getIcon(DvsHeaderPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/fullscreen_icon16.png");
        this.iconWindowed = Tools.getIcon(DvsHeaderPanel.class, (String)"/com/waxmonster/waxlab/dvs/icons/windowed_icon16.png");
        this.colorButtonToggleFullscreen.setIcon(this.iconFullscreen);
    }

    protected void handleFullscreenChanged(boolean fullscreen) {
        Icon icon = fullscreen ? this.iconWindowed : this.iconFullscreen;
        this.colorButtonToggleFullscreen.setIcon(icon);
    }

    public void refreshViewSettings() {
        Font font;
        Color col;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings == null) {
            return;
        }
        Paint paint = viewSettings.getDvsBackground();
        if (paint != null) {
            this.setBackPaint(paint);
        }
        if ((col = viewSettings.getDvsHeaderColor()) != null) {
            this.lblTitle.setForeground(col);
        }
        if ((font = viewSettings.getDvsHeaderFont()) != null) {
            this.lblTitle.setFont(font);
        }
        if ((font = viewSettings.getDvsCurrentTimeFont()) != null) {
            this.lblTime.setFont(font);
        }
        if ((col = viewSettings.getDvsCurrentTimeColor()) != null) {
            this.lblTime.setForeground(col);
        }
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.refreshViewSettings();
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint p;
        Graphics2D g2d = (Graphics2D)g;
        if (this.isOpaque() && (p = this.backPaint) != null) {
            g2d.setPaint(p);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected JLabel getLblTitle() {
        return this.lblTitle;
    }

    protected JLabel getLblTime() {
        return this.lblTime;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat");
        }
        this.dateFormat = dateFormat;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    protected synchronized void startCurrentTimeTask() {
        CurrentTimeUpdateTask task;
        if (this.currentTimeUpdateTask != null) {
            return;
        }
        this.currentTimeUpdateTask = task = new CurrentTimeUpdateTask();
        long period = 60000L;
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        cal.set(13, 0);
        cal.add(12, 1);
        Date firstTime = cal.getTime();
        this.timer.scheduleAtFixedRate((TimerTask)task, firstTime, period);
        task.run();
    }

    protected synchronized void stopCurrentTimeTask() {
        CurrentTimeUpdateTask task = this.currentTimeUpdateTask;
        if (task == null) {
            return;
        }
        this.currentTimeUpdateTask = null;
        task.cancel();
    }

    protected ColorButton getColorButtonLayoutVertical() {
        return this.colorButtonLayoutVertical;
    }

    protected ColorButton getColorButtonLayoutHorizontal() {
        return this.colorButtonLayoutHorizontal;
    }

    public WaxLabDvsPanel getDvsPanel() {
        return this.dvsPanel;
    }

    public void setDvsPanel(WaxLabDvsPanel dvsPanel) {
        this.dvsPanel = dvsPanel;
        this.refreshLayoutButtons();
    }

    public void refreshLayoutButtons() {
        if (this.dvsPanel == null) {
            return;
        }
        int deckLayout = this.dvsPanel.getDeckLayout();
        this.colorButtonLayoutVertical.setSelected(deckLayout == 1);
        this.colorButtonLayoutHorizontal.setSelected(deckLayout == 0);
    }

    protected void setLayoutVertical() {
        this.dvsPanel.setDeckLayout(1);
    }

    protected void setLayoutHorizontal() {
        this.dvsPanel.setDeckLayout(0);
    }

    protected void toggleFullscreen() {
        this.dvsPanel.toggleFullscreen();
    }

    public void resetDefaultFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DvsHeaderPanel.this.lblTitle.requestFocus();
            }
        });
    }

    protected class CurrentTimeUpdateTask
    extends TimerTask {
        protected CurrentTimeUpdateTask() {
        }

        @Override
        public void run() {
            DvsHeaderPanel.this.date.setTime(System.currentTimeMillis());
            String s = DvsHeaderPanel.this.dateFormat.format(DvsHeaderPanel.this.date);
            DvsHeaderPanel.this.lblTime.setText(s);
        }
    }

    protected class HierarchyHandler
    implements HierarchyListener {
        protected HierarchyHandler() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L) {
                if (DvsHeaderPanel.this.isShowing()) {
                    DvsHeaderPanel.this.startCurrentTimeTask();
                    DvsHeaderPanel.this.resetDefaultFocus();
                } else {
                    DvsHeaderPanel.this.stopCurrentTimeTask();
                }
            }
        }
    }
}

