/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class WaxLabDvsLayout
implements LayoutManager2 {
    public static final int DECK_LAYOUT_HORIZONTAL = 0;
    public static final int DECK_LAYOUT_VERTICAL = 1;
    public static Object NORTH = "North";
    public static Object SOUTH = "South";
    public static Object DECK_HEADER_LEFT = "DeckHeaderLeft";
    public static Object DECK_HEADER_RIGHT = "DeckHeaderRight";
    public static Object DECK_CONTROL = "DeckControl";
    public static Object DECK_CLOCK = "DeckClock";
    public static Object DECK_TOUCH = "DeckTouch";
    public static Object DECK_TRACK = "DeckTrack";
    public static Object DECK_SCRATCH = "DeckScratch";
    protected boolean valid;
    protected int deckLayout = 0;
    protected Component north;
    protected Component south;
    protected List decks = new ArrayList();
    protected Insets insets;
    protected int northGap = 10;
    protected int southGap = 20;
    protected int deckGapX = 1;
    protected int deckGapY = 10;
    protected double clockSizeAmount = 0.3;
    protected double touchSizeAmount = 0.015;
    protected int touchMinSize = 8;
    protected double trackSizeAmount = 0.03;
    protected int trackMinSize = 14;
    protected double scratchSizeAmount = 0.12;
    protected int scratchMinSize = 25;

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (comp == null) {
            return;
        }
        this.addLayoutComponent(comp, DECK_HEADER_LEFT);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp == null) {
            return;
        }
        if (NORTH.equals(constraints)) {
            this.north = comp;
            this.invalidate();
        } else if (SOUTH.equals(constraints)) {
            this.south = comp;
            this.invalidate();
        } else if (DECK_HEADER_LEFT.equals(constraints)) {
            DeckLayout deck = new DeckLayout();
            deck.leftDeck = true;
            deck.header = comp;
            this.decks.add(deck);
            this.invalidate();
        } else if (DECK_HEADER_RIGHT.equals(constraints)) {
            DeckLayout deck = new DeckLayout();
            deck.leftDeck = false;
            deck.header = comp;
            this.decks.add(deck);
            this.invalidate();
        } else {
            DeckLayout deck;
            int num = this.decks.size();
            if (num > 0) {
                deck = (DeckLayout)this.decks.get(num - 1);
            } else {
                deck = new DeckLayout();
                this.decks.add(deck);
            }
            if (DECK_CONTROL.equals(constraints)) {
                deck.control = comp;
            } else if (DECK_CLOCK.equals(constraints)) {
                deck.clock = comp;
            } else if (DECK_TOUCH.equals(constraints)) {
                deck.touch = comp;
            } else if (DECK_TRACK.equals(constraints)) {
                deck.track = comp;
            } else if (DECK_SCRATCH.equals(constraints)) {
                deck.scratch = comp;
            }
            this.invalidate();
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this.north) {
            this.north = null;
            this.invalidate();
        } else if (comp == this.south) {
            this.south = null;
            this.invalidate();
        } else {
            int num = this.decks.size();
            for (int i = num - 1; i >= 0; --i) {
                DeckLayout deck = (DeckLayout)this.decks.get(i);
                if (deck.header == comp) {
                    deck.header = null;
                }
                if (deck.control == comp) {
                    deck.control = null;
                }
                if (deck.clock == comp) {
                    deck.clock = null;
                }
                if (deck.touch == comp) {
                    deck.touch = null;
                }
                if (deck.track == comp) {
                    deck.track = null;
                }
                if (deck.scratch == comp) {
                    deck.scratch = null;
                }
                if (deck.header != null) continue;
                this.decks.remove(i);
            }
            this.invalidate();
        }
    }

    protected int computeColumnCount(int layout, int decks) {
        if (layout == 0) {
            return 1;
        }
        return decks > 1 ? 2 : 1;
    }

    protected int computeRowCount(int layout, int decks) {
        if (layout == 0) {
            return decks;
        }
        return decks > 1 ? (decks + 1) / 2 : decks;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int prefWidth = 0;
        int prefHeight = 0;
        if (this.north != null) {
            prefHeight += this.north.getPreferredSize().height;
        }
        int numDecks = this.decks.size();
        int headerPrefHeight = 0;
        int controlPrefWidth = 0;
        int controlPrefHeight = 0;
        Dimension clockPrefSize = null;
        Dimension touchPrefSize = null;
        Dimension trackPrefSize = null;
        Dimension scratchPrefSize = null;
        for (int i = 0; i < numDecks; ++i) {
            Dimension compPref;
            DeckLayout deck = (DeckLayout)this.decks.get(i);
            Component comp = deck.header;
            if (comp != null) {
                compPref = comp.getPreferredSize();
                if (compPref.height > headerPrefHeight) {
                    headerPrefHeight = compPref.height;
                }
            }
            if ((comp = deck.control) != null) {
                compPref = comp.getPreferredSize();
                if (compPref.width > controlPrefWidth) {
                    controlPrefWidth = compPref.width;
                }
                if (compPref.height > controlPrefHeight) {
                    controlPrefHeight = compPref.height;
                }
            }
            if ((comp = deck.clock) != null) {
                clockPrefSize = comp.getPreferredSize();
            }
            if ((comp = deck.touch) != null) {
                touchPrefSize = comp.getPreferredSize();
            }
            if ((comp = deck.track) != null) {
                trackPrefSize = comp.getPreferredSize();
            }
            if ((comp = deck.scratch) == null) continue;
            scratchPrefSize = comp.getPreferredSize();
        }
        int clockPrefWidth = clockPrefSize == null ? 0 : clockPrefSize.width;
        int touchPrefWidth = touchPrefSize == null ? 0 : touchPrefSize.width;
        int trackPrefWidth = trackPrefSize == null ? 0 : trackPrefSize.width;
        int scratchPrefWidth = scratchPrefSize == null ? 0 : scratchPrefSize.width;
        int deckPrefWidth = controlPrefWidth + clockPrefWidth + touchPrefWidth + trackPrefWidth + scratchPrefWidth;
        int deckPrefHeight = headerPrefHeight + controlPrefHeight;
        double deckPrefFactor = 1.2;
        deckPrefWidth = (int)((double)deckPrefWidth * deckPrefFactor);
        deckPrefHeight = (int)((double)deckPrefHeight * deckPrefFactor);
        int columns = this.computeColumnCount(this.deckLayout, numDecks);
        int rows = this.computeRowCount(this.deckLayout, numDecks);
        prefWidth += columns * deckPrefWidth + (columns - 1) * this.deckGapX;
        prefHeight += rows * deckPrefHeight + (rows - 1) * this.deckGapY;
        if (this.south != null) {
            prefHeight += this.south.getPreferredSize().height;
        }
        if (this.insets != null) {
            prefWidth += this.insets.left + this.insets.right;
            prefHeight += this.insets.top + this.insets.bottom;
        }
        return new Dimension(prefWidth, prefHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container parent) {
        int scratchHeight;
        int scratchWidth;
        int trackHeight;
        int trackWidth;
        int touchHeight;
        int touchWidth;
        int clockHeight;
        int deckHeight;
        int decksPrefHeight;
        int decksHeight;
        Component comp;
        DeckLayout deck;
        int headerTrackGap;
        boolean horiz = this.deckLayout == 0;
        int x = 0;
        int y = 0;
        int width = parent.getWidth();
        int height = parent.getHeight();
        if (this.insets != null) {
            x = this.insets.left;
            y = this.insets.top;
            width -= this.insets.left + this.insets.right;
            height -= this.insets.top + this.insets.bottom;
        }
        int northHeight = 0;
        if (this.north != null) {
            northHeight = Math.min(height, this.north.getMinimumSize().height);
            if (northHeight < 0) {
                northHeight = 0;
            }
            this.north.setBounds(x, y, width, northHeight);
            northHeight += this.northGap;
        }
        int southMinHeight = 0;
        if (this.south != null) {
            southMinHeight = Math.min(height - northHeight, this.south.getMinimumSize().height);
            if (southMinHeight < 0) {
                southMinHeight = 0;
            }
            southMinHeight += this.southGap;
        }
        int decksMaxWidth = width;
        int decksMaxHeight = height - northHeight - southMinHeight;
        int numDecks = this.decks.size();
        int columns = this.computeColumnCount(this.deckLayout, numDecks);
        int rows = this.computeRowCount(this.deckLayout, numDecks);
        int deckWidth = horiz ? decksMaxWidth : (decksMaxWidth - (columns - 1) * this.deckGapX) / columns;
        int headerControlGap = headerTrackGap = horiz ? (int)((double)deckWidth * 0.01) : (int)((double)deckWidth * 0.03);
        int clockTrackGap = headerTrackGap;
        int clockControlGap = headerTrackGap;
        int headerHeight = 0;
        for (int i = 0; i < numDecks; ++i) {
            int prefH;
            deck = (DeckLayout)this.decks.get(i);
            comp = deck.header;
            if (comp == null || (prefH = comp.getPreferredSize().height) <= headerHeight) continue;
            headerHeight = prefH;
        }
        if (headerHeight > decksMaxHeight) {
            headerHeight = decksMaxHeight;
        }
        int controlPrefWidth = 0;
        int controlsPrefHeight = 0;
        for (int i = 0; i < numDecks; ++i) {
            deck = (DeckLayout)this.decks.get(i);
            comp = deck.control;
            if (comp == null) continue;
            comp.setSize(deckWidth / 2, decksMaxHeight - headerHeight - headerControlGap);
            comp.validate();
            Dimension compPref = comp.getPreferredSize();
            int prefW = compPref.width;
            if (prefW > controlPrefWidth) {
                controlPrefWidth = prefW;
            }
            int prefH = compPref.height;
            if (horiz) {
                controlsPrefHeight += prefH;
                if (i <= 0) continue;
                controlsPrefHeight += this.deckGapY;
                continue;
            }
            if (prefH <= controlsPrefHeight) continue;
            controlsPrefHeight = prefH;
        }
        if (controlPrefWidth > deckWidth) {
            controlPrefWidth = deckWidth;
        }
        if ((decksHeight = Math.min(decksMaxHeight, decksPrefHeight = horiz ? controlsPrefHeight + numDecks * (headerHeight + headerControlGap) : rows * (controlsPrefHeight + headerHeight + headerControlGap))) < 0) {
            decksHeight = 0;
        }
        if (horiz) {
            if (numDecks > 0) {
                deckHeight = (decksHeight - (numDecks - 1) * this.deckGapY) / numDecks;
                decksHeight = numDecks * deckHeight + (numDecks - 1) * this.deckGapY;
            } else {
                deckHeight = 0;
                decksHeight = 0;
            }
        } else {
            deckHeight = rows < 1 ? 0 : decksHeight / rows;
        }
        decksHeight = rows * deckHeight;
        int clockWidth = (int)((double)deckWidth * this.clockSizeAmount);
        int n = clockHeight = horiz ? deckHeight : deckHeight - headerHeight - headerControlGap;
        if (clockWidth < clockHeight) {
            clockHeight = clockWidth;
        } else {
            clockWidth = clockHeight;
        }
        int controlWidth = controlPrefWidth;
        if (horiz) {
            int totalHeight = deckHeight - headerHeight - headerControlGap;
            double totalAmount = this.touchSizeAmount + this.trackSizeAmount + this.scratchSizeAmount;
            touchWidth = deckWidth - clockWidth - headerTrackGap - clockTrackGap - controlWidth;
            touchHeight = (int)Math.max((double)this.touchMinSize, (double)totalHeight * this.touchSizeAmount / totalAmount);
            trackWidth = touchWidth;
            trackHeight = (int)Math.max((double)this.trackMinSize, (double)totalHeight * this.trackSizeAmount / totalAmount);
            scratchWidth = touchWidth;
            scratchHeight = totalHeight - touchHeight - trackHeight;
        } else {
            touchWidth = (int)Math.max((double)this.touchMinSize, (double)deckWidth * this.touchSizeAmount);
            touchHeight = deckHeight;
            trackWidth = (int)Math.max((double)this.trackMinSize, (double)deckWidth * this.trackSizeAmount);
            trackHeight = deckHeight;
            scratchWidth = (int)Math.max((double)this.scratchMinSize, (double)deckWidth * this.scratchSizeAmount);
            scratchHeight = deckHeight;
        }
        for (int i = 0; i < numDecks; ++i) {
            int touchY;
            int touchX;
            int scratchY;
            int scratchX;
            int trackY;
            int trackX;
            int controlH;
            int controlW;
            int controlY;
            int controlX;
            int headerY;
            int headerX;
            int headerH;
            int headerW;
            int clockY;
            int clockX;
            deck = (DeckLayout)this.decks.get(i);
            boolean leftDeck = deck.leftDeck;
            int row = i / columns;
            int column = i % columns;
            int deckX = x + column * (deckWidth + this.deckGapX);
            int deckY = y + northHeight + row * (deckHeight + this.deckGapY);
            if (horiz) {
                clockX = deckX + deckWidth - clockWidth;
                clockY = deckY;
                headerW = Math.max(0, deckWidth - clockWidth - headerTrackGap - clockTrackGap);
                headerH = headerHeight;
                headerX = deckX;
                headerY = deckY;
                controlX = deckX;
                controlY = headerY + headerH + headerControlGap;
                controlW = Math.min(headerW, controlWidth);
                controlH = Math.max(0, deckHeight - headerH - headerControlGap);
                trackX = controlX + controlW + clockTrackGap;
                trackY = controlY + scratchHeight;
                scratchX = trackX;
                scratchY = controlY;
                touchX = trackX;
                touchY = controlY + trackHeight + scratchHeight;
            } else {
                headerW = Math.max(0, deckWidth - touchWidth - trackWidth - scratchWidth - headerTrackGap);
                headerH = headerHeight;
                headerX = leftDeck ? deckX : deckX + touchWidth + trackWidth + scratchWidth + headerTrackGap;
                headerY = deckY;
                clockX = leftDeck ? headerX + headerW - clockWidth : headerX;
                clockY = headerY + headerH + headerControlGap;
                controlX = leftDeck ? headerX : headerX + clockWidth + clockControlGap;
                controlY = headerY + headerH + headerControlGap;
                controlW = headerW - clockWidth - clockControlGap;
                controlH = deckHeight - headerH - headerControlGap;
                touchX = leftDeck ? deckX + headerW + headerTrackGap : deckX + scratchWidth + trackWidth;
                touchY = deckY;
                scratchX = leftDeck ? deckX + headerW + headerTrackGap + touchWidth + trackWidth : deckX;
                scratchY = deckY;
                trackX = leftDeck ? deckX + headerW + headerTrackGap + touchWidth : deckX + scratchWidth;
                trackY = deckY;
            }
            if (deck.header != null) {
                deck.header.setBounds(headerX, headerY, headerW, headerH);
            }
            if (deck.control != null) {
                deck.control.setBounds(controlX, controlY, controlW, controlH);
                deck.control.validate();
            }
            if (deck.clock != null) {
                deck.clock.setBounds(clockX, clockY, clockWidth, clockHeight);
            }
            if (deck.touch != null) {
                deck.touch.setBounds(touchX, touchY, touchWidth, touchHeight);
            }
            if (deck.track != null) {
                deck.track.setBounds(trackX, trackY, trackWidth, trackHeight);
            }
            if (deck.scratch == null) continue;
            deck.scratch.setBounds(scratchX, scratchY, scratchWidth, scratchHeight);
        }
        if (this.south != null) {
            int southH = height - northHeight - decksHeight - this.southGap;
            if (southH < 0) {
                southH = 0;
            }
            this.south.setBounds(x, y + northHeight + decksHeight + this.southGap, width, southH);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.invalidate();
    }

    protected void invalidate() {
        this.valid = false;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
        this.invalidate();
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public void setDeckLayout(int deckLayout) {
        this.deckLayout = deckLayout;
        this.invalidate();
    }

    public int getDeckGapX() {
        return this.deckGapX;
    }

    public void setDeckGapX(int deckGapX) {
        this.deckGapX = deckGapX;
        this.invalidate();
    }

    public int getDeckGapY() {
        return this.deckGapY;
    }

    public void setDeckGapY(int deckGapY) {
        this.deckGapY = deckGapY;
        this.invalidate();
    }

    public int getNorthGap() {
        return this.northGap;
    }

    public void setNorthGap(int northGap) {
        this.northGap = northGap;
        this.invalidate();
    }

    public int getSouthGap() {
        return this.southGap;
    }

    public void setSouthGap(int southGap) {
        this.southGap = southGap;
        this.invalidate();
    }

    protected class DeckLayout {
        protected boolean leftDeck;
        protected Component header;
        protected Component control;
        protected Component clock;
        protected Component touch;
        protected Component track;
        protected Component scratch;

        protected DeckLayout() {
        }
    }
}

