/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.lock.LockFactory;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabListener;
import com.waxmonster.waxlab.dvs.DeckClockViewComponent;
import com.waxmonster.waxlab.dvs.DeckScratchViewComponent;
import com.waxmonster.waxlab.dvs.DeckTrackTouchPanel;
import com.waxmonster.waxlab.dvs.DeckTrackViewComponent;
import com.waxmonster.waxlab.dvs.DvsDeck;
import com.waxmonster.waxlab.dvs.DvsDeckControlPanel;
import com.waxmonster.waxlab.dvs.DvsDeckHeaderPanel;
import com.waxmonster.waxlab.dvs.DvsFooterPanel;
import com.waxmonster.waxlab.dvs.DvsHeaderPanel;
import com.waxmonster.waxlab.dvs.WaxLabDvsLayout;
import com.waxmonster.waxlab.dvs.WaxLabDvsView;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.WaxLabPluginContext;
import com.waxmonster.waxlab.view.WaxLabViewSettings;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class WaxLabDvsPanel
extends JPanel {
    private static final long serialVersionUID = 7920734002280146701L;
    private static final int DEFAULT_REFRESH_RATE = 50;
    private static final int MAX_REFRESH_INTERVAL = 86400000;
    private static final Logger logger = Logger.getLogger(WaxLabDvsPanel.class.getName());
    private WaxLab waxLab;
    private WaxLabPluginContext pluginContext;
    private LockFactory lockFactory;
    private boolean closed = true;
    private WaxLabDvsView dvsView;
    private List dvsDeckList;
    private DvsDeck[] dvsDecks;
    private int deckLayout = 1;
    private WaxLabViewSettings viewSettings;
    private Paint backPaint;
    private WaxLabDvsLayout dvsLayout;
    private DvsHeaderPanel dvsHeaderPanel;
    private DvsFooterPanel dvsFooterPanel;
    private WaxLabHandler waxLabHandler = new WaxLabHandler();
    private RefreshDecks refreshDecks = new RefreshDecks();
    private Timer repaintTimer;
    private int repaintRate = -1;
    private double zoomRate = 150.0;
    private double minZoomRate = 50.0;
    private double maxZoomRate = 300.0;

    public WaxLabDvsPanel(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
        this.viewSettings = new WaxLabViewSettings();
        this.dvsLayout = new WaxLabDvsLayout();
        this.setLayout(this.dvsLayout);
        this.dvsDeckList = new ArrayList();
        this.dvsDecks = new DvsDeck[0];
        this.dvsHeaderPanel = new DvsHeaderPanel();
        this.dvsHeaderPanel.setDvsPanel(this);
        this.dvsHeaderPanel.setOpaque(false);
        this.dvsFooterPanel = new DvsFooterPanel();
        this.dvsFooterPanel.setDvsPanel(this);
        this.dvsFooterPanel.setOpaque(false);
        this.repaintTimer = new Timer(1000, new Repainter());
        this.repaintTimer.setRepeats(true);
        this.repaintTimer.setCoalesce(true);
        this.setRepaintRate(-1);
        this.refresh();
    }

    public synchronized WaxLab getWaxLab() {
        return this.waxLab;
    }

    public synchronized void setWaxLab(WaxLab newWaxLab) {
        if (this.waxLab == newWaxLab) {
            return;
        }
        if (this.waxLab != null) {
            this.waxLab.unregisterWaxLabListener((WaxLabListener)this.waxLabHandler);
        }
        this.waxLab = newWaxLab;
        if (this.waxLab != null) {
            this.waxLab.registerWaxLabListener((WaxLabListener)this.waxLabHandler);
        }
        this.refreshDecks();
        this.startStopRepaintTimer();
    }

    public int getDeckLayout() {
        return this.deckLayout;
    }

    public synchronized void setDeckLayout(int deckLayout) {
        if (this.deckLayout == deckLayout) {
            return;
        }
        this.deckLayout = deckLayout;
        this.dvsHeaderPanel.refreshLayoutButtons();
        this.refresh();
    }

    public void toggleFullscreen() {
        WaxLabDvsView view = this.getDvsView();
        if (view != null) {
            view.setFullscreen(!view.isFullscreen());
        }
    }

    public synchronized void refresh() {
        Paint paint;
        WaxLabViewSettings viewSettings = this.getViewSettings();
        if (viewSettings != null && (paint = viewSettings.getDvsBackground()) != null) {
            this.setBackPaint(paint);
        }
        this.refreshDecks();
    }

    protected DvsDeck createDvsDeck(ScratchLine scratchLine, LockFactory lockFactory) {
        ScratchDeck scratchDeck = scratchLine.getScratchDeck();
        DvsDeck dvsDeck = new DvsDeck(lockFactory);
        dvsDeck.setScratchDeck(scratchDeck);
        return dvsDeck;
    }

    public synchronized void refreshDecks() {
        int numDecks;
        WaxLab waxLab = this.waxLab;
        int deckIndex = 0;
        if (waxLab != null) {
            int numLines = waxLab.getLineCount();
            if (this.closed) {
                numLines = 0;
            }
            for (int i = 0; i < numLines; ++i) {
                AbstractScratchLine scratchLine;
                ScratchDeck scratchDeck;
                Line line = waxLab.getLineAt(i);
                if (line == null || !(line instanceof AbstractScratchLine) || (scratchDeck = (scratchLine = (AbstractScratchLine)line).getScratchDeck()) == null) continue;
                boolean leftDeck = deckIndex % 2 == 0;
                DvsDeck dvsDeck = null;
                for (int numDecks2 = this.dvsDeckList.size(); deckIndex < numDecks2 && ((dvsDeck = (DvsDeck)this.dvsDeckList.get(deckIndex)) == null || dvsDeck.getScratchDeck() != scratchDeck); --numDecks2) {
                    this.dvsDeckList.remove(deckIndex);
                    this.disposeDvsDeck(dvsDeck);
                    dvsDeck = null;
                }
                if (dvsDeck == null) {
                    dvsDeck = this.createDvsDeck((ScratchLine)scratchLine, this.lockFactory);
                    this.dvsDeckList.add(deckIndex, dvsDeck);
                }
                dvsDeck.setLeftDeck(leftDeck);
                dvsDeck.setDeckLayout(this.deckLayout);
                dvsDeck.setViewSettings(this.viewSettings);
                dvsDeck.refreshDvsDeck();
                ++deckIndex;
            }
        }
        if (deckIndex < (numDecks = this.dvsDeckList.size())) {
            for (int i = numDecks - 1; i >= deckIndex; --i) {
                DvsDeck deckInfo = (DvsDeck)this.dvsDeckList.remove(i);
                if (deckInfo == null) continue;
                this.disposeDvsDeck(deckInfo);
            }
        }
        this.dvsDecks = this.dvsDeckList.toArray(new DvsDeck[this.dvsDeckList.size()]);
        this.layoutDeckViews();
        this.validate();
        this.repaint();
    }

    protected void disposeDvsDeck(DvsDeck deck) {
        deck.setScratchDeck(null);
    }

    protected synchronized void layoutDeckViews() {
        this.removeAll();
        this.dvsLayout.setInsets(new Insets(10, 10, 10, 10));
        this.dvsLayout.setDeckLayout(this.deckLayout);
        this.add((Component)this.dvsHeaderPanel, WaxLabDvsLayout.NORTH);
        int numDecks = this.dvsDeckList.size();
        for (int i = 0; i < numDecks; ++i) {
            DvsDeck dvsDeck = (DvsDeck)this.dvsDeckList.get(i);
            DvsDeckHeaderPanel deckHeaderPanel = dvsDeck.getDeckHeaderPanel();
            DvsDeckControlPanel deckControlPanel = dvsDeck.getDeckControlPanel();
            DeckClockViewComponent clockViewComponent = dvsDeck.getClockViewComponent();
            DeckTrackTouchPanel trackTouchBar = dvsDeck.getTrackTouchPanel();
            DeckTrackViewComponent trackViewComponent = dvsDeck.getTrackViewComponent();
            DeckScratchViewComponent scratchViewComponent = dvsDeck.getScratchViewComponent();
            boolean leftDeck = dvsDeck.isLeftDeck();
            if (deckHeaderPanel != null) {
                this.add((Component)deckHeaderPanel, leftDeck ? WaxLabDvsLayout.DECK_HEADER_LEFT : WaxLabDvsLayout.DECK_HEADER_RIGHT);
            }
            if (deckControlPanel != null) {
                this.add((Component)deckControlPanel, WaxLabDvsLayout.DECK_CONTROL);
            }
            if (clockViewComponent != null) {
                this.add((Component)((Object)clockViewComponent), WaxLabDvsLayout.DECK_CLOCK);
            }
            if (trackTouchBar != null) {
                this.add((Component)trackTouchBar, WaxLabDvsLayout.DECK_TOUCH);
            }
            if (trackViewComponent != null) {
                this.add((Component)((Object)trackViewComponent), WaxLabDvsLayout.DECK_TRACK);
            }
            if (scratchViewComponent == null) continue;
            this.add((Component)((Object)scratchViewComponent), WaxLabDvsLayout.DECK_SCRATCH);
        }
        if (this.dvsFooterPanel != null) {
            this.add((Component)this.dvsFooterPanel, WaxLabDvsLayout.SOUTH);
        }
    }

    protected synchronized void viewOpened(WaxLabDvsView view) {
        if (!this.closed) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("viewOpened: " + (Object)((Object)view));
        }
        this.closed = false;
        this.refreshDecks();
        this.startStopRepaintTimer();
    }

    protected synchronized void viewClosed(WaxLabDvsView view) {
        if (this.closed) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("viewClosed: " + (Object)((Object)view));
        }
        this.closed = true;
        this.refreshDecks();
        this.startStopRepaintTimer();
        this.handleFullscreenChanged(false);
        WaxLabPluginContext ctx = this.getPluginContext();
        if (ctx != null) {
            ctx.updateWaxLabDeviceProperties();
        }
    }

    public WaxLabViewSettings getViewSettings() {
        return this.viewSettings;
    }

    public void setViewSettings(WaxLabViewSettings viewSettings) {
        this.viewSettings = viewSettings;
        this.dvsHeaderPanel.setViewSettings(viewSettings);
        this.dvsFooterPanel.setViewSettings(viewSettings);
        this.refresh();
    }

    public Paint getBackPaint() {
        return this.backPaint;
    }

    public void setBackPaint(Paint backPaint) {
        this.backPaint = backPaint;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint p;
        Graphics2D g2d = (Graphics2D)g;
        if (this.isOpaque() && (p = this.backPaint) != null) {
            g2d.setPaint(p);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public int getRepaintRate() {
        return this.repaintRate;
    }

    public void setRepaintRate(int repaintRate) {
        this.repaintRate = repaintRate;
        if (repaintRate < 0) {
            repaintRate = 50;
        }
        int delay = repaintRate > 0 ? (int)Math.round(1000.0 / (double)repaintRate) : 86400000;
        this.repaintTimer.setInitialDelay(delay);
        this.repaintTimer.setDelay(delay);
    }

    protected synchronized void startStopRepaintTimer() {
        boolean active = false;
        if (this.waxLab != null) {
            active = this.waxLab.isActive();
        }
        if (this.closed) {
            active = false;
        }
        if (active) {
            if (!this.repaintTimer.isRunning()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("start repaintTimer: " + this);
                }
                this.repaintTimer.start();
            }
        } else if (this.repaintTimer.isRunning()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.info("stop repaintTimer: " + this);
            }
            this.repaintTimer.stop();
        }
    }

    public double getZoomRate() {
        return this.zoomRate;
    }

    public void setZoomRate(double zoomRate) {
        if (this.zoomRate == zoomRate) {
            return;
        }
        this.zoomRate = zoomRate;
        DvsDeck[] decks = this.dvsDecks;
        int num = decks.length;
        for (int i = 0; i < num; ++i) {
            decks[i].setZoomRate(zoomRate);
        }
    }

    public double getMinZoomRate() {
        return this.minZoomRate;
    }

    public void setMinZoomRate(double minZoomRate) {
        this.minZoomRate = minZoomRate;
    }

    public double getMaxZoomRate() {
        return this.maxZoomRate;
    }

    public void setMaxZoomRate(double maxZoomRate) {
        this.maxZoomRate = maxZoomRate;
    }

    public WaxLabPluginContext getPluginContext() {
        return this.pluginContext;
    }

    public void setPluginContext(WaxLabPluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public WaxLabDvsView getDvsView() {
        return this.dvsView;
    }

    public void setDvsView(WaxLabDvsView dvsView) {
        this.dvsView = dvsView;
    }

    protected void handleFullscreenChanged(boolean fullscreen) {
        this.dvsHeaderPanel.handleFullscreenChanged(fullscreen);
    }

    protected class Repainter
    implements ActionListener {
        protected Repainter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            DvsDeck[] decks = WaxLabDvsPanel.this.dvsDecks;
            int num = decks.length;
            for (i = 0; i < num; ++i) {
                decks[i].scrollViews();
            }
            for (i = 0; i < num; ++i) {
                decks[i].repaintViews();
            }
        }
    }

    protected class RefreshDecks
    implements Runnable {
        protected RefreshDecks() {
        }

        @Override
        public void run() {
            WaxLabDvsPanel.this.refreshDecks();
        }
    }

    protected class WaxLabHandler
    implements WaxLabListener {
        protected WaxLabHandler() {
        }

        public void stateChanged(boolean active) {
            WaxLabDvsPanel.this.refreshDecks();
            WaxLabDvsPanel.this.startStopRepaintTimer();
        }

        public void lineChanged(Line line) {
            SwingUtilities.invokeLater(WaxLabDvsPanel.this.refreshDecks);
        }

        public void lineInserted(Line line, int index) {
            SwingUtilities.invokeLater(WaxLabDvsPanel.this.refreshDecks);
        }

        public void lineRemoved(Line line, int index) {
            SwingUtilities.invokeLater(WaxLabDvsPanel.this.refreshDecks);
        }

        public void lineMoved(Line line, int newIndex) {
            SwingUtilities.invokeLater(WaxLabDvsPanel.this.refreshDecks);
        }
    }
}

