/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.dvs;

import com.spacekiller.util.swing.FullscreenSupport;
import com.spacekiller.util.workbench.DesktopView;
import com.spacekiller.util.workbench.FullscreenView;
import com.spacekiller.util.workbench.View;
import com.waxmonster.waxlab.dvs.WaxLabDvsPanel;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class WaxLabDvsView
extends View
implements FullscreenView {
    private final WaxLabDvsPanel dvsPanel;
    private FullscreenSupport fullscreenSupport;

    public WaxLabDvsView(WaxLabDvsPanel dvsPanel) {
        this.dvsPanel = dvsPanel;
        this.fullscreenSupport = new FullscreenSupportImpl();
    }

    public WaxLabDvsPanel getDvsPanel() {
        return this.dvsPanel;
    }

    protected Component createComponent() {
        return this.dvsPanel;
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected void parentChanged(View oldParent, View newParent) {
        super.parentChanged(oldParent, newParent);
        if (oldParent == newParent) {
            return;
        }
        if (newParent == null) {
            this.dvsPanel.viewClosed(this);
        } else {
            this.dvsPanel.viewOpened(this);
        }
    }

    protected synchronized void dispose() {
        super.dispose();
        this.dvsPanel.viewClosed(this);
    }

    public boolean isFullscreen() {
        FullscreenSupport fs = this.fullscreenSupport;
        return fs == null ? false : fs.isWindowFullscreen();
    }

    public void setFullscreen(boolean fullscreen) {
        if (fullscreen) {
            DesktopView deskView;
            View parentView = this.getParent();
            if (parentView != null && parentView instanceof DesktopView && !(deskView = (DesktopView)parentView).isViewDetached((View)this)) {
                deskView.detachView((View)this);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FullscreenSupport fs = WaxLabDvsView.this.fullscreenSupport;
                    if (fs != null) {
                        fs.setWindowFullscreen(true);
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FullscreenSupport fs = WaxLabDvsView.this.fullscreenSupport;
                    if (fs != null) {
                        fs.setWindowFullscreen(false);
                    }
                }
            });
        }
    }

    public FullscreenSupport getFullscreenSupport() {
        return this.fullscreenSupport;
    }

    protected void fullscreenStateChanged(boolean fullscreen) {
        this.dvsPanel.handleFullscreenChanged(fullscreen);
    }

    protected class FullscreenSupportImpl
    extends FullscreenSupport {
        protected FullscreenSupportImpl() {
        }

        protected void handleFullscreenChanged(boolean fullscreen) {
            super.handleFullscreenChanged(fullscreen);
            WaxLabDvsView.this.fullscreenStateChanged(fullscreen);
        }
    }
}

