/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.blaf;

import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.swing.LookAndFeelChooser;
import com.spacekiller.util.swing.LookAndFeelManager;
import com.spacekiller.util.swing.LookAndFeelStyle;
import com.spacekiller.util.swing.LookAndFeelType;
import com.spacekiller.util.workbench.AbstractPreferencesPage;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;

public class LookAndFeelPreferencesPage
extends AbstractPreferencesPage
implements InfectionPreferencesConstants {
    private PreferencesRegistry registry;
    private static final Logger logger = Logger.getLogger(LookAndFeelPreferencesPage.class.getName());

    public Component createComponent() {
        LookAndFeelChooser lafChooser = new LookAndFeelChooser();
        return lafChooser;
    }

    public void refreshPreferences(View view) throws Exception {
        Component comp = view.getComponent();
        if (comp == null) {
            return;
        }
        LookAndFeelChooser lafChooser = (LookAndFeelChooser)comp;
        String lafType = null;
        String lafStyle = null;
        Preferences prefs = this.getPreferences();
        if (prefs != null) {
            lafType = (String)prefs.getObject("laf.type");
            lafStyle = (String)prefs.getObject("laf.style");
        }
        LookAndFeelManager lafManager = LookAndFeelManager.getInstance();
        LookAndFeelType[] lafTypes = lafManager.getLookAndFeelTypes();
        LookAndFeelType type = null;
        LookAndFeelStyle style = null;
        if (lafType != null) {
            block0: for (int c = 0; c < lafTypes.length; ++c) {
                if (!lafType.equals(lafTypes[c].getName())) continue;
                type = lafTypes[c];
                if (lafStyle == null) break;
                int numStyles = type.getStyleCount();
                for (int s = 0; s < numStyles; ++s) {
                    LookAndFeelStyle st = type.getStyleAt(s);
                    if (!lafStyle.equals(st.getName())) continue;
                    style = st;
                    break block0;
                }
                break;
            }
        }
        lafChooser.setSelectedLookAndFeel(type, style);
    }

    public void resetPreferences(View view) {
    }

    public void savePreferences(View view) throws Exception {
        Component comp = view.getComponent();
        if (comp == null) {
            return;
        }
        LookAndFeelChooser lafChooser = (LookAndFeelChooser)comp;
        LookAndFeel laf = lafChooser.getLookAndFeel();
        logger.fine("Applying LookAndFeel: " + laf);
        if (laf == null) {
            return;
        }
        LookAndFeelManager.getInstance().setLookAndFeel(laf);
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            prefs = this.getRegistry().createPreferences("platform.look-and-feel");
        }
        LookAndFeelType lafType = lafChooser.getSelectedLookAndFeelType();
        LookAndFeelStyle lafStyle = lafChooser.getSelectedLookAndFeelStyle();
        String lafTypeName = lafType == null ? null : lafType.getName();
        String lafStyleName = lafStyle == null ? null : lafStyle.getName();
        prefs.setObject("laf.type", (Object)lafTypeName);
        prefs.setObject("laf.style", (Object)lafStyleName);
        this.getRegistry().savePreferences(prefs);
    }

    protected PreferencesRegistry createRegistry() {
        return Platform.getInstance().getPreferencesRegistry();
    }

    protected PreferencesRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(this.createRegistry());
        }
        return this.registry;
    }

    protected void setRegistry(PreferencesRegistry registry) {
        this.registry = registry;
    }

    protected Preferences getPreferences() throws Exception {
        return this.getRegistry().getPreferences("platform.look-and-feel");
    }
}

