/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.cmd;

import com.spacekiller.infection.plugin.cmd.CommandLine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeCommandLine
implements CommandLine {
    private InputStream inputStream = new CommandLineInputStream();
    private InputStream errorStream = new CommandLineErrorStream();
    private Runtime runtime;
    private InputStream in;
    private InputStream err;
    private OutputStream out;
    private boolean running;
    private Process process;
    private int returnCode;
    private static final Logger logger = Logger.getLogger(RuntimeCommandLine.class.getName());

    public RuntimeCommandLine() throws Exception {
        this.setRuntime(Runtime.getRuntime());
    }

    protected Runtime getRuntime() {
        return this.runtime;
    }

    protected void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(String[] command) throws Exception {
        this.setReturnCode(-1);
        this.setRunning(true);
        try {
            this.process = this.runtime.exec(command);
            this.in = this.process.getInputStream();
            this.err = this.process.getErrorStream();
            this.out = this.process.getOutputStream();
            InputStream inputStream = this.inputStream;
            synchronized (inputStream) {
                this.inputStream.notify();
            }
            inputStream = this.errorStream;
            synchronized (inputStream) {
                this.errorStream.notify();
            }
            int rc = this.process.waitFor();
            this.setReturnCode(rc);
        }
        finally {
            this.setRunning(false);
            this.process = null;
        }
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    protected void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public InputStream getErrorStream() throws Exception {
        return this.errorStream;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws Exception {
        return this.out;
    }

    @Override
    public void terminate() throws Exception {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    protected class CommandLineErrorStream
    extends InputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            while (RuntimeCommandLine.this.err == null) {
                try {
                    CommandLineErrorStream commandLineErrorStream = this;
                    synchronized (commandLineErrorStream) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    return -1;
                }
            }
            return RuntimeCommandLine.this.err.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            while (RuntimeCommandLine.this.err == null) {
                try {
                    CommandLineErrorStream commandLineErrorStream = this;
                    synchronized (commandLineErrorStream) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    return -1;
                }
            }
            return RuntimeCommandLine.this.err.read(b, off, len);
        }
    }

    protected class CommandLineInputStream
    extends InputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            while (RuntimeCommandLine.this.in == null) {
                try {
                    CommandLineInputStream commandLineInputStream = this;
                    synchronized (commandLineInputStream) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    return -1;
                }
            }
            return RuntimeCommandLine.this.in.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            while (RuntimeCommandLine.this.in == null) {
                try {
                    CommandLineInputStream commandLineInputStream = this;
                    synchronized (commandLineInputStream) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    return -1;
                }
            }
            return RuntimeCommandLine.this.in.read(b, off, len);
        }
    }
}

