/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.help;

import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.plugin.help.PackageDetailsPanel;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AboutPanel
extends JPanel {
    private static final long serialVersionUID = 4947544709293507632L;
    private Icon splashIcon;
    private JLabel jLabelSplash = null;
    private Object dialog;

    public AboutPanel() {
        this.initialize();
        this.initAboutPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.gridy = 0;
        this.jLabelSplash = new JLabel();
        this.jLabelSplash.setText("");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(505, 365));
        this.add((Component)this.jLabelSplash, gridBagConstraints1);
    }

    protected void initAboutPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.anchor = 14;
        this.add(buttonPanel, gridBagConstraints1, 0);
        JButton buttonDetails = new JButton("Details");
        buttonDetails.setFont(buttonPanel.getFont());
        buttonDetails.setOpaque(false);
        buttonDetails.setBorderPainted(false);
        buttonDetails.setMargin(new Insets(0, 0, 0, 0));
        buttonPanel.add(buttonDetails);
        buttonDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutPanel.this.showDetails();
            }
        });
        JButton buttonClose = new JButton("Close");
        buttonClose.setFont(buttonPanel.getFont());
        buttonClose.setOpaque(false);
        buttonClose.setBorderPainted(false);
        buttonClose.setMargin(new Insets(0, 0, 0, 0));
        buttonPanel.add(buttonClose);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutPanel.this.close();
            }
        });
    }

    public void showDialog() {
        this.showDialog(null);
    }

    public void showDialog(Component parent) {
        Window parentWindow;
        JDialog dialog = null;
        if (parent != null && (parentWindow = SwingUtilities.getWindowAncestor(parent)) != null) {
            if (parentWindow instanceof Dialog) {
                dialog = new JDialog((Dialog)parentWindow);
            }
            if (parentWindow instanceof Frame) {
                dialog = new JDialog((Frame)parentWindow);
            }
        }
        if (dialog == null) {
            dialog = new JDialog();
        }
        this.dialog = dialog;
        dialog.setTitle("About");
        dialog.setContentPane(this);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.pack();
        Tools.centerWindow((Component)parent, (Window)dialog);
        dialog.setVisible(true);
    }

    private void close() {
        if (this.dialog == null) {
            return;
        }
        ((JDialog)this.dialog).dispose();
    }

    public static void main(String[] args) {
        new AboutPanel().showDialog();
    }

    protected void showDetails() {
        Platform platform = Platform.getInstance();
        if (platform == null) {
            return;
        }
        Package[] pkgs = null;
        if (platform instanceof InfectionPlatform) {
            InfectionPlatform ip = (InfectionPlatform)platform;
            pkgs = ip.getPackages();
        }
        PackageDetailsPanel detailsPanel = new PackageDetailsPanel();
        detailsPanel.setPackages(pkgs);
        detailsPanel.setOpaque(true);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.fill = 1;
        this.add(detailsPanel, gridBagConstraints1, 0);
        this.validate();
        this.repaint();
    }

    public Icon getSplashIcon() {
        return this.splashIcon;
    }

    public void setSplashIcon(Icon splashIcon) {
        this.splashIcon = splashIcon;
        this.jLabelSplash.setIcon(splashIcon);
    }
}

