/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.log;

import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.platform.LogHistory;
import com.spacekiller.infection.plugin.log.LogViewToolContext;
import com.spacekiller.util.Platform;
import com.spacekiller.util.status.LogRecordTableViewer;
import com.spacekiller.util.tooling.AbstractToolContext;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LogView
extends View {
    private ToolContextImpl toolContext = new ToolContextImpl();
    private ToolGroup toolbarGroup;
    private LogRecordTableViewer logRecordTableViewer;

    protected Component createComponent() {
        return this.getLogRecordTableViewer();
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    public void clear() {
        this.getLogRecordTableViewer().clear();
    }

    public boolean isAutoScroll() {
        return this.getLogRecordTableViewer().isAutoScroll();
    }

    public void setAutoScroll(boolean auto) {
        this.getLogRecordTableViewer().setAutoScroll(auto);
    }

    public synchronized void close() {
        super.close();
    }

    public ToolGroup getToolbarGroup() {
        return this.toolbarGroup;
    }

    public void setToolbarGroup(ToolGroup toolbarGroup) {
        this.toolbarGroup = toolbarGroup;
    }

    protected LogRecordTableViewer createLogRecordTableViewer() {
        InfectionPlatform ip;
        LogHistory hist;
        Platform plat;
        LogRecordTableViewer viewer = new LogRecordTableViewer();
        viewer.setToolContext((ToolContext)this.toolContext);
        viewer.setToolbarGroup(this.toolbarGroup);
        LogRecordTableViewer.LogHandler handler = viewer.getLogHandler();
        if (handler != null && (plat = Platform.getInstance()) instanceof InfectionPlatform && (hist = (ip = (InfectionPlatform)plat).getLogHistory()) != null) {
            ArrayList recs = new ArrayList();
            hist.getLogRecords(recs);
            Iterator i = recs.iterator();
            while (i.hasNext()) {
                handler.publish((LogRecord)i.next());
            }
            hist.addHandler((Handler)handler);
        }
        return viewer;
    }

    public LogRecordTableViewer getLogRecordTableViewer() {
        if (this.logRecordTableViewer == null) {
            this.setLogRecordTableViewer(this.createLogRecordTableViewer());
        }
        return this.logRecordTableViewer;
    }

    protected void setLogRecordTableViewer(LogRecordTableViewer logRecordTableViewer) {
        this.logRecordTableViewer = logRecordTableViewer;
    }

    private class ToolContextImpl
    extends AbstractToolContext
    implements LogViewToolContext {
        private ToolContextImpl() {
        }

        public Workbench getWorkbench() {
            Perspective pers = this.getPerspective();
            if (pers != null) {
                return pers.getWorkbench();
            }
            return null;
        }

        public Perspective getPerspective() {
            return LogView.this.getPerspective();
        }

        public View getView() {
            return LogView.this;
        }

        @Override
        public LogView getLogView() {
            return LogView.this;
        }
    }
}

