/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.run;

import com.spacekiller.infection.plugin.run.RunConfig;
import com.spacekiller.infection.plugin.run.RunConfigManager;
import com.spacekiller.infection.plugin.run.RunConfigPanel;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.PreferencesRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RunPanel
extends JPanel {
    private static final long serialVersionUID = 906728282771568325L;
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private PreferencesRegistry preferencesRegistry;
    private RunConfigManager runConfigManager;
    private DefaultListModel listModel;
    private JSplitPane jSplitPane = null;
    private JScrollPane jScrollPane1 = null;
    private JList jListConfig = null;
    private JPanel jPanelLeft = null;
    private JPanel jPanelRight = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField jTextFieldName = null;
    private RunConfigPanel runConfigPanel = null;
    private JButton jButtonRun = null;
    private JPanel jPanel = null;
    private JButton jButtonNew = null;
    private JButton jButtonDelete = null;
    private JButton jButtonApply = null;
    private static final Logger logger = Logger.getLogger(RunPanel.class.getName());

    public RunPanel() {
        this.initialize();
        this.initRunPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(479, 287));
        this.add((Component)this.getJSplitPane(), gridBagConstraints);
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setLeftComponent(this.getJPanelLeft());
            this.jSplitPane.setRightComponent(this.getJPanelRight());
        }
        return this.jSplitPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane1.setViewportView(this.getJListConfig());
        }
        return this.jScrollPane1;
    }

    private JList getJListConfig() {
        if (this.jListConfig == null) {
            this.jListConfig = new JList();
            this.jListConfig.setOpaque(false);
            this.jListConfig.setSelectionMode(0);
            this.jListConfig.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    RunPanel.this.refreshRunConfig();
                    RunPanel.this.checkEnable();
                }
            });
        }
        return this.jListConfig;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        this.getRunConfigPanel().setBeansToolkit(beansToolkit);
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
        this.getRunConfigPanel().setClassRegistry(classRegistry);
    }

    private JPanel getJPanelLeft() {
        if (this.jPanelLeft == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Configurations:");
            this.jLabel.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.insets = new Insets(0, 4, 0, 4);
            gridBagConstraints1.weightx = 1.0;
            this.jPanelLeft = new JPanel();
            this.jPanelLeft.setLayout(new GridBagLayout());
            this.jPanelLeft.setOpaque(true);
            this.jPanelLeft.add((Component)this.getJScrollPane1(), gridBagConstraints1);
            this.jPanelLeft.add((Component)this.jLabel, gridBagConstraints2);
            this.jPanelLeft.add((Component)this.getJPanel(), gridBagConstraints7);
        }
        return this.jPanelLeft;
    }

    private JPanel getJPanelRight() {
        if (this.jPanelRight == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints10.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridwidth = 3;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.insets = new Insets(0, 4, 0, 4);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setFont(new Font("Dialog", 0, 12));
            this.jLabel1.setText("Name:");
            this.jPanelRight = new JPanel();
            this.jPanelRight.setLayout(new GridBagLayout());
            this.jPanelRight.add((Component)this.jLabel1, gridBagConstraints3);
            this.jPanelRight.add((Component)this.getJTextFieldName(), gridBagConstraints4);
            this.jPanelRight.add((Component)this.getRunConfigPanel(), gridBagConstraints5);
            this.jPanelRight.add((Component)this.getJButtonRun(), gridBagConstraints6);
            this.jPanelRight.add((Component)this.getJButtonApply(), gridBagConstraints10);
        }
        return this.jPanelRight;
    }

    private JTextField getJTextFieldName() {
        if (this.jTextFieldName == null) {
            this.jTextFieldName = new JTextField();
            this.jTextFieldName.setOpaque(false);
        }
        return this.jTextFieldName;
    }

    private RunConfigPanel getRunConfigPanel() {
        if (this.runConfigPanel == null) {
            this.runConfigPanel = new RunConfigPanel();
        }
        return this.runConfigPanel;
    }

    private JButton getJButtonRun() {
        if (this.jButtonRun == null) {
            this.jButtonRun = new JButton();
            this.jButtonRun.setText("Run");
            this.jButtonRun.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonRun.setToolTipText("Run selected configuration");
            this.jButtonRun.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/run_exc.gif")));
            this.jButtonRun.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunPanel.this.actionRun();
                }
            });
        }
        return this.jButtonRun;
    }

    protected void initRunPanel() {
        this.listModel = new DefaultListModel();
        this.getJListConfig().setModel(this.listModel);
        this.getJButtonApply().setEnabled(false);
        this.getJButtonRun().setEnabled(false);
        this.getJButtonDelete().setEnabled(false);
        this.refreshConfigurations();
    }

    protected void refreshConfigurations() {
        TreeSet<RunConfig> set = new TreeSet<RunConfig>(new RunConfigComparator());
        if (this.runConfigManager != null) {
            int num = this.runConfigManager.getRunConfigCount();
            for (int i = 0; i < num; ++i) {
                set.add(this.runConfigManager.getRunConfigAt(i));
            }
        }
        int index = 0;
        for (RunConfig config : set) {
            this.listModel.add(index, config);
            ++index;
        }
    }

    protected void actionNew() {
        RunConfig runConfig = new RunConfig();
        runConfig.setTitle("New configuration");
        this.addRunConfig(runConfig);
    }

    protected void addRunConfig(RunConfig config) {
        int index = this.listModel.size();
        this.listModel.add(index, config);
        this.getJListConfig().setSelectedIndex(index);
        if (this.runConfigManager != null) {
            this.runConfigManager.addRunConfig(config);
        }
    }

    protected void actionDelete() {
        int sel = this.getJListConfig().getSelectedIndex();
        if (sel >= 0) {
            Object obj = this.listModel.remove(sel);
            if (this.runConfigManager != null) {
                RunConfig config = (RunConfig)obj;
                this.runConfigManager.removeRunConfig(config);
            }
        }
    }

    protected void actionApply() {
        RunConfig config = null;
        int sel = this.getJListConfig().getSelectedIndex();
        if (sel >= 0) {
            config = (RunConfig)this.listModel.get(sel);
        }
        if (config == null) {
            return;
        }
        String name = this.getJTextFieldName().getText();
        config.setTitle(name);
        this.getRunConfigPanel().apply();
        this.getJListConfig().validate();
        this.getJListConfig().repaint();
        if (this.runConfigManager != null) {
            this.runConfigManager.addRunConfig(config);
        }
    }

    protected void actionRun() {
        try {
            this.actionApply();
            RunConfig config = null;
            int sel = this.getJListConfig().getSelectedIndex();
            if (sel >= 0) {
                config = (RunConfig)this.listModel.get(sel);
            }
            if (config == null) {
                return;
            }
            config.setLastRunTime(System.currentTimeMillis());
            if (this.runConfigManager != null) {
                this.runConfigManager.addRunConfig(config);
            }
            config.run();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected void refreshRunConfig() {
        RunConfig config = null;
        int sel = this.getJListConfig().getSelectedIndex();
        if (sel >= 0) {
            config = (RunConfig)this.listModel.get(sel);
        }
        if (config == null) {
            this.getJTextFieldName().setText("");
            this.getJTextFieldName().setEnabled(false);
        } else {
            this.getJTextFieldName().setText(String.valueOf(config.getTitle()));
            this.getJTextFieldName().setEnabled(true);
        }
        this.getRunConfigPanel().setRunConfig(config);
    }

    protected void checkEnable() {
        boolean enableDel = false;
        boolean enableApply = false;
        boolean enableRun = false;
        int i = this.getJListConfig().getSelectedIndex();
        if (i >= 0) {
            enableDel = true;
            enableApply = true;
            enableRun = true;
        }
        this.getJButtonDelete().setEnabled(enableDel);
        this.getJButtonApply().setEnabled(enableApply);
        this.getJButtonRun().setEnabled(enableRun);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.insets = new Insets(4, 4, 4, 4);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setOpaque(false);
            this.jPanel.add((Component)this.getJButtonNew(), gridBagConstraints8);
            this.jPanel.add((Component)this.getJButtonDelete(), gridBagConstraints9);
        }
        return this.jPanel;
    }

    private JButton getJButtonNew() {
        if (this.jButtonNew == null) {
            this.jButtonNew = new JButton();
            this.jButtonNew.setText("New");
            this.jButtonNew.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/newaccessbean_wiz.gif")));
            this.jButtonNew.setFont(new Font("Dialog", 0, 12));
            this.jButtonNew.setToolTipText("Create new configuration...");
            this.jButtonNew.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunPanel.this.actionNew();
                }
            });
        }
        return this.jButtonNew;
    }

    private JButton getJButtonDelete() {
        if (this.jButtonDelete == null) {
            this.jButtonDelete = new JButton();
            this.jButtonDelete.setFont(new Font("Dialog", 0, 12));
            this.jButtonDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/close_window.gif")));
            this.jButtonDelete.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonDelete.setText("Delete");
            this.jButtonDelete.setToolTipText("Delete selected configuration");
            this.jButtonDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunPanel.this.actionDelete();
                }
            });
        }
        return this.jButtonDelete;
    }

    public PreferencesRegistry getPreferencesRegistry() {
        return this.preferencesRegistry;
    }

    public void setPreferencesRegistry(PreferencesRegistry preferencesRegistry) {
        this.preferencesRegistry = preferencesRegistry;
    }

    private JButton getJButtonApply() {
        if (this.jButtonApply == null) {
            this.jButtonApply = new JButton();
            this.jButtonApply.setToolTipText("Apply changes..");
            this.jButtonApply.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonApply.setText("Apply");
            this.jButtonApply.setFont(new Font("Dialog", 0, 12));
            this.jButtonApply.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/okay.gif")));
            this.jButtonApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunPanel.this.actionApply();
                }
            });
        }
        return this.jButtonApply;
    }

    public RunConfigManager getRunConfigManager() {
        return this.runConfigManager;
    }

    public void setRunConfigManager(RunConfigManager runConfigManager) {
        this.runConfigManager = runConfigManager;
        this.refreshConfigurations();
    }

    protected class RunConfigComparator
    implements Comparator {
        protected RunConfigComparator() {
        }

        public int compare(Object a, Object b) {
            RunConfig ca = (RunConfig)a;
            RunConfig cb = (RunConfig)b;
            String aName = ca.getTitle();
            String bName = cb.getTitle();
            if (aName == null) {
                return bName == null ? 0 : -1;
            }
            return aName.compareTo(bName);
        }
    }
}

