/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.window;

import com.spacekiller.infection.plugin.window.WindowListView;
import com.spacekiller.util.Platform;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.swing.TransListCellRenderer;
import com.spacekiller.util.swing.WindowManager;
import com.spacekiller.util.workbench.EmbeddedWindowView;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WindowListPanel
extends JPanel {
    private static final long serialVersionUID = 2224484321900494308L;
    private WindowManager windowManager;
    private DefaultListModel listModel;
    private WindowListView windowListView;
    private WindowHandler windowHandler = new WindowHandler();
    private Icon defaultIcon;
    private boolean promptDispose = true;
    private JScrollPane jScrollPane = null;
    private JList jListWindow = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuItemClose = null;
    private JMenuItem jMenuItemDispose = null;
    private JMenuItem jMenuItemToFront = null;
    private JSeparator jSeparator = null;
    private JSeparator jSeparator1 = null;
    private JMenuItem jMenuItemEmbed = null;
    private static final Logger logger = Logger.getLogger(WindowListPanel.class.getName());

    public WindowListPanel() {
        this.initialize();
        this.initWindowListPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(292, 208));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJListWindow());
        }
        return this.jScrollPane;
    }

    private JList getJListWindow() {
        if (this.jListWindow == null) {
            this.jListWindow = new JList();
            this.jListWindow.setOpaque(false);
            this.jListWindow.setSelectionMode(0);
            this.jListWindow.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    logger.fine("valueChanged()");
                }
            });
            this.jListWindow.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    logger.fine("keyTyped()");
                }
            });
            this.jListWindow.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int count = e.getClickCount();
                    if (count == 2) {
                        WindowListPanel.this.actionToFront();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        WindowListPanel.this.showContextMenu(e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        WindowListPanel.this.showContextMenu(e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
        return this.jListWindow;
    }

    protected void initWindowListPanel() {
        this.getJListWindow().setCellRenderer(new WindowListCellRenderer());
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuItemToFront());
            this.jPopupMenu.add(this.getJSeparator());
            this.jPopupMenu.add(this.getJMenuItemEmbed());
            this.jPopupMenu.add(this.getJSeparator1());
            this.jPopupMenu.add(this.getJMenuItemClose());
            this.jPopupMenu.add(this.getJMenuItemDispose());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemClose() {
        if (this.jMenuItemClose == null) {
            this.jMenuItemClose = new JMenuItem();
            this.jMenuItemClose.setText("Close");
            this.jMenuItemClose.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/close_window.gif")));
            this.jMenuItemClose.setToolTipText("Close the selected window..");
            this.jMenuItemClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowListPanel.this.actionCloseWindow();
                }
            });
        }
        return this.jMenuItemClose;
    }

    private JMenuItem getJMenuItemDispose() {
        if (this.jMenuItemDispose == null) {
            this.jMenuItemDispose = new JMenuItem();
            this.jMenuItemDispose.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/cancel.gif")));
            this.jMenuItemDispose.setText("Dispose");
            this.jMenuItemDispose.setToolTipText("Dispose the selected window without notification..");
            this.jMenuItemDispose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowListPanel.this.actionDisposeWindow();
                }
            });
        }
        return this.jMenuItemDispose;
    }

    private JMenuItem getJMenuItemToFront() {
        if (this.jMenuItemToFront == null) {
            this.jMenuItemToFront = new JMenuItem();
            this.jMenuItemToFront.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/window16.gif")));
            this.jMenuItemToFront.setText("Show");
            this.jMenuItemToFront.setToolTipText("Show the selected window..");
            this.jMenuItemToFront.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowListPanel.this.actionToFront();
                }
            });
        }
        return this.jMenuItemToFront;
    }

    private JSeparator getJSeparator() {
        if (this.jSeparator == null) {
            this.jSeparator = new JSeparator();
        }
        return this.jSeparator;
    }

    private JSeparator getJSeparator1() {
        if (this.jSeparator1 == null) {
            this.jSeparator1 = new JSeparator();
        }
        return this.jSeparator1;
    }

    private JMenuItem getJMenuItemEmbed() {
        if (this.jMenuItemEmbed == null) {
            this.jMenuItemEmbed = new JMenuItem();
            this.jMenuItemEmbed.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/import_wiz.gif")));
            this.jMenuItemEmbed.setText("Embed");
            this.jMenuItemEmbed.setToolTipText("Embed the selected window..");
            this.jMenuItemEmbed.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowListPanel.this.actionEmbedWindow();
                }
            });
        }
        return this.jMenuItemEmbed;
    }

    public static void main(String[] args) {
        try {
            JFrame dummy1 = new JFrame("Dummy1");
            dummy1.setBounds(300, 100, 50, 50);
            dummy1.setVisible(true);
            WindowListPanel panel = new WindowListPanel();
            JFrame frame = new JFrame("Window List");
            frame.setDefaultCloseOperation(3);
            frame.setContentPane(panel);
            frame.addWindowListener(panel.getWindowHandler());
            frame.pack();
            frame.setVisible(true);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(1);
        }
    }

    public synchronized void refresh() {
        Object sel = this.getJListWindow().getSelectedValue();
        this.listModel = new DefaultListModel();
        try {
            WindowManager man = this.getWindowManager();
            if (man != null) {
                Window[] wins = man.getWindowArray();
                logger.fine("Refresh window list: windowCount=" + wins.length);
                for (int i = 0; i < wins.length; ++i) {
                    Window win = wins[i];
                    if (!win.isVisible()) continue;
                    this.listModel.addElement(win);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.getJListWindow().setModel(this.listModel);
        if (sel != null) {
            this.getJListWindow().setSelectedValue(sel, true);
        }
    }

    protected WindowHandler getWindowHandler() {
        return this.windowHandler;
    }

    void setWindowHandler(WindowHandler windowHandler) {
        this.windowHandler = windowHandler;
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    protected Object getSelectedObject() {
        return this.getJListWindow().getSelectedValue();
    }

    protected void actionToFront() {
        Object obj = this.getSelectedObject();
        if (obj == null) {
            return;
        }
        if (obj instanceof Window) {
            Window win = (Window)obj;
            win.toFront();
        }
        if (obj instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)obj;
            frame.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionCloseWindow() {
        Object obj = this.getSelectedObject();
        if (obj == null) {
            return;
        }
        try {
            JInternalFrame frame;
            InternalFrameListener[] listeners;
            int n;
            if (obj instanceof Window) {
                Window win = (Window)obj;
                this.windowManager.closeWindow(win);
            }
            if (obj instanceof JInternalFrame && (n = (listeners = (frame = (JInternalFrame)obj).getInternalFrameListeners()).length) > 0) {
                InternalFrameEvent ev = new InternalFrameEvent(frame, 25550);
                for (int c = 0; c < n; ++c) {
                    listeners[c].internalFrameClosing(ev);
                }
            }
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionDisposeWindow() {
        Object obj = this.getSelectedObject();
        if (obj == null) {
            return;
        }
        try {
            RuntimeContext rc;
            if (this.isPromptDispose() && (rc = Platform.getInstance().getRuntimeContext()) != null) {
                String title = "Dispose ?";
                String message = "Are you sure to dispose the selected window ?";
                if (!rc.prompt(title, (Object)(message = message + "\nWarning: unsaved changes may be lost."))) {
                    return;
                }
            }
            if (obj instanceof Window) {
                Window win = (Window)obj;
                win.dispose();
            }
            if (obj instanceof JInternalFrame) {
                JInternalFrame frame = (JInternalFrame)obj;
                frame.dispose();
            }
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionEmbedWindow() {
        Object obj;
        if (this.windowListView == null) {
            return;
        }
        Perspective pers = this.windowListView.getPerspective();
        if (pers == null) {
            return;
        }
        Window persWindow = null;
        Component persComp = pers.getComponent();
        if (persComp != null) {
            persWindow = SwingUtilities.windowForComponent(persComp);
        }
        if ((obj = this.getSelectedObject()) == null) {
            return;
        }
        try {
            if (obj instanceof Window) {
                Window win = (Window)obj;
                if (win == persWindow) {
                    logger.fine("Cannot embed window into itself: " + win);
                    return;
                }
                logger.fine("Embedding window: " + win);
                EmbeddedWindowView view = new EmbeddedWindowView(win);
                pers.addView((View)view);
                return;
            }
            logger.fine("Cannot embed window object: " + obj);
        }
        finally {
            this.refresh();
        }
    }

    protected void actionMinimizeWindow() {
    }

    protected void actionMaximizeWindow() {
    }

    protected void actionRestoreWindow() {
    }

    protected void showContextMenu(int x, int y) {
        int i = this.getJListWindow().locationToIndex(new Point(x, y));
        if (i >= 0 && i < this.listModel.size()) {
            this.getJListWindow().setSelectedIndex(i);
        } else {
            this.getJListWindow().clearSelection();
        }
        i = this.getJListWindow().getSelectedIndex();
        if (i < 0) {
            return;
        }
        this.getJPopupMenu().show(this.getJListWindow(), x, y);
    }

    public boolean isPromptDispose() {
        return this.promptDispose;
    }

    public void setPromptDispose(boolean promptDispose) {
        this.promptDispose = promptDispose;
    }

    public WindowListView getWindowListView() {
        return this.windowListView;
    }

    public void setWindowListView(WindowListView windowListView) {
        this.windowListView = windowListView;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public synchronized void setWindowManager(WindowManager newWindowManager) {
        if (this.windowManager == newWindowManager) {
            return;
        }
        if (this.windowManager != null) {
            this.windowManager.removeWindowListener((WindowListener)this.windowHandler);
        }
        this.windowManager = newWindowManager;
        if (this.windowManager != null) {
            this.windowManager.addWindowListener((WindowListener)this.windowHandler);
        }
        this.refresh();
    }

    public void dispose() {
        this.setWindowManager(null);
        this.windowListView = null;
        if (this.listModel != null) {
            this.listModel.clear();
            this.listModel = null;
        }
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            logger.finer("windowActivated: " + e);
            WindowListPanel.this.refresh();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            logger.finer("windowDeactivated: " + e);
            WindowListPanel.this.refresh();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            logger.finer("windowOpened: " + e);
            WindowListPanel.this.refresh();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            logger.finer("windowClosed: " + e);
            WindowListPanel.this.refresh();
        }
    }

    protected class WindowListCellRenderer
    extends TransListCellRenderer {
        private static final long serialVersionUID = 8660846647787335056L;

        protected WindowListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rc = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String text = null;
            Icon icon = null;
            if (value != null && value instanceof Window) {
                Window win = (Window)value;
                if (value instanceof Frame) {
                    Frame frame = (Frame)win;
                    text = frame.getTitle();
                    Image iconImage = frame.getIconImage();
                    if (iconImage != null) {
                        icon = new ImageIcon(iconImage);
                    }
                }
                if (text == null || text.length() < 1) {
                    text = win.getName();
                }
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            if (icon == null) {
                icon = WindowListPanel.this.defaultIcon;
            }
            this.setText(text);
            this.setIcon(icon);
            return rc;
        }
    }
}

