/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.window;

import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.plugin.window.WindowListPanel;
import com.spacekiller.util.swing.WindowManager;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class WindowListView
extends View {
    private WindowListPanel windowListPanel;
    private Workbench currentWorkbench;
    private static final Logger logger = Logger.getLogger(WindowListView.class.getName());

    protected Component createComponent() {
        return this.getWindowListPanel();
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected WindowListPanel createWindowListPanel() {
        WindowListPanel panel = new WindowListPanel();
        panel.setWindowListView(this);
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                super.componentShown(e);
                WindowListView.this.refresh();
            }
        });
        try {
            panel.setDefaultIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/spacekiller/infection/plugin/icons/window16.gif")));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        panel.setPreferredSize(new Dimension(200, 250));
        WindowManager winMan = InfectionPlatform.getInfectionPlatform().getWindowManager();
        if (winMan != null) {
            panel.setWindowManager(winMan);
        }
        return panel;
    }

    public WindowListPanel getWindowListPanel() {
        if (this.windowListPanel == null) {
            this.setWindowListPanel(this.createWindowListPanel());
        }
        return this.windowListPanel;
    }

    protected void setWindowListPanel(WindowListPanel windowListPanel) {
        this.windowListPanel = windowListPanel;
    }

    protected void parentChanged(View oldParent, View newParent) {
        super.parentChanged(oldParent, newParent);
        this.refresh();
    }

    protected Workbench getCurrentWorkbench() {
        return this.currentWorkbench;
    }

    protected void setCurrentWorkbench(Workbench currentWorkbench) {
        this.currentWorkbench = currentWorkbench;
    }

    public void refresh() {
        Workbench newWork;
        super.refresh();
        Perspective newPers = this.getPerspective();
        Workbench workbench = newWork = newPers == null ? null : newPers.getWorkbench();
        if (newWork != this.currentWorkbench) {
            WindowListPanel.WindowHandler winListener = this.getWindowListPanel().getWindowHandler();
            if (this.currentWorkbench != null) {
                this.currentWorkbench.removeWindowListener((WindowListener)winListener);
            }
            this.currentWorkbench = newWork;
            if (this.currentWorkbench != null) {
                this.currentWorkbench.addWindowListener((WindowListener)winListener);
            }
            logger.fine("workbench=" + newWork);
            this.getWindowListPanel().refresh();
        }
    }

    public synchronized void close() {
        super.close();
        if (this.windowListPanel != null) {
            this.windowListPanel.dispose();
            this.windowListPanel = null;
        }
    }
}

