/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.sf2player;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.midi.MidiPortType;
import com.waxmonster.sf2player.SoundFontPlayerDevice;
import com.waxmonster.sf2player.SoundFontPlayerDeviceInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import javax.swing.Icon;

public class SoundFontDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "SF2DeviceProvider";
    public static final String DEVICE_CATEGORY_NAME = "Audio Players";

    public SoundFontDeviceProvider() {
        super(PROVIDER_NAME);
        this.initSF2DeviceProvider();
    }

    protected void initSF2DeviceProvider() {
        String name = "SoundFont Player";
        String tooltip = "Sound-Font player";
        Icon sf2PlayerIcon = Tools.getIcon(SoundFontDeviceProvider.class, (String)"/com/waxmonster/sf2player/icons/spacekiller_sf2player_icon16.png");
        SoundFontPlayerDeviceInfo sf2Player = new SoundFontPlayerDeviceInfo(name, tooltip, sf2PlayerIcon);
        this.addDeviceInfo(sf2Player);
    }

    public void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        if (info == null) {
            return null;
        }
        String name = info.getDeviceName();
        Icon iconColor16 = info.getIcon(1);
        if (info instanceof SoundFontPlayerDeviceInfo) {
            return new SoundFontPlayerDevice(this, name, iconColor16);
        }
        return null;
    }

    public PortType getPortType(String typeName) {
        AudioPortType type = AudioPortType.getAudioPortType((String)typeName);
        if (type == null) {
            type = MidiPortType.getMidiPortType((String)typeName);
        }
        return type;
    }
}

