/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.sf2player;

import com.bene.media.sound.SoftSynthesizer;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SampleTypes;
import com.spacekiller.util.sound.SoundFormat;
import com.spacekiller.util.sound.SoundUtil;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.sf2player.InstrumentInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class SoundFontPlayer
implements AudioProcessor {
    private static final Logger logger = Logger.getLogger(SoundFontPlayer.class.getName());
    private final SampleBuffer dst;
    private final int nc;
    private final RawSampleBuffer rsb;
    private final int frameSize;
    private Synthesizer synth;
    private Receiver receiver;
    private AudioInputStream ais;

    public SoundFontPlayer(SampleBuffer dst) throws Exception {
        this.dst = dst;
        this.nc = dst.getChannels();
        float rate = dst.getFrameRate();
        int samples = dst.getSamples();
        SampleTypes.Int16LsbSampleType sampleType = SampleTypes.Int16Lsb;
        int channels = this.nc;
        this.frameSize = sampleType.getSampleSize() * channels;
        String formatName = sampleType.getName();
        SoundFormat soundFormat = new SoundFormat(formatName, channels, rate, (SampleType)sampleType);
        AudioFormat targetFormat = SoundUtil.createAudioFormat((SoundFormat)soundFormat);
        this.rsb = sampleType.createRawSampleBuffer(channels, rate, samples);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating SoftSynthesizer...");
        }
        SoftSynthesizer softSynth = new SoftSynthesizer();
        this.synth = softSynth;
        Instrument[] defaultInstr = this.synth.getLoadedInstruments();
        for (int i = 0; i < defaultInstr.length; ++i) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Unloading default instrument: " + defaultInstr[i]);
            }
            this.synth.unloadInstrument(defaultInstr[i]);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Opening synthesizer stream...");
        }
        HashMap info = new HashMap();
        this.ais = softSynth.openStream(targetFormat, info);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Synthesizer stream: " + this.ais);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Opening synthesizer receiver...");
        }
        this.receiver = this.synth.getReceiver();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Synthesizer receiver: " + this.receiver);
        }
    }

    public void process(long time, int frames) throws AudioException {
        int n = frames * this.nc;
        try {
            this.rsb.write(0, (InputStream)this.ais, frames * this.frameSize);
        }
        catch (IOException e) {
            this.rsb.clear(0, n);
            throw new AudioException((Throwable)e);
        }
        finally {
            this.dst.set(0, (SampleBuffer)this.rsb, 0, n);
        }
    }

    public void shutdown() throws AudioException {
        if (this.synth != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Closing synthesizer: " + this.synth);
            }
            this.synth.close();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Synthesizer closed: " + this.synth);
            }
            this.synth = null;
        }
    }

    protected Receiver getReceiver() {
        return this.receiver;
    }

    public synchronized boolean loadInstrument(InstrumentInfo info) {
        if (info == null) {
            return false;
        }
        Instrument instr = info.getInstrument();
        if (instr == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading instrument: " + instr);
        }
        if (!this.synth.loadInstrument(instr)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Failed to load instrument: " + instr);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Instrument loaded: " + instr + ", patch=" + instr.getPatch());
        }
        return true;
    }

    public synchronized boolean selectInstrument(InstrumentInfo info) throws InvalidMidiDataException {
        if (info == null) {
            return false;
        }
        Instrument instr = info.getInstrument();
        if (instr == null) {
            return false;
        }
        Patch patch = instr.getPatch();
        if (patch == null) {
            return false;
        }
        int program = patch.getProgram();
        int channel = 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Sending MIDI program change: channel=" + channel + ", program=" + program);
        }
        ShortMessage sm = new ShortMessage();
        sm.setMessage(0xC0 | channel, program, 0);
        this.receiver.send(sm, -1L);
        return true;
    }

    public synchronized boolean unloadInstrument(InstrumentInfo info) {
        if (info == null) {
            return false;
        }
        Instrument instr = info.getInstrument();
        if (instr == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unloading instrument: " + instr);
        }
        this.synth.unloadInstrument(instr);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Instrument unloaded: " + instr);
        }
        return true;
    }
}

