/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.sf2player;

import com.bene.media.sound.SF2Soundbank;
import com.spacekiller.util.FileLocator;
import com.spacekiller.util.Platform;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.sf2player.InstrumentInfo;
import com.waxmonster.sf2player.SoundFontPlayer;
import com.waxmonster.sf2player.SoundFontPlayerPanel;
import com.waxmonster.sf2player.SoundbankInfo;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SysexMessage;
import javax.swing.Icon;

public class SoundFontPlayerDevice
extends Device {
    private static final String PROPERTY_SOUNDBANK_PREFIX = "soundbank.";
    private static final String PROPERTY_SOUNDBANK_PATH_SUFFIX = ".path";
    private static final String PROPERTY_INSTRUMENT_PREFIX = "instrument.";
    private static final String PROPERTY_INSTRUMENT_PATH_SUFFIX = ".path";
    private static final String PROPERTY_INSTRUMENT_NAME_SUFFIX = ".name";
    private static final String PROPERTY_INSTRUMENT_INDEX_SUFFIX = ".index";
    private static final String PROPERTY_SELECTED_INSTRUMENT_INDEX = "selectedInstrumentIndex";
    private static final String PROPERTY_AUTOLOAD_INSTRUMENTS = "autoLoadInstruments";
    private static final int MAX_BANK_COUNT = 65535;
    private static final int MAX_INSTRUMENT_COUNT = 65535;
    private static final Logger logger = Logger.getLogger(SoundFontPlayerDevice.class.getName());
    private final MidiSupportImpl midiSupport = new MidiSupportImpl();
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private MidiInputPort midiInputPort;
    private AudioOutputPort outputPort;
    private AudioOutputPort oldOutputPort;
    private SoundFontPlayer soundFontPlayer;
    private SoundFontPlayerPanel soundFontPlayerPanel;
    private List<SoundbankInfo> soundbankList;
    private List<InstrumentInfo> instrumentList;
    private InstrumentInfo selectedInstrumentInfo;
    private boolean autoLoadSelectedInstruments;

    public SoundFontPlayerDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.soundbankList = new ArrayList<SoundbankInfo>();
        this.instrumentList = new ArrayList<InstrumentInfo>();
        this.midiInputPort = new MidiInputPort("MIDI-In", MidiInputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.addPort((Port)this.midiInputPort);
        this.refresh();
    }

    protected synchronized void refresh() {
        try {
            int channels = 2;
            if (this.outputPort != null) {
                if (this.outputPort.getChannels() == channels) {
                    return;
                }
                if (this.oldOutputPort == null || !this.oldOutputPort.isConnected()) {
                    this.oldOutputPort = this.outputPort;
                }
                this.removePort((Port)this.outputPort);
                this.outputPort = null;
            }
            if (channels > 0) {
                AudioOutputPortType portType = null;
                switch (channels) {
                    case 1: {
                        portType = AudioOutputPortType.MONO;
                        break;
                    }
                    case 2: {
                        portType = AudioOutputPortType.STEREO;
                    }
                }
                if (portType != null) {
                    if (this.oldOutputPort != null && this.oldOutputPort.getType() == portType) {
                        this.outputPort = this.oldOutputPort;
                    } else {
                        String portName = portType.getName();
                        this.outputPort = new AudioOutputPort(portName, portType, (AudioSupport)this.audioSupport);
                    }
                    this.addPort((Port)this.outputPort);
                }
            }
        }
        catch (StudioException e) {
            throw new RuntimeException(e);
        }
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
    }

    public synchronized Component getCustomizer() {
        if (this.soundFontPlayerPanel == null) {
            this.soundFontPlayerPanel = new SoundFontPlayerPanel();
            this.soundFontPlayerPanel.setOpaque(false);
            this.soundFontPlayerPanel.setDevice(this);
        }
        return this.soundFontPlayerPanel;
    }

    public synchronized int getSoundbankInfoCount() {
        return this.soundbankList.size();
    }

    public synchronized SoundbankInfo getSoundbankInfoAt(int i) {
        return this.soundbankList.get(i);
    }

    public synchronized void insertSoundbankInfoAt(SoundbankInfo info, int i) {
        if (info == null) {
            return;
        }
        this.soundbankList.add(i, info);
    }

    public synchronized void addSoundbankInfo(SoundbankInfo info) {
        if (info == null) {
            return;
        }
        this.soundbankList.add(info);
    }

    public synchronized void removeSoundbankInfo(SoundbankInfo info) {
        this.soundbankList.remove(info);
    }

    public synchronized void removeSoundbankInfoAt(int i) {
        this.soundbankList.remove(i);
    }

    public Soundbank openSoundbank(File file) throws Exception {
        return new SF2Soundbank(file);
    }

    public boolean loadSoundBank(SoundbankInfo bankInfo) throws Exception {
        Soundbank bank;
        File file;
        String path = bankInfo.getPath();
        if (path == null) {
            return false;
        }
        boolean fine = logger.isLoggable(Level.FINE);
        boolean finer = logger.isLoggable(Level.FINER);
        if (finer) {
            logger.finer("About to load soundbank: " + path);
        }
        if (!(file = new File(path)).exists()) {
            file = null;
            FileLocator fileLocator = Platform.getInstance().getFileLocator();
            if (fileLocator != null && (file = fileLocator.locateFile(path)) != null) {
                bankInfo.setPath(file.getPath());
            }
            if (file == null) {
                throw new FileNotFoundException(path);
            }
        }
        if (fine) {
            logger.fine("Loading soundbank: " + path);
        }
        if ((bank = this.openSoundbank(file)) == null) {
            if (fine) {
                logger.fine("Failed to load soundbank from file: " + file);
            }
            return false;
        }
        if (fine) {
            logger.fine("Soundbank loaded: " + bank);
        }
        bankInfo.setSoundbank(bank);
        Instrument[] instr = bank.getInstruments();
        int num = instr.length;
        InstrumentInfo[] instrumentInfos = new InstrumentInfo[num];
        for (int i = 0; i < num; ++i) {
            if (finer) {
                logger.finer("Instrument #" + i + ": " + instr[i]);
            }
            instrumentInfos[i] = new InstrumentInfo(bankInfo, instr[i]);
        }
        bankInfo.setInstrumentInfo(instrumentInfos);
        return true;
    }

    public synchronized int getInstrumentInfoCount() {
        return this.instrumentList.size();
    }

    public synchronized InstrumentInfo getInstrumentInfoAt(int i) {
        return this.instrumentList.get(i);
    }

    public synchronized void insertInstrumentInfoAt(InstrumentInfo info, int i) {
        if (info == null) {
            return;
        }
        this.instrumentList.add(i, info);
        SoundFontPlayer player = this.soundFontPlayer;
        if (player != null) {
            player.loadInstrument(info);
        }
    }

    public synchronized boolean addInstrumentInfo(InstrumentInfo info) {
        if (this.instrumentList.contains(info)) {
            return false;
        }
        this.insertInstrumentInfoAt(info, this.instrumentList.size());
        return true;
    }

    public synchronized boolean selectInstrumentInfo(InstrumentInfo info) {
        if (info == null) {
            return false;
        }
        this.selectedInstrumentInfo = info;
        SoundFontPlayer player = this.soundFontPlayer;
        if (player != null) {
            try {
                return player.selectInstrument(info);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return true;
    }

    public synchronized void removeInstrumentInfo(InstrumentInfo info) {
        SoundFontPlayer player;
        if (this.instrumentList.remove(info) && (player = this.soundFontPlayer) != null) {
            player.unloadInstrument(info);
        }
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        int index = 0;
        for (SoundbankInfo info : this.soundbankList) {
            String path = info.getPath();
            if (path != null) {
                props.put(PROPERTY_SOUNDBANK_PREFIX + index + ".path", path);
            }
            ++index;
        }
        int selectedInstrIndex = -1;
        index = 0;
        for (InstrumentInfo info : this.instrumentList) {
            Instrument instr = info.getInstrument();
            if (instr != null) {
                String path;
                String instrName = instr.getName();
                SoundbankInfo bankInfo = info.getSoundbankInfo();
                if (bankInfo != null && (path = bankInfo.getPath()) != null) {
                    props.put(PROPERTY_INSTRUMENT_PREFIX + index + ".path", path);
                    if (instrName != null) {
                        props.put(PROPERTY_INSTRUMENT_PREFIX + index + PROPERTY_INSTRUMENT_NAME_SUFFIX, instrName);
                    }
                    int instrIndex = -1;
                    InstrumentInfo[] bankInstr = bankInfo.getInstrumentInfo();
                    if (bankInstr != null) {
                        for (int k = 0; k < bankInstr.length; ++k) {
                            if (info != bankInstr[k]) continue;
                            instrIndex = k;
                            break;
                        }
                    }
                    if (instrIndex >= 0) {
                        props.put(PROPERTY_INSTRUMENT_PREFIX + index + PROPERTY_INSTRUMENT_INDEX_SUFFIX, String.valueOf(instrIndex));
                    }
                    if (info == this.selectedInstrumentInfo) {
                        selectedInstrIndex = index;
                    }
                }
            }
            ++index;
        }
        if (selectedInstrIndex >= 0) {
            props.put(PROPERTY_SELECTED_INSTRUMENT_INDEX, String.valueOf(selectedInstrIndex));
        }
        boolean autoLoad = this.isAutoLoadSelectedInstruments();
        props.put(PROPERTY_AUTOLOAD_INSTRUMENTS, String.valueOf(autoLoad));
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        InstrumentInfo instrInfo;
        super.setProperties(newProperties);
        if (newProperties == null) {
            return;
        }
        boolean autoLoad = false;
        int selectedInstrIndex = -1;
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (PROPERTY_AUTOLOAD_INSTRUMENTS.equals(key)) {
                autoLoad = Boolean.parseBoolean(value);
                continue;
            }
            if (!PROPERTY_SELECTED_INSTRUMENT_INDEX.equals(key)) continue;
            selectedInstrIndex = this.parseIntProperty(key, value);
        }
        ArrayList<SoundbankInfo> bankInfos = new ArrayList<SoundbankInfo>();
        HashMap<String, SoundbankInfo> bankInfoMap = new HashMap<String, SoundbankInfo>();
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(PROPERTY_SOUNDBANK_PREFIX) || !key.endsWith(".path")) continue;
            String path = value;
            SoundbankInfo bankInfo = new SoundbankInfo(path);
            int bankIndex = -1;
            String sIndex = key.substring(PROPERTY_SOUNDBANK_PREFIX.length(), key.length() - ".path".length());
            try {
                bankIndex = Integer.parseInt(sIndex.trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            int size = bankInfos.size();
            if (bankIndex < 0) {
                bankIndex = size;
            }
            if (bankIndex >= size) {
                if (bankIndex > 65535) {
                    logger.warning("Invalid bank index: " + bankIndex);
                    continue;
                }
                while (bankIndex >= size) {
                    bankInfos.add(null);
                    ++size;
                }
            }
            bankInfos.set(bankIndex, bankInfo);
            bankInfoMap.put(path, bankInfo);
        }
        for (SoundbankInfo bankInfo : bankInfos) {
            if (bankInfo == null) continue;
            this.addSoundbankInfo(bankInfo);
        }
        ArrayList<InstrumentInfo> instrInfos = new ArrayList<InstrumentInfo>();
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            InstrumentInfo[] bankInstrInfos;
            SoundbankInfo bankInfo;
            int bankInstrIndex;
            String instrName;
            String keyPrefix;
            block35: {
                Soundbank bank;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.startsWith(PROPERTY_INSTRUMENT_PREFIX) || !key.endsWith(".path")) continue;
                String path = value;
                keyPrefix = key.substring(0, key.length() - ".path".length());
                instrName = newProperties.getProperty(keyPrefix + PROPERTY_INSTRUMENT_NAME_SUFFIX);
                String sBankInstrIndex = newProperties.getProperty(keyPrefix + PROPERTY_INSTRUMENT_INDEX_SUFFIX);
                bankInstrIndex = -1;
                if (sBankInstrIndex != null && sBankInstrIndex.trim().length() > 0) {
                    try {
                        bankInstrIndex = Integer.parseInt(sBankInstrIndex.trim());
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                if ((bankInfo = (SoundbankInfo)bankInfoMap.get(path)) == null) {
                    bankInfo = new SoundbankInfo(path);
                    this.addSoundbankInfo(bankInfo);
                }
                if ((bank = bankInfo.getSoundbank()) == null) {
                    try {
                        if (!this.loadSoundBank(bankInfo)) {
                        }
                        break block35;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    continue;
                }
            }
            if ((bankInstrInfos = bankInfo.getInstrumentInfo()) == null) continue;
            InstrumentInfo instrInfo2 = null;
            if (bankInstrIndex >= 0 && bankInstrIndex < bankInstrInfos.length && (instrInfo2 = bankInstrInfos[bankInstrIndex]) != null) {
                Instrument instr = instrInfo2.getInstrument();
                if (instr == null) {
                    instrInfo2 = null;
                } else if (instrName != null && !instrName.equals(instr.getName())) {
                    instrInfo2 = null;
                }
            }
            if (instrInfo2 == null && instrName != null) {
                for (int i = 0; i < bankInstrInfos.length; ++i) {
                    Instrument instr;
                    InstrumentInfo x = bankInstrInfos[i];
                    if (x == null || (instr = x.getInstrument()) == null || !instrName.equals(instr.getName())) continue;
                    instrInfo2 = x;
                    break;
                }
            }
            if (instrInfo2 == null) continue;
            int insertIndex = -1;
            String sInsertIndex = keyPrefix.substring(PROPERTY_INSTRUMENT_PREFIX.length());
            try {
                insertIndex = Integer.parseInt(sInsertIndex.trim());
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            int size = instrInfos.size();
            if (insertIndex < 0) {
                insertIndex = size;
            }
            if (insertIndex >= size) {
                if (insertIndex > 65535) {
                    logger.warning("Invalid instrument index: " + insertIndex);
                    continue;
                }
                while (insertIndex >= size) {
                    instrInfos.add(null);
                    ++size;
                }
            }
            instrInfos.set(insertIndex, instrInfo2);
        }
        for (InstrumentInfo instrInfo3 : instrInfos) {
            if (instrInfo3 == null) continue;
            this.addInstrumentInfo(instrInfo3);
        }
        if (selectedInstrIndex >= 0 && selectedInstrIndex < instrInfos.size() && (instrInfo = (InstrumentInfo)instrInfos.get(selectedInstrIndex)) != null) {
            this.selectInstrumentInfo(instrInfo);
        }
        if (autoLoad) {
            this.setAutoLoadSelectedInstruments(true);
        }
    }

    protected void applyProperty(String key, String value) {
    }

    public boolean isAutoLoadSelectedInstruments() {
        return this.autoLoadSelectedInstruments;
    }

    public void setAutoLoadSelectedInstruments(boolean autoLoadSelectedInstruments) {
        this.autoLoadSelectedInstruments = autoLoadSelectedInstruments;
    }

    protected class MidiProc
    implements MidiProcessor {
        protected MidiProc() {
        }

        public void process(long time, int status) {
        }

        public void process(long time, int status, int data1) {
        }

        public void process(long time, int status, int data1, int data2) {
            SoundFontPlayer sfp = SoundFontPlayerDevice.this.soundFontPlayer;
            if (sfp == null) {
                return;
            }
            Receiver rec = sfp.getReceiver();
            if (rec == null) {
                return;
            }
            try {
                ShortMessage msg = new ShortMessage();
                msg.setMessage(status, data1, data2);
                rec.send(msg, -1L);
            }
            catch (InvalidMidiDataException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        public void process(long time, ShortMessage mc) {
            SoundFontPlayer sfp = SoundFontPlayerDevice.this.soundFontPlayer;
            if (sfp == null) {
                return;
            }
            Receiver rec = sfp.getReceiver();
            if (rec == null) {
                return;
            }
            rec.send(mc, -1L);
        }

        public void process(long time, SysexMessage sm) {
        }

        public void shutdown() {
        }
    }

    protected class MidiSyncGroupImpl
    extends MidiSyncGroup {
        public MidiSyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
        }

        public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            return new MidiProc();
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroup midiSyncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (this.midiSyncGroup != null) {
                this.midiSyncGroup = null;
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.midiSyncGroup == null) {
                this.midiSyncGroup = new MidiSyncGroupImpl(SoundFontPlayerDevice.this.getName(), new MidiInputPort[]{SoundFontPlayerDevice.this.midiInputPort}, new MidiOutputPort[0]);
            }
            return this.midiSyncGroup;
        }
    }

    protected class SyncGroupImpl
    extends AudioSyncGroup {
        public SyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            if (out.length != 1) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != 1");
            }
            SampleBuffer dst = out[0];
            try {
                SoundFontPlayerDevice.this.soundFontPlayer = new SoundFontPlayer(dst);
                for (InstrumentInfo info : SoundFontPlayerDevice.this.instrumentList) {
                    SoundFontPlayerDevice.this.soundFontPlayer.loadInstrument(info);
                }
                return SoundFontPlayerDevice.this.soundFontPlayer;
            }
            catch (Exception e) {
                throw new AudioException((Throwable)e);
            }
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new SyncGroupImpl(SoundFontPlayerDevice.this.getName(), new AudioInputPort[0], new AudioOutputPort[]{SoundFontPlayerDevice.this.outputPort});
            }
            return this.syncGroup;
        }
    }
}

