/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.sf2player;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.FileContext;
import com.spacekiller.util.FileLink;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Sys;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.AnchorlessBeanContext;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.DefaultDragSourceHandler;
import com.spacekiller.util.beans.TypeContext;
import com.waxmonster.sf2player.InstrumentInfo;
import com.waxmonster.sf2player.SoundFontPlayerDevice;
import com.waxmonster.sf2player.SoundbankInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.beancontext.BeanContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.Soundbank;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class SoundFontPlayerPanel
extends JPanel {
    private static final long serialVersionUID = -1616293771984111484L;
    private static final Logger logger = Logger.getLogger(SoundFontPlayerPanel.class.getName());
    private static final String SF2_FILE_EXTENSION = ".sf2";
    private SoundFontPlayerDevice device;
    private boolean refreshing = false;
    private File currentDir;
    private BeansToolkit beansToolkit;
    private BeanDropSupport beanDropSupport;
    private DropTargetHandler dropTargetHandler = new DropTargetHandler();
    private DropBeanContext dropBeanContext;
    private DragGestureHandler dragGestureHandler = new DragGestureHandler();
    private DefaultDragSourceHandler dragSourceHandler = new DefaultDragSourceHandler();
    private SoundbankInfo editorSoundbankInfo;
    private JList listBanks;
    private JList listInstruments;
    private JList listLoadedInstruments;
    private JCheckBox chckbxAutoload;
    private JButton buttonLoadInstruments;
    private JButton btnOpenSoundBank;
    private JTextField textFieldBank;
    private JTextField textFieldComments;
    private JComboBox comboBoxCategory;
    private JTextField textFieldPath;
    private JTextField textFieldBankDescr;
    private JTextField textFieldBankVendor;
    private JTextField textFieldBankVersion;
    private JComboBox comboBoxRating;

    public SoundFontPlayerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{50, 50, 0};
        gridBagLayout.rowHeights = new int[]{116, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelBanks = new JPanel();
        panelBanks.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Soundbanks", 4, 2, null, null));
        panelBanks.setOpaque(false);
        GridBagConstraints gbc_panelBanks = new GridBagConstraints();
        gbc_panelBanks.weighty = 1.0;
        gbc_panelBanks.weightx = 1.0;
        gbc_panelBanks.insets = new Insets(5, 5, 5, 5);
        gbc_panelBanks.fill = 1;
        gbc_panelBanks.gridx = 0;
        gbc_panelBanks.gridy = 0;
        this.add((Component)panelBanks, gbc_panelBanks);
        GridBagLayout gbl_panelBanks = new GridBagLayout();
        gbl_panelBanks.columnWidths = new int[]{50, 0};
        gbl_panelBanks.rowHeights = new int[]{204, 0, 0};
        gbl_panelBanks.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelBanks.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelBanks.setLayout(gbl_panelBanks);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setOpaque(false);
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panelBanks.add((Component)scrollPane, gbc_scrollPane);
        this.listBanks = new JList();
        this.listBanks.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SoundFontPlayerPanel.this.refreshSoundbankDetails();
                SoundFontPlayerPanel.this.refreshAvailableInstruments();
                int num = SoundFontPlayerPanel.this.getListInstruments().getModel().getSize();
                if (num > 0) {
                    SoundFontPlayerPanel.this.getListInstruments().setSelectedIndex(0);
                }
            }
        });
        this.listBanks.setOpaque(false);
        scrollPane.setViewportView(this.listBanks);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(0, 4, 4, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        panelBanks.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.btnOpenSoundBank = new JButton("Open...");
        this.btnOpenSoundBank.setMargin(new Insets(2, 4, 2, 4));
        this.btnOpenSoundBank.setToolTipText("Open soundbank file(s)...");
        this.btnOpenSoundBank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SoundFontPlayerPanel.this.actionOpenSoundBankDialog();
            }
        });
        GridBagConstraints gbc_btnOpenSoundBank = new GridBagConstraints();
        gbc_btnOpenSoundBank.gridx = 0;
        gbc_btnOpenSoundBank.gridy = 0;
        panel_1.add((Component)this.btnOpenSoundBank, gbc_btnOpenSoundBank);
        JPanel panelDetails = new JPanel();
        panelDetails.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Soundbank Details", 4, 2, null, null));
        panelDetails.setOpaque(false);
        GridBagConstraints gbc_panelDetails = new GridBagConstraints();
        gbc_panelDetails.insets = new Insets(5, 2, 5, 5);
        gbc_panelDetails.fill = 1;
        gbc_panelDetails.gridx = 1;
        gbc_panelDetails.gridy = 0;
        this.add((Component)panelDetails, gbc_panelDetails);
        GridBagLayout gbl_panelDetails = new GridBagLayout();
        gbl_panelDetails.columnWidths = new int[]{0, 0, 0};
        gbl_panelDetails.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelDetails.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panelDetails.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelDetails.setLayout(gbl_panelDetails);
        JLabel lblPath = new JLabel("Path:");
        GridBagConstraints gbc_lblPath = new GridBagConstraints();
        gbc_lblPath.anchor = 17;
        gbc_lblPath.insets = new Insets(5, 5, 5, 5);
        gbc_lblPath.gridx = 0;
        gbc_lblPath.gridy = 0;
        panelDetails.add((Component)lblPath, gbc_lblPath);
        this.textFieldPath = new JTextField();
        this.textFieldPath.setOpaque(false);
        this.textFieldPath.setEditable(false);
        GridBagConstraints gbc_textFieldPath = new GridBagConstraints();
        gbc_textFieldPath.insets = new Insets(5, 0, 5, 0);
        gbc_textFieldPath.fill = 2;
        gbc_textFieldPath.gridx = 1;
        gbc_textFieldPath.gridy = 0;
        panelDetails.add((Component)this.textFieldPath, gbc_textFieldPath);
        this.textFieldPath.setColumns(10);
        JLabel lblSoundbankName = new JLabel("Name:");
        GridBagConstraints gbc_lblSoundbankName = new GridBagConstraints();
        gbc_lblSoundbankName.anchor = 17;
        gbc_lblSoundbankName.insets = new Insets(0, 5, 5, 5);
        gbc_lblSoundbankName.gridx = 0;
        gbc_lblSoundbankName.gridy = 1;
        panelDetails.add((Component)lblSoundbankName, gbc_lblSoundbankName);
        this.textFieldBank = new JTextField();
        this.textFieldBank.setOpaque(false);
        this.textFieldBank.setEditable(false);
        GridBagConstraints gbc_textFieldBank = new GridBagConstraints();
        gbc_textFieldBank.weightx = 1.0;
        gbc_textFieldBank.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldBank.fill = 2;
        gbc_textFieldBank.gridx = 1;
        gbc_textFieldBank.gridy = 1;
        panelDetails.add((Component)this.textFieldBank, gbc_textFieldBank);
        this.textFieldBank.setColumns(10);
        JLabel lblDescription = new JLabel("Description:");
        GridBagConstraints gbc_lblDescription = new GridBagConstraints();
        gbc_lblDescription.anchor = 17;
        gbc_lblDescription.insets = new Insets(0, 5, 5, 5);
        gbc_lblDescription.gridx = 0;
        gbc_lblDescription.gridy = 2;
        panelDetails.add((Component)lblDescription, gbc_lblDescription);
        this.textFieldBankDescr = new JTextField();
        this.textFieldBankDescr.setEditable(false);
        this.textFieldBankDescr.setOpaque(false);
        GridBagConstraints gbc_textFieldBankDescr = new GridBagConstraints();
        gbc_textFieldBankDescr.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldBankDescr.fill = 2;
        gbc_textFieldBankDescr.gridx = 1;
        gbc_textFieldBankDescr.gridy = 2;
        panelDetails.add((Component)this.textFieldBankDescr, gbc_textFieldBankDescr);
        this.textFieldBankDescr.setColumns(10);
        JLabel lblVendor = new JLabel("Vendor:");
        GridBagConstraints gbc_lblVendor = new GridBagConstraints();
        gbc_lblVendor.anchor = 17;
        gbc_lblVendor.insets = new Insets(0, 5, 5, 5);
        gbc_lblVendor.gridx = 0;
        gbc_lblVendor.gridy = 3;
        panelDetails.add((Component)lblVendor, gbc_lblVendor);
        this.textFieldBankVendor = new JTextField();
        this.textFieldBankVendor.setEditable(false);
        this.textFieldBankVendor.setOpaque(false);
        GridBagConstraints gbc_textFieldBankVendor = new GridBagConstraints();
        gbc_textFieldBankVendor.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldBankVendor.fill = 2;
        gbc_textFieldBankVendor.gridx = 1;
        gbc_textFieldBankVendor.gridy = 3;
        panelDetails.add((Component)this.textFieldBankVendor, gbc_textFieldBankVendor);
        this.textFieldBankVendor.setColumns(10);
        JLabel lblVersion = new JLabel("Version:");
        GridBagConstraints gbc_lblVersion = new GridBagConstraints();
        gbc_lblVersion.anchor = 17;
        gbc_lblVersion.insets = new Insets(0, 5, 5, 5);
        gbc_lblVersion.gridx = 0;
        gbc_lblVersion.gridy = 4;
        panelDetails.add((Component)lblVersion, gbc_lblVersion);
        this.textFieldBankVersion = new JTextField();
        this.textFieldBankVersion.setEditable(false);
        this.textFieldBankVersion.setOpaque(false);
        GridBagConstraints gbc_textFieldBankVersion = new GridBagConstraints();
        gbc_textFieldBankVersion.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldBankVersion.fill = 2;
        gbc_textFieldBankVersion.gridx = 1;
        gbc_textFieldBankVersion.gridy = 4;
        panelDetails.add((Component)this.textFieldBankVersion, gbc_textFieldBankVersion);
        this.textFieldBankVersion.setColumns(10);
        JLabel lblRating = new JLabel("Rating:");
        GridBagConstraints gbc_lblRating = new GridBagConstraints();
        gbc_lblRating.anchor = 17;
        gbc_lblRating.insets = new Insets(0, 5, 5, 5);
        gbc_lblRating.gridx = 0;
        gbc_lblRating.gridy = 5;
        panelDetails.add((Component)lblRating, gbc_lblRating);
        this.comboBoxRating = new JComboBox();
        this.comboBoxRating.setOpaque(false);
        GridBagConstraints gbc_comboBoxRating = new GridBagConstraints();
        gbc_comboBoxRating.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxRating.fill = 2;
        gbc_comboBoxRating.gridx = 1;
        gbc_comboBoxRating.gridy = 5;
        panelDetails.add((Component)this.comboBoxRating, gbc_comboBoxRating);
        JLabel lblCategory = new JLabel("Category:");
        GridBagConstraints gbc_lblCategory = new GridBagConstraints();
        gbc_lblCategory.insets = new Insets(0, 5, 5, 5);
        gbc_lblCategory.anchor = 17;
        gbc_lblCategory.gridx = 0;
        gbc_lblCategory.gridy = 6;
        panelDetails.add((Component)lblCategory, gbc_lblCategory);
        this.comboBoxCategory = new JComboBox();
        this.comboBoxCategory.setOpaque(false);
        this.comboBoxCategory.setEditable(true);
        GridBagConstraints gbc_comboBoxCategory = new GridBagConstraints();
        gbc_comboBoxCategory.insets = new Insets(0, 0, 5, 0);
        gbc_comboBoxCategory.fill = 2;
        gbc_comboBoxCategory.gridx = 1;
        gbc_comboBoxCategory.gridy = 6;
        panelDetails.add((Component)this.comboBoxCategory, gbc_comboBoxCategory);
        JLabel lblComments = new JLabel("Comment:");
        GridBagConstraints gbc_lblComments = new GridBagConstraints();
        gbc_lblComments.anchor = 17;
        gbc_lblComments.insets = new Insets(0, 5, 0, 5);
        gbc_lblComments.gridx = 0;
        gbc_lblComments.gridy = 7;
        panelDetails.add((Component)lblComments, gbc_lblComments);
        this.textFieldComments = new JTextField();
        this.textFieldComments.setOpaque(false);
        GridBagConstraints gbc_textFieldComments = new GridBagConstraints();
        gbc_textFieldComments.fill = 2;
        gbc_textFieldComments.gridx = 1;
        gbc_textFieldComments.gridy = 7;
        panelDetails.add((Component)this.textFieldComments, gbc_textFieldComments);
        this.textFieldComments.setColumns(10);
        JPanel panelInstruments = new JPanel();
        panelInstruments.setOpaque(false);
        panelInstruments.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Instruments", 4, 2, null, null));
        GridBagConstraints gbc_panelInstruments = new GridBagConstraints();
        gbc_panelInstruments.weighty = 1.0;
        gbc_panelInstruments.weightx = 1.0;
        gbc_panelInstruments.fill = 1;
        gbc_panelInstruments.insets = new Insets(0, 5, 5, 5);
        gbc_panelInstruments.gridx = 0;
        gbc_panelInstruments.gridy = 1;
        this.add((Component)panelInstruments, gbc_panelInstruments);
        GridBagLayout gbl_panelInstruments = new GridBagLayout();
        gbl_panelInstruments.columnWidths = new int[]{50, 0};
        gbl_panelInstruments.rowHeights = new int[]{50, 0, 0};
        gbl_panelInstruments.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelInstruments.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        panelInstruments.setLayout(gbl_panelInstruments);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setOpaque(false);
        GridBagConstraints gbc_scrollPane_1 = new GridBagConstraints();
        gbc_scrollPane_1.fill = 1;
        gbc_scrollPane_1.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane_1.gridx = 0;
        gbc_scrollPane_1.gridy = 0;
        panelInstruments.add((Component)scrollPane_1, gbc_scrollPane_1);
        this.listInstruments = new JList();
        this.listInstruments.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SoundFontPlayerPanel.this.chckbxAutoload.isSelected()) {
                    SoundFontPlayerPanel.this.actionAutoLoadSelectedInstruments();
                }
            }
        });
        this.listInstruments.setOpaque(false);
        scrollPane_1.setViewportView(this.listInstruments);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 4, 4, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 1;
        panelInstruments.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.buttonLoadInstruments = new JButton("Load >");
        this.buttonLoadInstruments.setMargin(new Insets(2, 4, 2, 4));
        this.buttonLoadInstruments.setToolTipText("Load selected instrument(s)");
        this.buttonLoadInstruments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SoundFontPlayerPanel.this.actionLoadSelectedInstruments();
            }
        });
        this.chckbxAutoload = new JCheckBox("Auto-Load");
        this.chckbxAutoload.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                SoundFontPlayerDevice dev = SoundFontPlayerPanel.this.device;
                if (dev != null) {
                    dev.setAutoLoadSelectedInstruments(SoundFontPlayerPanel.this.chckbxAutoload.isSelected());
                }
                if (SoundFontPlayerPanel.this.chckbxAutoload.isSelected()) {
                    SoundFontPlayerPanel.this.buttonLoadInstruments.setEnabled(false);
                    if (!SoundFontPlayerPanel.this.refreshing) {
                        SoundFontPlayerPanel.this.actionAutoLoadSelectedInstruments();
                    }
                } else {
                    SoundFontPlayerPanel.this.buttonLoadInstruments.setEnabled(true);
                }
            }
        });
        this.chckbxAutoload.setToolTipText("Load selected instrument automatically ?");
        GridBagConstraints gbc_chckbxAutoload = new GridBagConstraints();
        gbc_chckbxAutoload.insets = new Insets(0, 0, 0, 5);
        gbc_chckbxAutoload.gridx = 0;
        gbc_chckbxAutoload.gridy = 0;
        panel.add((Component)this.chckbxAutoload, gbc_chckbxAutoload);
        GridBagConstraints gbc_buttonLoadInstruments = new GridBagConstraints();
        gbc_buttonLoadInstruments.anchor = 13;
        gbc_buttonLoadInstruments.weightx = 1.0;
        gbc_buttonLoadInstruments.gridx = 1;
        gbc_buttonLoadInstruments.gridy = 0;
        panel.add((Component)this.buttonLoadInstruments, gbc_buttonLoadInstruments);
        JPanel panelLoaded = new JPanel();
        panelLoaded.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Loaded Instruments", 4, 2, null, null));
        panelLoaded.setOpaque(false);
        GridBagConstraints gbc_panelLoaded = new GridBagConstraints();
        gbc_panelLoaded.insets = new Insets(0, 2, 5, 5);
        gbc_panelLoaded.fill = 1;
        gbc_panelLoaded.gridx = 1;
        gbc_panelLoaded.gridy = 1;
        this.add((Component)panelLoaded, gbc_panelLoaded);
        GridBagLayout gbl_panelLoaded = new GridBagLayout();
        gbl_panelLoaded.columnWidths = new int[]{0, 0};
        gbl_panelLoaded.rowHeights = new int[]{0, 0};
        gbl_panelLoaded.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panelLoaded.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panelLoaded.setLayout(gbl_panelLoaded);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setOpaque(false);
        GridBagConstraints gbc_scrollPane_2 = new GridBagConstraints();
        gbc_scrollPane_2.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane_2.fill = 1;
        gbc_scrollPane_2.gridx = 0;
        gbc_scrollPane_2.gridy = 0;
        panelLoaded.add((Component)scrollPane_2, gbc_scrollPane_2);
        this.listLoadedInstruments = new JList();
        this.listLoadedInstruments.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
            }
        });
        this.listLoadedInstruments.setOpaque(false);
        scrollPane_2.setViewportView(this.listLoadedInstruments);
        this.initSoundFontPlayerPanel();
    }

    protected void initSoundFontPlayerPanel() {
        JList bankList = this.getListBanks();
        this.getBeanDropSupport();
        this.dropBeanContext = new DropBeanContext();
        HashSet<Class<FileContext>> supportedTypes = new HashSet<Class<FileContext>>();
        supportedTypes.add(File.class);
        supportedTypes.add(FileLink.class);
        supportedTypes.add(FileContext.class);
        this.dropBeanContext.setSupportedTypes(supportedTypes);
        DropTarget dt = new DropTarget(bankList, this.dropTargetHandler);
        bankList.setDropTarget(dt);
        DragSource ds = new DragSource();
        ds.addDragSourceListener((DragSourceListener)this.dragSourceHandler);
        int actions = 3;
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(bankList, actions, this.dragGestureHandler);
        dgr.getComponent();
    }

    public SoundFontPlayerDevice getDevice() {
        return this.device;
    }

    public void setDevice(SoundFontPlayerDevice device) {
        this.device = device;
        this.refresh();
    }

    protected void actionOpenSoundBankDialog() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        if (this.currentDir != null) {
            chooser.setCurrentDirectory(this.currentDir);
        }
        chooser.setFileFilter(new SoundFontFileFilter());
        int rc = chooser.showOpenDialog(this);
        if (rc != 0) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        if (files.length < 1) {
            return;
        }
        this.currentDir = chooser.getCurrentDirectory();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            this.dropFile(file);
        }
        this.refresh();
    }

    protected void scanFilesRecursive(File dir, Set<File> done, List<File> dest) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!done.add(f)) continue;
            if (f.isFile()) {
                dest.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.scanFilesRecursive(f, done, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.refreshing = true;
            SoundFontPlayerDevice dev = this.device;
            boolean autoLoad = this.getChckbxAutoload().isSelected();
            DefaultListModel<SoundbankInfo> bankListModel = new DefaultListModel<SoundbankInfo>();
            if (dev != null) {
                autoLoad = dev.isAutoLoadSelectedInstruments();
                int n = dev.getSoundbankInfoCount();
                for (int i = 0; i < n; ++i) {
                    SoundbankInfo info = dev.getSoundbankInfoAt(i);
                    bankListModel.addElement(info);
                }
            }
            this.getListBanks().setModel(bankListModel);
            if (this.getChckbxAutoload().isSelected() != autoLoad) {
                this.getChckbxAutoload().setSelected(autoLoad);
            }
        }
        finally {
            this.refreshing = false;
        }
        this.refreshSoundbankDetails();
        this.refreshAvailableInstruments();
        this.refreshLoadedInstruments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshAvailableInstruments() {
        try {
            this.refreshing = true;
            SoundFontPlayerDevice dev = this.device;
            DefaultListModel<InstrumentInfo> instrListModel = new DefaultListModel<InstrumentInfo>();
            int[] sel = this.getListBanks().getSelectedIndices();
            for (int k = 0; k < sel.length; ++k) {
                InstrumentInfo[] instrInfo;
                SoundbankInfo bankInfo = (SoundbankInfo)this.getListBanks().getModel().getElementAt(sel[k]);
                if (bankInfo == null) continue;
                Soundbank bank = bankInfo.getSoundbank();
                if (bank == null && dev != null) {
                    try {
                        logger.info("Loading soundbank: " + bankInfo.getPath());
                        dev.loadSoundBank(bankInfo);
                        logger.info("Soundbank loaded: " + bankInfo.getPath());
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                if ((instrInfo = bankInfo.getInstrumentInfo()) == null) continue;
                for (int i = 0; i < instrInfo.length; ++i) {
                    instrListModel.addElement(instrInfo[i]);
                }
            }
            this.getListInstruments().setModel(instrListModel);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshLoadedInstruments() {
        try {
            this.refreshing = true;
            SoundFontPlayerDevice dev = this.device;
            DefaultListModel<InstrumentInfo> loadedInstrListModel = new DefaultListModel<InstrumentInfo>();
            if (dev != null) {
                int n = dev.getInstrumentInfoCount();
                for (int i = 0; i < n; ++i) {
                    InstrumentInfo info = dev.getInstrumentInfoAt(i);
                    loadedInstrListModel.addElement(info);
                }
            }
            this.getListLoadedInstruments().setModel(loadedInstrListModel);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshSoundbankDetails() {
        this.editorSoundbankInfo = null;
        try {
            String sPath;
            this.refreshing = true;
            String path = null;
            String sName = null;
            String sDescr = null;
            String sVendor = null;
            String sVersion = null;
            SoundbankInfo bankInfo = (SoundbankInfo)this.getListBanks().getSelectedValue();
            if (bankInfo != null) {
                path = bankInfo.getPath();
                Soundbank bank = bankInfo.getSoundbank();
                if (bank != null) {
                    sName = bank.getName();
                    sDescr = bank.getDescription();
                    sVendor = bank.getVendor();
                    sVersion = bank.getVersion();
                }
            }
            if ((sPath = path) == null) {
                sPath = "";
            }
            this.getTextFieldPath().setText(sPath);
            if (sName == null) {
                sName = "";
            }
            this.getTextFieldBank().setText(sName);
            if (sDescr == null) {
                sDescr = "";
            }
            this.getTextFieldBankDescr().setText(sDescr);
            if (sVendor == null) {
                sVendor = "";
            }
            this.getTextFieldBankVendor().setText(sVendor);
            if (sVersion == null) {
                sVersion = "";
            }
            this.getTextFieldBankVersion().setText(sVersion);
            String category = null;
            String comment = null;
            if (path != null) {
                // empty if block
            }
            if (category == null || category.length() < 1) {
                this.getComboBoxCategory().setSelectedItem(null);
            } else {
                this.getComboBoxCategory().addItem(category);
                this.getComboBoxCategory().setSelectedItem(category);
            }
            if (comment == null) {
                comment = "";
            }
            this.getTextFieldComments().setText(comment);
            this.editorSoundbankInfo = bankInfo;
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionLoadSelectedInstruments() {
        SoundFontPlayerDevice dev = this.device;
        if (dev == null) {
            return;
        }
        try {
            int[] sel = this.getListInstruments().getSelectedIndices();
            if (sel.length < 1) {
                return;
            }
            for (int i = 0; i < sel.length; ++i) {
                InstrumentInfo info = (InstrumentInfo)this.getListInstruments().getModel().getElementAt(sel[i]);
                dev.addInstrumentInfo(info);
            }
            InstrumentInfo info = (InstrumentInfo)this.getListInstruments().getSelectedValue();
            if (info != null) {
                dev.selectInstrumentInfo(info);
            }
        }
        finally {
            this.refreshLoadedInstruments();
        }
    }

    protected void actionAutoLoadSelectedInstruments() {
        SoundFontPlayerDevice dev = this.device;
        if (dev == null) {
            return;
        }
        ArrayList<InstrumentInfo> list = new ArrayList<InstrumentInfo>();
        int n = dev.getInstrumentInfoCount();
        for (int i = 0; i < n; ++i) {
            InstrumentInfo info = dev.getInstrumentInfoAt(i);
            list.add(info);
        }
        for (InstrumentInfo info : list) {
            dev.removeInstrumentInfo(info);
        }
        this.actionLoadSelectedInstruments();
    }

    protected JList getListBanks() {
        return this.listBanks;
    }

    protected JList getListInstruments() {
        return this.listInstruments;
    }

    protected JList getListLoadedInstruments() {
        return this.listLoadedInstruments;
    }

    protected JCheckBox getChckbxAutoload() {
        return this.chckbxAutoload;
    }

    protected JButton getButtonLoadInstruments() {
        return this.buttonLoadInstruments;
    }

    protected JButton getBtnOpenSoundBank() {
        return this.btnOpenSoundBank;
    }

    protected JTextField getTextFieldBank() {
        return this.textFieldBank;
    }

    protected JComboBox getComboBoxCategory() {
        return this.comboBoxCategory;
    }

    protected JTextField getTextFieldComments() {
        return this.textFieldComments;
    }

    protected JTextField getTextFieldPath() {
        return this.textFieldPath;
    }

    public BeansToolkit getBeansToolkit() {
        if (this.beansToolkit == null) {
            BeansToolkit btk = Platform.getInstance().getBeansToolkit();
            this.setBeansToolkit(btk);
        }
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    protected BeanDropSupport createBeanDropSupport() {
        BeansToolkit btk = this.getBeansToolkit();
        if (btk != null && btk instanceof AbstractBeansToolkit) {
            return ((AbstractBeansToolkit)btk).getBeanDropSupport();
        }
        return null;
    }

    public BeanDropSupport getBeanDropSupport() {
        if (this.beanDropSupport == null) {
            this.setBeanDropSupport(this.createBeanDropSupport());
        }
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    protected BeanContext getTargetBeanContext(int x, int y) {
        return this.dropBeanContext;
    }

    protected boolean dropBean(Object child) {
        if (child == null) {
            return false;
        }
        if (child instanceof FileLink) {
            FileLink link = (FileLink)child;
            File file = link.getFile();
            if (file == null) {
                return false;
            }
            boolean rc = this.dropFile(file);
            this.refresh();
            return rc;
        }
        if (child instanceof File) {
            File f = (File)child;
            boolean rc = this.dropFile(f);
            this.refresh();
            return rc;
        }
        logger.fine("DEBUG unsupported object: " + child);
        return false;
    }

    protected boolean dropFile(File file) {
        if (!file.exists()) {
            return false;
        }
        SoundFontPlayerDevice dev = this.device;
        if (dev == null) {
            return false;
        }
        LinkedList<File> files = new LinkedList<File>();
        if (file.isDirectory()) {
            HashSet<File> done = new HashSet<File>();
            this.scanFilesRecursive(file, done, files);
        } else {
            files.add(file);
        }
        if (files.isEmpty()) {
            return false;
        }
        for (File f : files) {
            logger.info("Adding soundbank file: " + f);
            SoundbankInfo info = new SoundbankInfo(f.getPath());
            dev.addSoundbankInfo(info);
        }
        return true;
    }

    protected JTextField getTextFieldBankDescr() {
        return this.textFieldBankDescr;
    }

    protected JTextField getTextFieldBankVendor() {
        return this.textFieldBankVendor;
    }

    protected JTextField getTextFieldBankVersion() {
        return this.textFieldBankVersion;
    }

    protected JComboBox getComboBoxRating() {
        return this.comboBoxRating;
    }

    protected class DragGestureHandler
    implements DragGestureListener {
        protected DragGestureHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            ArrayList<File> beans = new ArrayList<File>();
            int[] sel = SoundFontPlayerPanel.this.getListBanks().getSelectedIndices();
            for (int k = 0; k < sel.length; ++k) {
                String path;
                SoundbankInfo bankInfo = (SoundbankInfo)SoundFontPlayerPanel.this.getListBanks().getModel().getElementAt(sel[k]);
                if (bankInfo == null || (path = bankInfo.getPath()) == null) continue;
                beans.add(new File(path));
            }
            if (beans.isEmpty()) {
                return;
            }
            SoundFontPlayerPanel.this.dragSourceHandler.setBeanDropSupport(SoundFontPlayerPanel.this.getBeanDropSupport());
            SoundFontPlayerPanel.this.dragSourceHandler.startDrag(dge, beans);
        }
    }

    protected class DropBeanContext
    extends AnchorlessBeanContext
    implements TypeContext {
        private Set supportedTypes = new HashSet();

        public Iterator getSupportedTypes() {
            return this.supportedTypes.iterator();
        }

        public boolean supports(Class type) {
            if (this.supportedTypes.contains(type)) {
                return true;
            }
            for (Class clazz : this.supportedTypes) {
                if (!clazz.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }

        public boolean supports(Object bean) {
            return this.supports(bean.getClass());
        }

        public boolean add(Object targetChild) {
            if (targetChild == null) {
                return false;
            }
            if (!this.supports(targetChild)) {
                return false;
            }
            return SoundFontPlayerPanel.this.dropBean(targetChild);
        }

        protected void setSupportedTypes(Set supportedTypes) {
            this.supportedTypes = supportedTypes;
        }

        protected void setSupportedType(Class type) {
            this.supportedTypes.clear();
            this.supportedTypes.add(type);
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (SoundFontPlayerPanel.this.beanDropSupport == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = SoundFontPlayerPanel.this.getTargetBeanContext(pos.x, pos.y);
            this.dropBeans.clear();
            SoundFontPlayerPanel.this.beanDropSupport.enumerateDropBeans(target, dtde, this.dropBeans);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (SoundFontPlayerPanel.this.beanDropSupport == null) {
                return;
            }
            Point pos = dtde.getLocation();
            BeanContext target = SoundFontPlayerPanel.this.getTargetBeanContext(pos.x, pos.y);
            ArrayList temp = new ArrayList();
            boolean searchSuccess = SoundFontPlayerPanel.this.beanDropSupport.enumerateDropBeans(target, dtde, temp);
            if (target != null && searchSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                for (Object o : this.dropBeans) {
                    if (o == null || !SoundFontPlayerPanel.this.beanDropSupport.acceptDropBean(target, o)) continue;
                    accepted = true;
                    break;
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (SoundFontPlayerPanel.this.beanDropSupport == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Point pos = dtde.getLocation();
            BeanContext target = SoundFontPlayerPanel.this.getTargetBeanContext(pos.x, pos.y);
            ArrayList temp = new ArrayList();
            boolean enumSuccess = SoundFontPlayerPanel.this.beanDropSupport.enumerateDropBeans(target, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            Sys.println((String)(" - Drop beans: " + this.dropBeans.size()));
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                if (target != null) {
                    try {
                        Sys.println((String)" - Drop beans..");
                        SoundFontPlayerPanel.this.beanDropSupport.dropBeans(this.dropBeans, target, dropAction);
                        Sys.println((String)" - Drop completed.");
                        dtde.dropComplete(true);
                        this.dropBeans.clear();
                        return;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    Sys.println((String)"DEBUG: drop target is null!");
                }
            }
            Sys.println((String)" - Drop failed!");
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }
    }

    public static class SoundFontFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Sound-Font Files (.sf2)";
        }

        @Override
        public boolean accept(File f) {
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(SoundFontPlayerPanel.SF2_FILE_EXTENSION)) {
                return true;
            }
            return f.isDirectory();
        }
    }
}

