/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.movie.jcodec;

import com.spacekiller.util.movie.AbstractMovieProducer;
import com.spacekiller.util.movie.MovieProducerType;
import com.spacekiller.util.movie.jcodec.JCodecMovieProducerPanel;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.jcodec.api.SequenceEncoder;
import org.jcodec.common.Codec;
import org.jcodec.common.Format;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Rational;
import org.jcodec.scale.AWTUtil;

public class JCodecMovieProducer
extends AbstractMovieProducer {
    public static final String DEFAULT_VIDEO_FORMAT_NAME = "H264_MOV";
    public static final String PROPERTY_VIDEO_FORMAT_NAME = "videoFormatName";
    public static final String PROPERTY_VIDEO_OUTPUT_FILE = "videoOutputFile";
    public static final String PROPERTY_OVERWRITE_FILES = "overwriteExistingFiles";
    private static final int MAX_RATIONAL_DEN = 1000;
    private static final Logger logger = Logger.getLogger(JCodecMovieProducer.class.getName());
    private SequenceEncoder encoder;

    protected void setType(MovieProducerType type) {
        super.setType(type);
    }

    public boolean showConfigDialog(Component parentComponent) {
        JCodecMovieProducerPanel panel = new JCodecMovieProducerPanel();
        Properties props = this.getProperties();
        if (props == null) {
            props = new Properties();
        }
        panel.setProperties(props);
        JCodecMovieProducerPanel message = panel;
        String title = "JCodec Movie Producer";
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
        if (rc != 0) {
            return false;
        }
        props = panel.getProperties();
        this.setProperties(props);
        return true;
    }

    public synchronized void begin(double framesPerSecond, long maxFrames) throws Exception {
        String outputFilePath;
        String formatName;
        Properties props = super.getProperties();
        if (props == null) {
            props = new Properties();
        }
        if ((formatName = props.getProperty(PROPERTY_VIDEO_FORMAT_NAME)) == null) {
            formatName = DEFAULT_VIDEO_FORMAT_NAME;
        }
        if ((outputFilePath = props.getProperty(PROPERTY_VIDEO_OUTPUT_FILE)) == null) {
            throw new RuntimeException("Output file path not specified: videoOutputFile");
        }
        boolean overwriteFiles = false;
        String strOverwriteFiles = props.getProperty(PROPERTY_OVERWRITE_FILES);
        if (strOverwriteFiles != null && strOverwriteFiles.length() > 0) {
            overwriteFiles = "true".equalsIgnoreCase(strOverwriteFiles);
        }
        File targetFile = new File(outputFilePath);
        if (!overwriteFiles && targetFile.exists()) {
            throw new IOException("Target file already exists: " + targetFile);
        }
        int den = this.rationalDen(framesPerSecond);
        int num = (int)Math.round(framesPerSecond * (double)den);
        Rational fps = Rational.R((int)num, (int)den);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Frames per seconds: " + framesPerSecond + " => " + fps);
        }
        Format outputFormat = Format.MOV;
        Codec outputVideoCodec = Codec.H264;
        Codec outputAudioCodec = null;
        FileChannelWrapper out = NIOUtils.writableChannel((File)targetFile);
        this.encoder = new SequenceEncoder((SeekableByteChannel)out, fps, outputFormat, outputVideoCodec, outputAudioCodec);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SequenceEncoder: " + this.encoder);
        }
    }

    public synchronized void appendImage(RenderedImage image) throws Exception {
        BufferedImage bi = null;
        if (image != null && image instanceof BufferedImage) {
            bi = (BufferedImage)image;
        }
        if (bi == null) {
            throw new IllegalArgumentException("Unsupported image object: " + image);
        }
        this.encoder.encodeNativeFrame(AWTUtil.fromBufferedImageRGB((BufferedImage)bi));
    }

    public synchronized void finish() throws Exception {
        if (this.encoder != null) {
            this.encoder.finish();
            this.encoder = null;
        }
    }

    public synchronized void close() throws Exception {
        this.finish();
    }

    protected int rationalDen(double v) {
        for (int i = 1; i < 1000; ++i) {
            double x = v * (double)i;
            if (x != (double)((long)x)) continue;
            return i;
        }
        return 1000;
    }
}

