/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.movie.jcodec;

import com.spacekiller.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class JCodecMovieProducerPanel
extends JPanel {
    private static final long serialVersionUID = 26234455622800L;
    protected static final String DEFAULT_FILE_NAME = "JCodecMovie.mov";
    private JLabel jLabel = null;
    private JTextField jTextFieldOutputFile = null;
    private JLabel jLabel3 = null;
    private JComboBox jComboBoxVideoFormat = null;
    private JCheckBox jCheckBoxOverwrite = null;
    private JButton jButtonBrowse = null;
    private JPanel panel_1;

    public JCodecMovieProducerPanel() {
        this.initialize();
        this.initJCodecMovieProducerPanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(572, 433));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(4, 4, 0, 0);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        this.add((Component)this.getPanel_1(), gbc_panel_1);
    }

    private JTextField getJTextFieldOutputFile() {
        if (this.jTextFieldOutputFile == null) {
            this.jTextFieldOutputFile = new JTextField();
            this.jTextFieldOutputFile.setOpaque(false);
        }
        return this.jTextFieldOutputFile;
    }

    private JComboBox getJComboBoxVideoFormat() {
        if (this.jComboBoxVideoFormat == null) {
            this.jComboBoxVideoFormat = new JComboBox();
            this.jComboBoxVideoFormat.setToolTipText("Image file format");
            this.jComboBoxVideoFormat.setOpaque(false);
        }
        return this.jComboBoxVideoFormat;
    }

    private JCheckBox getJCheckBoxOverwrite() {
        if (this.jCheckBoxOverwrite == null) {
            this.jCheckBoxOverwrite = new JCheckBox();
            this.jCheckBoxOverwrite.setOpaque(false);
            this.jCheckBoxOverwrite.setText("Overwrite existing file");
        }
        return this.jCheckBoxOverwrite;
    }

    private JButton getJButtonBrowse() {
        if (this.jButtonBrowse == null) {
            this.jButtonBrowse = new JButton();
            this.jButtonBrowse.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonBrowse.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/movie/icons/movie_browse_icon16.gif")));
            this.jButtonBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCodecMovieProducerPanel.this.actionBrowseTargetFile();
                }
            });
        }
        return this.jButtonBrowse;
    }

    protected void initJCodecMovieProducerPanel() {
        this.getJTextFieldOutputFile().setColumns(30);
    }

    public String getTargetFilePath() {
        return this.jTextFieldOutputFile.getText();
    }

    public String getImageFormat() {
        Object item = this.jComboBoxVideoFormat.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.toString();
    }

    protected void actionBrowseTargetFile() {
        int rc;
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        fc.setDialogTitle("Select Target File");
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(2);
        String s = this.getTargetFilePath();
        if (s != null && s.length() > 0) {
            fc.setCurrentDirectory(new File(s));
        }
        if ((rc = fc.showDialog(this, "Select")) != 0) {
            return;
        }
        File dir = fc.getSelectedFile();
        if (dir != null) {
            this.getJTextFieldOutputFile().setText(dir.getPath());
        }
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            this.panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "JCodec Movie Producer", 4, 2, null, new Color(51, 51, 51)));
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{0, 0, 0};
            gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, 0.0, 0.0};
            gbl_panel_1.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            this.jLabel3 = new JLabel();
            GridBagConstraints gbc_jLabel3 = new GridBagConstraints();
            gbc_jLabel3.anchor = 17;
            gbc_jLabel3.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel3.gridx = 0;
            gbc_jLabel3.gridy = 1;
            this.panel_1.add((Component)this.jLabel3, gbc_jLabel3);
            this.jLabel3.setText("Video Format:");
            GridBagConstraints gbc_jComboBoxVideoFormat = new GridBagConstraints();
            gbc_jComboBoxVideoFormat.anchor = 17;
            gbc_jComboBoxVideoFormat.insets = new Insets(4, 4, 5, 5);
            gbc_jComboBoxVideoFormat.gridx = 1;
            gbc_jComboBoxVideoFormat.gridy = 1;
            this.panel_1.add((Component)this.getJComboBoxVideoFormat(), gbc_jComboBoxVideoFormat);
            this.jLabel = new JLabel();
            GridBagConstraints gbc_jLabel = new GridBagConstraints();
            gbc_jLabel.anchor = 17;
            gbc_jLabel.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel.gridx = 0;
            gbc_jLabel.gridy = 2;
            this.panel_1.add((Component)this.jLabel, gbc_jLabel);
            this.jLabel.setText("Output File:");
            GridBagConstraints gbc_jTextFieldOutputFile = new GridBagConstraints();
            gbc_jTextFieldOutputFile.insets = new Insets(4, 4, 5, 5);
            gbc_jTextFieldOutputFile.weightx = 1.0;
            gbc_jTextFieldOutputFile.fill = 1;
            gbc_jTextFieldOutputFile.gridx = 1;
            gbc_jTextFieldOutputFile.gridy = 2;
            this.panel_1.add((Component)this.getJTextFieldOutputFile(), gbc_jTextFieldOutputFile);
            GridBagConstraints gbc_jButtonBrowse = new GridBagConstraints();
            gbc_jButtonBrowse.insets = new Insets(4, 0, 5, 0);
            gbc_jButtonBrowse.gridx = 2;
            gbc_jButtonBrowse.gridy = 2;
            this.panel_1.add((Component)this.getJButtonBrowse(), gbc_jButtonBrowse);
            GridBagConstraints gbc_jCheckBoxOverwrite = new GridBagConstraints();
            gbc_jCheckBoxOverwrite.anchor = 17;
            gbc_jCheckBoxOverwrite.gridwidth = 2;
            gbc_jCheckBoxOverwrite.insets = new Insets(4, 0, 4, 5);
            gbc_jCheckBoxOverwrite.gridx = 0;
            gbc_jCheckBoxOverwrite.gridy = 3;
            this.panel_1.add((Component)this.getJCheckBoxOverwrite(), gbc_jCheckBoxOverwrite);
        }
        return this.panel_1;
    }

    public Properties getProperties() {
        Object item = this.getJComboBoxVideoFormat().getSelectedItem();
        String formatName = String.valueOf(item);
        String targetFilePath = this.getTargetFilePath();
        boolean overwriteFiles = this.getJCheckBoxOverwrite().isSelected();
        Properties props = new Properties();
        props.setProperty("videoFormatName", formatName);
        props.setProperty("videoOutputFile", targetFilePath);
        props.setProperty("overwriteExistingFiles", String.valueOf(overwriteFiles));
        return props;
    }

    public void setProperties(Properties properties) {
        String formatName;
        Properties props = properties;
        if (props == null) {
            props = new Properties();
        }
        if ((formatName = props.getProperty("videoFormatName")) == null) {
            formatName = "H264_MOV";
        }
        this.getJComboBoxVideoFormat().removeAllItems();
        this.getJComboBoxVideoFormat().addItem("H264_MOV");
        this.getJComboBoxVideoFormat().setSelectedIndex(0);
        String outputFile = props.getProperty("videoOutputFile");
        if (outputFile == null) {
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                outputFile = new File(dataDir, DEFAULT_FILE_NAME).getPath();
            }
            if (outputFile == null) {
                outputFile = "";
            }
        }
        this.getJTextFieldOutputFile().setText(outputFile);
        boolean overwriteFiles = false;
        String strOverwriteFiles = props.getProperty("overwriteExistingFiles");
        if (strOverwriteFiles != null) {
            overwriteFiles = "true".equalsIgnoreCase(strOverwriteFiles);
        }
        this.getJCheckBoxOverwrite().setSelected(overwriteFiles);
    }
}

