/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.file;

import com.spacekiller.util.file.CachePart;

public final class CachePool {
    private int partSize;
    private int maxBuf;
    private int numBuf;
    private CachePart firstBuf;
    private CachePart lastBuf;
    private boolean worstCase;

    public CachePool(int partSize, int maxBuf) {
        if (partSize < 1024) {
            throw new IllegalArgumentException("Invalid partSize: " + partSize);
        }
        if (maxBuf < 1) {
            throw new IllegalArgumentException("Invalid maxBuf: " + maxBuf);
        }
        this.partSize = partSize;
        this.maxBuf = maxBuf;
        this.firstBuf = null;
        this.lastBuf = null;
        this.numBuf = 0;
        this.worstCase = false;
    }

    public int getPartSize() {
        return this.partSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void alloc(CachePart part) {
        if (this.numBuf < this.maxBuf) {
            ++this.numBuf;
            part.data = new byte[this.partSize];
            if (this.lastBuf == null) {
                this.firstBuf = part;
                this.lastBuf = part;
            } else {
                this.lastBuf.nextBuf = part;
                part.prevBuf = this.lastBuf;
                this.lastBuf = part;
            }
            return;
        }
        while (true) {
            CachePart prev = null;
            CachePart p = this.firstBuf;
            while (p != null) {
                CachePart cachePart = p;
                synchronized (cachePart) {
                    if (p.locks == 0 && p.modEnd == 0) {
                        part.data = p.data;
                        p.loaded = false;
                        p.data = null;
                        CachePart next = p.nextBuf;
                        if (prev == null) {
                            this.firstBuf = next;
                        } else {
                            prev.nextBuf = next;
                            p.prevBuf = null;
                        }
                        if (next == null) {
                            this.lastBuf = prev;
                        } else {
                            next.prevBuf = prev;
                            p.nextBuf = null;
                        }
                        if (this.lastBuf == null) {
                            this.firstBuf = part;
                            this.lastBuf = part;
                        } else {
                            this.lastBuf.nextBuf = part;
                            part.prevBuf = this.lastBuf;
                            this.lastBuf = part;
                        }
                        return;
                    }
                }
                prev = p;
                p = p.nextBuf;
            }
            this.worstCase = true;
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
            continue;
            finally {
                this.worstCase = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void unlock(CachePart part) {
        int n;
        CachePart cachePart = part;
        synchronized (cachePart) {
            n = --part.locks;
        }
        if (part != this.lastBuf) {
            CachePart prev = part.prevBuf;
            CachePart next = part.nextBuf;
            if (prev == null) {
                this.firstBuf = next;
            } else {
                prev.nextBuf = next;
            }
            next.prevBuf = prev;
            this.lastBuf.nextBuf = part;
            part.prevBuf = this.lastBuf;
            part.nextBuf = null;
            this.lastBuf = part;
        }
        if (this.worstCase && n == 0) {
            this.notify();
        }
    }
}

