/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.file;

import com.spacekiller.util.file.CachePart;
import com.spacekiller.util.file.CachePool;
import com.spacekiller.util.file.FileAccess;
import com.spacekiller.util.file.NestedIOException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class CachedFileAccess
implements FileAccess {
    private RandomAccessFile raf;
    private boolean closed;
    private long fileLen;
    private long size;
    private int partSize;
    private int partCount;
    private CachePart[] parts;
    private Writer writer;
    private CachePart firstMod;
    private CachePart lastMod;
    private CachePool pool;

    public CachedFileAccess(RandomAccessFile raf, CachePool pool) throws IOException {
        this(raf, pool, false);
    }

    protected CachedFileAccess(RandomAccessFile raf, CachePool pool, boolean readOnly) throws IOException {
        this.raf = raf;
        this.closed = false;
        this.size = this.fileLen = raf.length();
        this.pool = pool;
        this.partSize = pool.getPartSize();
        this.partCount = this.fileLen < 1L ? 0 : (int)(1L + (this.fileLen - 1L) / (long)this.partSize);
        this.parts = new CachePart[this.partCount];
        long offset = 0L;
        for (int i = 0; i < this.partCount; ++i) {
            this.parts[i] = new CachePart(offset);
            offset += (long)this.partSize;
        }
        if (readOnly) {
            this.writer = null;
        } else {
            this.writer = new Writer();
            this.writer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.stop();
                this.writer = null;
            }
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw this.fileIsClosed();
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public long length() throws IOException {
        if (this.closed) {
            throw this.fileIsClosed();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long pos, byte[] b, int off, int len) throws IOException {
        CachePart[] arr;
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        if (off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("" + (off + len - 1) + " >= " + b.length);
        }
        int fi = (int)(pos / (long)this.partSize);
        int fo = (int)(pos % (long)this.partSize);
        long lp = pos + (long)len - 1L;
        int li = (int)(lp / (long)this.partSize);
        CachedFileAccess cachedFileAccess = this;
        synchronized (cachedFileAccess) {
            if (this.closed) {
                throw this.fileIsClosed();
            }
            arr = this.parts;
        }
        if (fi == li) {
            CachePart part = arr[fi];
            this.lock(part);
            System.arraycopy(part.data, fo, b, off, len);
            this.pool.unlock(part);
        } else {
            int n = this.partSize - fo;
            CachePart part = arr[fi];
            this.lock(part);
            System.arraycopy(part.data, fo, b, off, n);
            this.pool.unlock(part);
            off += n;
            for (n = fi + 1; n < li; ++n) {
                part = arr[n];
                this.lock(part);
                System.arraycopy(part.data, 0, b, off, this.partSize);
                this.pool.unlock(part);
                off += this.partSize;
            }
            int rest = 1 + (int)(lp % (long)this.partSize);
            part = arr[n];
            this.lock(part);
            System.arraycopy(part.data, 0, b, off, rest);
            this.pool.unlock(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long pos, byte[] b, int off, int len) throws IOException {
        CachePart[] arr;
        if (pos < 0L) {
            throw new IOException("Invalid file position: " + pos);
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        if (off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("" + (off + len - 1) + " >= " + b.length);
        }
        int fi = (int)(pos / (long)this.partSize);
        int fo = (int)(pos % (long)this.partSize);
        long lp = pos + (long)len - 1L;
        int li = (int)(lp / (long)this.partSize);
        CachedFileAccess cachedFileAccess = this;
        synchronized (cachedFileAccess) {
            if (this.closed) {
                throw this.fileIsClosed();
            }
            if (li >= this.partCount) {
                if (li >= this.parts.length) {
                    CachePart[] newParts = new CachePart[li + 1];
                    System.arraycopy(this.parts, 0, newParts, 0, this.partCount);
                    this.parts = newParts;
                }
                long offset = this.partCount * this.partSize;
                for (int i = this.partCount; i <= li; ++i) {
                    this.parts[i] = new CachePart(offset);
                    offset += (long)this.partSize;
                }
                this.partCount = li + 1;
            }
            this.size = Math.max(this.size, pos + (long)len);
            arr = this.parts;
        }
        if (fi == li) {
            CachePart part = arr[fi];
            this.lock(part);
            part.write(b, off, fo, len);
            this.writeUnlock(part);
        } else {
            int n = this.partSize - fo;
            CachePart part = arr[fi];
            this.lock(part);
            part.write(b, off, fo, n);
            this.writeUnlock(part);
            off += n;
            for (n = fi + 1; n < li; ++n) {
                part = arr[n];
                this.lock(part);
                part.write(b, off, 0, this.partSize);
                this.writeUnlock(part);
                off += this.partSize;
            }
            int rest = 1 + (int)(lp % (long)this.partSize);
            part = arr[n];
            this.lock(part);
            part.write(b, off, 0, rest);
            this.writeUnlock(part);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(CachePart part) throws IOException {
        CachePart cachePart = part;
        synchronized (cachePart) {
            ++part.locks;
            if (part.loaded) {
                return;
            }
        }
        this.load(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlock(CachePart part) throws IOException {
        Writer writer = this.writer;
        synchronized (writer) {
            if (part != this.lastMod && part.nextMod == null) {
                if (this.lastMod == null) {
                    this.firstMod = part;
                    this.lastMod = part;
                } else {
                    this.lastMod.nextMod = part;
                    this.lastMod = part;
                }
                this.writer.notifyAll();
                return;
            }
        }
        this.pool.unlock(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load(CachePart part) throws IOException {
        CachePart cachePart = part;
        synchronized (cachePart) {
            if (part.loaded) {
                return;
            }
        }
        this.pool.alloc(part);
        long offset = part.offset;
        Object object = this.raf;
        synchronized (object) {
            if (this.fileLen > offset) {
                int n = (int)Math.min((long)this.partSize, this.fileLen - offset);
                this.raf.seek(offset);
                this.raf.readFully(part.data, 0, n);
            }
        }
        object = part;
        synchronized (object) {
            part.loaded = true;
        }
    }

    private IOException fileIsClosed() {
        return new IOException("File access is closed!");
    }

    static /* synthetic */ CachePart access$100(CachedFileAccess x0) {
        return x0.lastMod;
    }

    static /* synthetic */ CachePart access$002(CachedFileAccess x0, CachePart x1) {
        x0.firstMod = x1;
        return x0.firstMod;
    }

    static /* synthetic */ CachePart access$102(CachedFileAccess x0, CachePart x1) {
        x0.lastMod = x1;
        return x0.lastMod;
    }

    static /* synthetic */ RandomAccessFile access$200(CachedFileAccess x0) {
        return x0.raf;
    }

    static /* synthetic */ long access$300(CachedFileAccess x0) {
        return x0.fileLen;
    }

    static /* synthetic */ long access$302(CachedFileAccess x0, long x1) {
        x0.fileLen = x1;
        return x0.fileLen;
    }

    static /* synthetic */ CachePool access$400(CachedFileAccess x0) {
        return x0.pool;
    }

    protected class Writer
    implements Runnable {
        private Thread writerThread;
        private boolean active;
        private boolean drain;
        private CachePart part;
        private Throwable error;

        public void start() {
            if (this.active) {
                return;
            }
            this.active = true;
            this.writerThread = new Thread(this);
            this.writerThread.start();
        }

        public void stop() throws IOException {
            if (!this.active) {
                return;
            }
            this.drain = true;
            this.writerThread.interrupt();
            try {
                this.writerThread.join();
            }
            catch (InterruptedException e) {
                throw new NestedIOException("Failed to wait for writer thread!", e);
            }
            if (this.error != null) {
                throw new NestedIOException("Writer thread failed. Cause: " + this.error, this.error);
            }
        }

        public synchronized void flush() throws IOException {
            while (true) {
                if (this.error != null) {
                    throw new NestedIOException("Writer thread failed. Cause: " + this.error, this.error);
                }
                if (CachedFileAccess.this.firstMod == null && this.part == null) {
                    return;
                }
                if (!this.active) {
                    throw new IOException("Writer thread is not active!");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

