/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.file;

import com.spacekiller.util.collect.HashIntSet;
import com.spacekiller.util.collect.IntSet;
import com.spacekiller.util.file.DefaultFileModel;
import com.spacekiller.util.file.FileAccessFactory;
import com.spacekiller.util.file.FileModel;
import com.spacekiller.util.file.MultiFileRegistry;
import com.spacekiller.util.file.Page;
import com.spacekiller.util.file.PageConsumer;
import com.spacekiller.util.file.PageType;
import com.spacekiller.util.file.PageTypeRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiFileModel
implements FileModel {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private MultiFileRegistry fileRegistry;
    private PageTypeRegistry pageRegistry;
    private FileAccessFactory factory;
    private long fileSizeLimit;
    private int minFileCount;
    private boolean closed;
    private FileModel[] models;
    private int modelCount;
    private FileModel[] robin;
    private int robinIndex;
    private int robinCount;
    private int maxPageSize;
    private int nextPageId;

    public MultiFileModel(MultiFileRegistry fileRegistry, PageTypeRegistry pageRegistry, FileAccessFactory factory, int minFileCount, long fileSizeLimit) throws IOException {
        if (minFileCount < 1) {
            minFileCount = 1;
        }
        this.fileRegistry = fileRegistry;
        this.pageRegistry = pageRegistry;
        this.factory = factory;
        this.minFileCount = minFileCount;
        this.fileSizeLimit = fileSizeLimit;
        this.maxPageSize = Integer.MAX_VALUE;
        int overhead = 1024;
        if (fileSizeLimit > 0L && fileSizeLimit - (long)overhead < (long)this.maxPageSize) {
            this.maxPageSize = (int)fileSizeLimit - overhead;
            if (this.maxPageSize < 1) {
                throw new IOException("Invalid file size limit: " + fileSizeLimit);
            }
        }
        File[] files = fileRegistry.getFiles();
        this.modelCount = 0;
        this.models = new FileModel[files.length + minFileCount + 10];
        for (int i = 0; i < files.length; ++i) {
            FileModel model = this.createFileModel(files[i]);
            this.models[this.modelCount++] = model;
        }
        while (this.modelCount < minFileCount) {
            this.newFileModel();
        }
        this.robin = new FileModel[minFileCount];
        this.robinIndex = 0;
        this.robinCount = 0;
        this.adjustRoundRobin();
        int pageCount = this.getPageCount();
        PageChecker checker = new PageChecker(pageCount);
        this.getPages(checker);
        Page duplicatePage = checker.duplicatePage;
        if (duplicatePage != null) {
            throw new IOException("Duplicate page identifier: " + duplicatePage.id + " -> " + duplicatePage);
        }
        this.nextPageId = 1;
        int hiPageId = checker.hiPageId;
        if (hiPageId >= this.nextPageId) {
            this.nextPageId = hiPageId + 1;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void flush() throws IOException {
        for (int i = 0; i < this.modelCount; ++i) {
            this.models[i].flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (int i = 0; i < this.modelCount; ++i) {
            this.models[i].close();
        }
        this.models = null;
        this.robin = null;
    }

    @Override
    public synchronized boolean isEmpty() throws IOException {
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.models[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean getPages(PageConsumer dst) throws IOException {
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.models[i].getPages(dst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getPageCount() throws IOException {
        int num = 0;
        for (int i = 0; i < this.modelCount; ++i) {
            num += this.models[i].getPageCount();
        }
        return num;
    }

    @Override
    public synchronized void deletePage(Page page) throws IOException {
        page.model.deletePage(page);
    }

    @Override
    public synchronized void compact() throws IOException {
        boolean fine = this.logger.isLoggable(Level.FINE);
        boolean finer = this.logger.isLoggable(Level.FINER);
        for (int i = 0; i < this.modelCount; ++i) {
            FileModel model = this.models[i];
            boolean empty = model.isEmpty();
            if (!empty) {
                model.compact();
                empty = model.isEmpty();
            }
            if (!empty) continue;
            if (finer) {
                this.logger.finer("File model is empty: " + model);
            }
            File file = this.getFile(model);
            if (fine) {
                this.logger.fine("Deleting empty file: " + file);
            }
            model.close();
            this.fileRegistry.removeFile(file);
            file.delete();
        }
    }

    @Override
    public synchronized long length() throws IOException {
        long len = 0L;
        for (int i = 0; i < this.modelCount; ++i) {
            len += this.models[i].length();
        }
        return len;
    }

    @Override
    public synchronized void dump(int level, BufferedWriter out) throws IOException {
        for (int i = 0; i < this.modelCount; ++i) {
            this.models[i].dump(level, out);
        }
    }

    @Override
    public synchronized Page createPage(PageType type, int size) throws IOException {
        return this.createPage(-1, type, size);
    }

    @Override
    public synchronized Page createPage(int id, PageType type, int size) throws IOException {
        int i;
        if (type == null) {
            throw new IOException("Invalid page type specified: " + type);
        }
        if (size < 0) {
            throw new IOException("Invalid page size specified: " + size);
        }
        if (size > this.maxPageSize) {
            throw new IOException("Maximum page size exceeded: " + size + " > " + this.maxPageSize);
        }
        if (id <= 0) {
            id = this.nextPageId++;
        } else if (id >= this.nextPageId) {
            this.nextPageId = id + 1;
        }
        Page page = this.robin[this.robinIndex].createPage(id, type, size);
        if (page != null) {
            ++this.robinIndex;
            this.robinIndex %= this.robinCount;
            return page;
        }
        int n = this.robinCount - this.robinIndex - 1;
        if (n > 0) {
            System.arraycopy(this.robin, this.robinIndex + 1, this.robin, this.robinIndex, n);
        }
        --this.robinCount;
        this.robin[this.robinCount] = null;
        for (i = this.robinCount - 1; i >= 0; --i) {
            page = this.robin[i].createPage(id, type, size);
            if (page == null) continue;
            this.robinIndex = 0;
            return page;
        }
        for (i = this.modelCount - 1; i >= 0; --i) {
            page = this.models[i].createPage(id, type, size);
            if (page == null) continue;
            this.robin[this.robinCount++] = this.models[i];
            if (this.robinCount < this.minFileCount) {
                this.adjustRoundRobin();
            }
            return page;
        }
        FileModel model = this.newFileModel();
        this.robin[this.robinCount++] = model;
        if (this.robinCount < this.minFileCount) {
            this.adjustRoundRobin();
        }
        return model.createPage(id, type, size);
    }

    protected synchronized FileModel newFileModel() throws IOException {
        File newFile = this.fileRegistry.newFile();
        if (newFile.exists()) {
            throw new IOException("New file already exists: " + newFile);
        }
        FileModel model = this.createFileModel(newFile);
        if (model == null) {
            throw new IOException("Unable to create new file: " + newFile);
        }
        if (this.modelCount >= this.models.length) {
            FileModel[] arr = new FileModel[this.modelCount + 10];
            System.arraycopy(this.models, 0, arr, 0, this.modelCount);
            this.models = arr;
        }
        this.models[this.modelCount++] = model;
        this.fileRegistry.addFile(newFile);
        return model;
    }

    protected synchronized FileModel createFileModel(File file) throws IOException {
        return new DefaultFileModel(this.pageRegistry, this.factory, file, this.fileSizeLimit);
    }

    protected File getFile(FileModel model) {
        DefaultFileModel def = (DefaultFileModel)model;
        return def.getFile();
    }

    protected void adjustRoundRobin() {
        int n = this.minFileCount - this.robinCount;
        if (n < 1) {
            return;
        }
        HashSet<FileModel> set = new HashSet<FileModel>(this.minFileCount);
        for (int i = 0; i < this.robinCount; ++i) {
            set.add(this.robin[i]);
        }
        int z = this.modelCount - 1;
        for (int i = 0; i < n; ++i) {
            while (z >= 0) {
                FileModel m;
                if (set.contains(m = this.models[z--])) continue;
                this.robin[this.robinCount++] = m;
                break;
            }
            if (z < 0) break;
        }
    }

    protected static class PageChecker
    implements PageConsumer {
        protected IntSet pageIds;
        protected int hiPageId;
        protected Page duplicatePage;

        public PageChecker(int pageCount) {
            int initSize = pageCount * 2 / 3;
            if (initSize < 2) {
                initSize = 2;
            }
            this.pageIds = new HashIntSet(initSize);
        }

        @Override
        public boolean consume(Page page) {
            int id = page.id;
            if (this.pageIds.contains(id)) {
                this.duplicatePage = page;
                return false;
            }
            this.pageIds.add(id);
            if (id > this.hiPageId) {
                this.hiPageId = id;
            }
            return true;
        }
    }
}

