/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.login;

import com.spacekiller.util.login.DefaultLoginPanel;
import com.spacekiller.util.login.LoginIconProvider;
import com.spacekiller.util.login.LoginRegistry;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DefaultCallbackHandler
implements CallbackHandler {
    private static final Logger logger = Logger.getLogger(DefaultCallbackHandler.class.getName());
    private final String loginRealm;
    private String dialogTitle;
    private Component parentComponent;
    private LoginIconProvider loginIconProvider;
    private LoginRegistry loginRegistry;

    public DefaultCallbackHandler(String loginRealm, String dialogTitle, Component parentComponent, LoginIconProvider loginIconProvider, LoginRegistry loginRegistry) {
        this.loginRealm = loginRealm;
        this.dialogTitle = dialogTitle;
        this.parentComponent = parentComponent;
        this.loginIconProvider = loginIconProvider;
        this.loginRegistry = loginRegistry;
    }

    public String toString() {
        return super.toString() + "[" + this.loginRealm + "]";
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.prompt(callbacks);
            return;
        }
        CallbackPrompt prompt = new CallbackPrompt(callbacks);
        try {
            SwingUtilities.invokeAndWait(prompt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Throwable error = prompt.getError();
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prompt(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        block15: {
            DefaultLoginPanel panel = new DefaultLoginPanel();
            panel.setLoginRealm(this.loginRealm);
            panel.setLoginIconProvider(this.loginIconProvider);
            panel.setLoginRegistry(this.loginRegistry);
            try {
                panel.setupLoginPanel(callbacks);
                DefaultLoginPanel message = panel;
                int optionType = 2;
                int messageType = -1;
                int rc = JOptionPane.showConfirmDialog(this.parentComponent, message, this.dialogTitle, optionType, messageType);
                if (rc != 0) {
                    throw new IOException("Login cancelled on user request");
                }
                panel.handleCallbacks();
                if (this.loginRegistry == null || this.loginRealm == null || callbacks == null) break block15;
                NameCallback userNameCallback = null;
                PasswordCallback passwordCallback = null;
                boolean invalid = false;
                for (Callback callback : callbacks) {
                    if (callback == null) continue;
                    if (callback instanceof NameCallback) {
                        if (userNameCallback == null) {
                            userNameCallback = (NameCallback)callback;
                            continue;
                        }
                        invalid = true;
                        break;
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    if (passwordCallback == null) {
                        passwordCallback = (PasswordCallback)callback;
                        continue;
                    }
                    invalid = true;
                    break;
                }
                if (invalid || userNameCallback == null || passwordCallback == null) break block15;
                String userName = userNameCallback.getName();
                if (panel.isRememberPasswordRegistry()) {
                    char[] userPass = null;
                    try {
                        userPass = passwordCallback.getPassword();
                        this.loginRegistry.setStoredPassword(this.loginRealm, userName, userPass);
                        break block15;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                        break block15;
                    }
                    finally {
                        if (userPass != null) {
                            Arrays.fill(userPass, '\u0000');
                        }
                    }
                }
                this.loginRegistry.clearStoredPassword(this.loginRealm, userName);
            }
            finally {
                panel.resetLoginPanel();
                panel.setLoginRegistry(null);
                panel.setLoginIconProvider(null);
            }
        }
    }

    protected class CallbackPrompt
    implements Runnable {
        private Callback[] callbacks;
        private Throwable error;

        public CallbackPrompt(Callback[] callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public void run() {
            try {
                DefaultCallbackHandler.this.prompt(this.callbacks);
            }
            catch (Throwable e) {
                this.error = e;
            }
        }

        protected Throwable getError() {
            return this.error;
        }
    }
}

