/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.login;

import com.spacekiller.util.Data;
import com.spacekiller.util.login.LoginRegistry;
import com.spacekiller.util.login.ProtectedInfoCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class DefaultLoginRegistry
implements LoginRegistry {
    private static final Logger logger = Logger.getLogger(DefaultLoginRegistry.class.getName());
    private Preferences preferences = null;
    private ProtectedInfoCodec protectedInfoCodec = null;
    private int minGarbageBytes = 8;
    private int maxGarbageBytes = 32;
    private SecureRandom secureRandom = new SecureRandom();

    public DefaultLoginRegistry() {
    }

    public DefaultLoginRegistry(ProtectedInfoCodec protectedInfoCodec) {
        this();
        this.protectedInfoCodec = protectedInfoCodec;
    }

    @Override
    public char[] getStoredPassword(String realm, String userName) throws IOException {
        String key = this.createKey(realm, userName);
        if (key == null) {
            return null;
        }
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            return null;
        }
        String value = prefs.get(key, null);
        if (value == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("getStoredPassword: " + key + " = " + value);
        }
        byte[] data = null;
        try {
            char[] pass;
            ProtectedInfoCodec codec = this.getProtectedInfoCodec();
            data = codec.decryptBytes(value);
            char[] cArray = pass = this.ungarbage(data, realm, userName);
            return cArray;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (data != null) {
                Arrays.fill(data, (byte)0);
            }
        }
    }

    @Override
    public void setStoredPassword(String realm, String userName, char[] userPass) throws IOException {
        this.storePassword(realm, userName, userPass);
    }

    @Override
    public void clearStoredPassword(String realm, String userName) throws IOException {
        char[] userPass = null;
        this.storePassword(realm, userName, userPass);
    }

    protected boolean storePassword(String realm, String userName, char[] userPass) throws IOException {
        String key = this.createKey(realm, userName);
        if (key == null) {
            return false;
        }
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            return false;
        }
        if (userPass != null) {
            String value;
            byte[] data = null;
            try {
                data = this.garbage(realm, userName, userPass);
                ProtectedInfoCodec codec = this.getProtectedInfoCodec();
                value = codec.encryptBytes(data);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (data != null) {
                    Arrays.fill(data, (byte)0);
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("storePassword: " + key + " = " + value);
            }
            prefs.put(key, value);
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("clearPassword: " + key);
        }
        prefs.remove(key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] garbage(String realm, String userName, char[] userPass) throws IOException {
        byte[] byArray;
        block5: {
            byte[] passData = null;
            try {
                byte[] realmData = this.char2ByteArray(realm.toCharArray());
                byte[] userData = this.char2ByteArray(userName.toCharArray());
                passData = this.char2ByteArray(userPass);
                int garbageSize = this.minGarbageBytes + (int)(this.secureRandom.nextDouble() * (double)(this.maxGarbageBytes - this.minGarbageBytes));
                if (garbageSize > this.maxGarbageBytes) {
                    garbageSize = this.maxGarbageBytes;
                }
                if (garbageSize < this.minGarbageBytes) {
                    garbageSize = this.minGarbageBytes;
                }
                byte[] garbage = new byte[garbageSize];
                this.secureRandom.nextBytes(garbage);
                byte[] result = new byte[4 + realmData.length + 4 + userData.length + 4 + passData.length + 4 + garbageSize];
                int resultOfs = 0;
                Data.setInt((byte[])result, (int)resultOfs, (int)garbage.length);
                Data.setInt((byte[])result, (int)(resultOfs += 4 + garbage.length), (int)realmData.length);
                Data.setInt((byte[])result, (int)(resultOfs += 4 + realmData.length), (int)userData.length);
                Data.setInt((byte[])result, (int)(resultOfs += 4 + userData.length), (int)passData.length);
                resultOfs = 0;
                System.arraycopy(garbage, 0, result, resultOfs + 4, garbage.length);
                System.arraycopy(realmData, 0, result, (resultOfs += 4 + garbage.length) + 4, realmData.length);
                System.arraycopy(userData, 0, result, (resultOfs += 4 + realmData.length) + 4, userData.length);
                System.arraycopy(passData, 0, result, (resultOfs += 4 + userData.length) + 4, passData.length);
                resultOfs += 4 + passData.length;
                byArray = result;
                if (passData == null) break block5;
            }
            catch (Throwable throwable) {
                if (passData != null) {
                    Arrays.fill(passData, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(passData, (byte)0);
        }
        return byArray;
    }

    private char[] ungarbage(byte[] garbage, String realm, String userName) throws IOException {
        int passSize;
        char[] userData;
        int userSize;
        char[] realmData;
        int realmSize;
        int ofs = 0;
        int garbageSize = Data.getInt((byte[])garbage, (int)ofs);
        if (garbageSize >= 0 && (realmSize = Data.getInt((byte[])garbage, (int)(ofs += 4 + garbageSize))) == realm.length() * 2 && realm.equals(new String(realmData = this.byte2CharArray(garbage, ofs + 4, realmSize))) && (userSize = Data.getInt((byte[])garbage, (int)(ofs += 4 + realmSize))) == userName.length() * 2 && userName.equals(new String(userData = this.byte2CharArray(garbage, ofs + 4, userSize))) && (passSize = Data.getInt((byte[])garbage, (int)(ofs += 4 + userSize))) >= 0) {
            char[] pass = this.byte2CharArray(garbage, ofs + 4, passSize);
            return pass;
        }
        throw new IOException("Invalid stored password data!");
    }

    private byte[] char2ByteArray(char[] arr) {
        int len = arr.length;
        byte[] data = new byte[len * 2];
        int off = 0;
        for (int i = 0; i < len; ++i) {
            data[off++] = (byte)((arr[i] & 0xFF00) >> 8);
            data[off++] = (byte)(arr[i] & 0xFF);
        }
        return data;
    }

    private char[] byte2CharArray(byte[] arr, int off, int len) {
        int num = len / 2;
        char[] data = new char[num];
        for (int i = 0; i < num; ++i) {
            int v = (arr[off++] & 0xFF) << 8;
            data[i] = (char)(v |= arr[off++] & 0xFF);
        }
        return data;
    }

    protected String createKey(String realm, String userName) throws IOException {
        ProtectedInfoCodec codec = this.getProtectedInfoCodec();
        if (codec == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(userName);
        dos.writeUTF(realm);
        dos.flush();
        byte[] data = baos.toByteArray();
        dos.close();
        try {
            String key = codec.encryptBytes(data);
            if (key.length() > 80) {
                key = key.substring(0, 80);
            }
            return key;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createCodecSalt(long v) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(v);
            dos.flush();
            byte[] salt = baos.toByteArray();
            if (salt.length != 8) {
                throw new RuntimeException("Invalid salt length: " + salt.length);
            }
            byte[] byArray = salt;
            return byArray;
        }
        finally {
            dos.close();
        }
    }

    private ProtectedInfoCodec createProtectedInfoCodec() {
        ProtectedInfoCodec codec = this.createProtectedInfoCodecOverride();
        if (codec != null) {
            return codec;
        }
        try {
            char[] pass = this.getClass().getName().toCharArray();
            byte[] salt = this.createCodecSalt(9049919172503978865L);
            int iterationCount = 1024;
            codec = new ProtectedInfoCodec(pass, salt, iterationCount);
            return codec;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ProtectedInfoCodec createProtectedInfoCodecOverride() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectedInfoCodec getProtectedInfoCodec() {
        if (this.protectedInfoCodec == null) {
            DefaultLoginRegistry defaultLoginRegistry = this;
            synchronized (defaultLoginRegistry) {
                if (this.protectedInfoCodec == null) {
                    this.setProtectedInfoCodec(this.createProtectedInfoCodec());
                }
            }
        }
        return this.protectedInfoCodec;
    }

    private void setProtectedInfoCodec(ProtectedInfoCodec protectedInfoCodec) {
        this.protectedInfoCodec = protectedInfoCodec;
    }

    protected Preferences createPreferences() {
        return Preferences.userNodeForPackage(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences getPreferences() {
        if (this.preferences == null) {
            DefaultLoginRegistry defaultLoginRegistry = this;
            synchronized (defaultLoginRegistry) {
                if (this.preferences == null) {
                    this.setPreferences(this.createPreferences());
                }
            }
        }
        return this.preferences;
    }

    private void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }
}

