/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.login;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class ProtectedInfoCodec {
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private final char[] pass;
    private final byte[] salt;
    private final int iterationCount;

    protected ProtectedInfoCodec(char[] pass, byte[] salt, int iterationCount) {
        this.pass = pass;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    public String encryptBytes(byte[] data) throws GeneralSecurityException, IOException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey key = keyFactory.generateSecret(new PBEKeySpec(this.pass));
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(1, (Key)key, new PBEParameterSpec(this.salt, this.iterationCount));
        return this.encodeBytes(pbeCipher.doFinal(data));
    }

    public byte[] decryptBytes(String value) throws GeneralSecurityException, IOException {
        byte[] data = this.decodeBytes(value);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey key = keyFactory.generateSecret(new PBEKeySpec(this.pass));
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(2, (Key)key, new PBEParameterSpec(this.salt, this.iterationCount));
        return pbeCipher.doFinal(data);
    }

    private String encodeBytes(byte[] data) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (byte b : data) {
            sb.append(HEX_CHARS.charAt((b & 0xF0) >> 4));
            sb.append(HEX_CHARS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    private byte[] decodeBytes(String value) throws IOException {
        int num = value.length();
        int len = num / 2;
        byte[] data = new byte[len];
        int off = 0;
        for (int i = 0; i < len; ++i) {
            data[i] = this.decodeByte(value, off);
            off += 2;
        }
        return data;
    }

    private byte decodeByte(String value, int off) throws IOException {
        char c = value.charAt(off);
        int x = HEX_CHARS.indexOf(c);
        if (x < 0) {
            throw new IOException("Invalid hex character 0x" + c + " at offset " + off);
        }
        byte v = (byte)(x << 4);
        c = value.charAt(off + 1);
        x = HEX_CHARS.indexOf(c);
        if (x < 0) {
            throw new IOException("Invalid hex character 0x" + c + " at offset " + (off + 1));
        }
        v = (byte)(v | (byte)x);
        return v;
    }
}

