/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.control.Control;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineFeature;
import com.waxmonster.waxlab.LineListener;
import com.waxmonster.waxlab.LineMidiMapping;
import com.waxmonster.waxlab.LineMidiTrigger;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.impl.AbstractLineWidget;
import com.waxmonster.waxlab.impl.WaxLabImpl;
import com.waxmonster.waxlab.util.LineWrapper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractLine
implements Line {
    protected final ReadWriteLock lock;
    private WaxLabImpl waxLabImpl;
    private String name;
    private Properties properties;
    private LineListener[] listeners;
    private boolean lineDirty;
    private LineChunk recChunk;
    private LineWrapper wrapper;
    private List features;
    private List widgets;
    private List controls;
    private MidiAction[] midiActions;
    private MidiMapping[] midiMappings;
    private String[] midiEvents;
    private MidiTrigger[] midiTriggers;
    private MidiAction[] widgetMidiActions;
    private String[] widgetMidiEvents;
    private int trackSize = -1;

    public AbstractLine(ReadWriteLock lock) {
        this.lock = lock;
        this.listeners = new LineListener[0];
        this.properties = new Properties();
        this.features = new ArrayList();
        this.widgets = new ArrayList();
        this.controls = new ArrayList();
    }

    public final WaxLab getWaxLab() {
        return this.waxLabImpl;
    }

    protected final WaxLabImpl getWaxLabImpl() {
        return this.waxLabImpl;
    }

    final void setWaxLabImpl(WaxLabImpl waxLabImpl) {
        this.waxLabImpl = waxLabImpl;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        if (this.name == name) {
            return;
        }
        if (name != null && name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.fireLineChanged();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        return props;
    }

    public void setProperties(Properties newProperties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)newProperties);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
    }

    public synchronized void registerLineListener(LineListener l) {
        int oldCount = this.listeners.length;
        LineListener[] arr = new LineListener[oldCount + 1];
        System.arraycopy(this.listeners, 0, arr, 0, oldCount);
        arr[oldCount] = l;
        this.listeners = arr;
    }

    public synchronized void unregisterLineListener(LineListener l) {
        int oldCount = this.listeners.length;
        int index = -1;
        for (int i = 0; i < oldCount; ++i) {
            if (this.listeners[i] != l) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        LineListener[] arr = new LineListener[oldCount - 1];
        System.arraycopy(this.listeners, 0, arr, 0, index);
        System.arraycopy(this.listeners, index + 1, arr, index, oldCount - index - 1);
        this.listeners = arr;
    }

    protected void fireFeatureAdded(LineFeature feature) {
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].featureAdded((Line)this, feature);
        }
    }

    protected void fireFeatureRemoved(LineFeature feature) {
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].featureRemoved((Line)this, feature);
        }
    }

    protected void fireFeatureChanged(LineFeature feature) {
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].featureChanged((Line)this, feature);
        }
    }

    protected void fireFeatureSynced(LineFeature feature) {
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].featureSynced((Line)this, feature);
        }
    }

    protected void fireLineChanged() {
        this.refreshWidgetMidiActions();
        this.refreshWidgetMidiEvents();
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].lineChanged((Line)this);
        }
    }

    protected void fireWidgetAdded(LineWidget widget) {
        this.refreshWidgetMidiActions();
        this.refreshWidgetMidiEvents();
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].widgetAdded((Line)this, widget);
        }
    }

    protected void fireWidgetRemoved(LineWidget widget) {
        this.refreshWidgetMidiActions();
        this.refreshWidgetMidiEvents();
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].widgetRemoved((Line)this, widget);
        }
    }

    protected void fireWidgetChanged(LineWidget widget) {
        this.refreshWidgetMidiActions();
        this.refreshWidgetMidiEvents();
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].widgetChanged((Line)this, widget);
        }
    }

    protected void fireControlAdded(Control control) {
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].controlAdded((Line)this, control);
        }
    }

    protected void fireControlRemoved(Control control) {
        LineListener[] arr = this.listeners;
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            arr[i].controlRemoved((Line)this, control);
        }
    }

    public boolean isLineDirty() {
        return this.lineDirty;
    }

    public void setLineDirty() {
        this.lineDirty = true;
    }

    public void clearLineDirty() {
        this.lineDirty = false;
    }

    public LineChunk getRecChunk() {
        return this.recChunk;
    }

    public void setRecChunk(LineChunk recChunk) {
        this.recChunk = recChunk;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    public LineWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(LineWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public MidiMapping[] getMidiMappings() {
        return this.midiMappings;
    }

    public void setMidiMappings(MidiMapping[] midiMappings) {
        this.midiMappings = midiMappings;
    }

    public MidiAction[] getMidiActions() {
        MidiAction[] orig = this.midiActions;
        int num = orig == null ? 0 : orig.length;
        MidiAction[] arr = new MidiAction[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    protected void setMidiActions(MidiAction[] midiActions) {
        this.midiActions = midiActions;
    }

    public MidiTrigger[] getMidiTriggers() {
        return this.midiTriggers;
    }

    public void setMidiTriggers(MidiTrigger[] midiTriggers) {
        this.midiTriggers = midiTriggers;
    }

    public String[] getMidiEvents() {
        String[] orig = this.midiEvents;
        int num = orig == null ? 0 : orig.length;
        String[] arr = new String[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    protected void setMidiEvents(String[] midiEvents) {
        this.midiEvents = midiEvents;
    }

    public MidiAction[] getWidgetMidiActions() {
        MidiAction[] orig = this.widgetMidiActions;
        int num = orig == null ? 0 : orig.length;
        MidiAction[] arr = new MidiAction[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    protected void setWidgetMidiActions(MidiAction[] widgetMidiActions) {
        this.widgetMidiActions = widgetMidiActions;
    }

    public MidiAction getWidgetMidiAction(LineMidiMapping mapping) {
        String actionName = LineMidiMapping.parseLineAction((String)mapping.getAction());
        if ((actionName = LineMidiMapping.formatLineAction((Line)this, (String)actionName)) == null) {
            return null;
        }
        MidiAction[] actions = this.widgetMidiActions;
        int num = actions == null ? 0 : actions.length;
        for (int i = 0; i < num; ++i) {
            MidiAction action = actions[i];
            if (!actionName.equals(action.getName())) continue;
            return action;
        }
        return null;
    }

    protected synchronized void refreshWidgetMidiActions() {
        LinkedList<MidiAction> actionList = new LinkedList<MidiAction>();
        int num = this.widgets.size();
        for (int i = 0; i < num; ++i) {
            LineWidget widget = (LineWidget)this.widgets.get(i);
            MidiAction[] actions = widget.getMidiActions();
            int acts = actions == null ? 0 : actions.length;
            for (int k = 0; k < acts; ++k) {
                MidiAction action = actions[k];
                if (action == null) continue;
                actionList.add(action);
            }
        }
        this.setWidgetMidiActions(actionList.toArray(new MidiAction[actionList.size()]));
    }

    public String[] getWidgetMidiEvents() {
        String[] orig = this.widgetMidiEvents;
        int num = orig == null ? 0 : orig.length;
        String[] arr = new String[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    protected void setWidgetMidiEvents(String[] widgetMidiEvents) {
        this.widgetMidiEvents = widgetMidiEvents;
    }

    public String getWidgetMidiEvent(LineMidiTrigger trigger) {
        String eventName = LineMidiTrigger.parseLineEvent((String)trigger.getEvent());
        if (eventName == null) {
            return null;
        }
        String[] events = this.widgetMidiEvents;
        int num = events == null ? 0 : events.length;
        for (int i = 0; i < num; ++i) {
            String event = events[i];
            if (!eventName.equals(event)) continue;
            return event;
        }
        return null;
    }

    protected synchronized void refreshWidgetMidiEvents() {
        LinkedList<String> eventList = new LinkedList<String>();
        int num = this.widgets.size();
        for (int i = 0; i < num; ++i) {
            LineWidget widget = (LineWidget)this.widgets.get(i);
            String[] events = widget.getMidiEvents();
            int acts = events == null ? 0 : events.length;
            for (int k = 0; k < acts; ++k) {
                String event = events[k];
                if (event == null) continue;
                eventList.add(event);
            }
        }
        this.setWidgetMidiEvents(eventList.toArray(new String[eventList.size()]));
    }

    public MediaPlayer[] getMediaPlayers() {
        return null;
    }

    public synchronized LineFeature[] getLineFeatures() {
        return this.features.toArray(new LineFeature[this.features.size()]);
    }

    protected synchronized void addLineFeature(LineFeature feature) {
        if (feature == null) {
            return;
        }
        this.features.add(feature);
        this.fireFeatureAdded(feature);
    }

    protected synchronized void removeLineFeature(LineFeature feature) {
        if (this.features.remove(feature)) {
            this.fireFeatureRemoved(feature);
        }
    }

    public synchronized LineWidget[] getLineWidgets() {
        return this.widgets.toArray(new LineWidget[this.widgets.size()]);
    }

    protected synchronized void addLineWidget(LineWidget widget) {
        if (widget == null) {
            return;
        }
        this.widgets.add(widget);
        this.fireWidgetAdded(widget);
    }

    protected synchronized void removeLineWidget(LineWidget widget) {
        if (this.widgets.remove(widget)) {
            this.fireWidgetRemoved(widget);
        }
    }

    public synchronized Control[] getLineControls() {
        return this.controls.toArray(new Control[this.controls.size()]);
    }

    protected synchronized void addLineControl(Control control) {
        if (control == null) {
            return;
        }
        this.controls.add(control);
        this.fireControlAdded(control);
    }

    protected synchronized void removeLineControl(Control control) {
        if (this.controls.remove(control)) {
            this.fireControlRemoved(control);
        }
    }

    public int getTrackSize() {
        return this.trackSize;
    }

    public void setTrackSize(int trackSize) {
        this.trackSize = trackSize;
    }

    public void toggleLineWidgetSelected(LineWidget widget) {
        this.setLineWidgetSelected(widget, !widget.isSelected());
    }

    public boolean isLineWidgetSelected(LineWidget widget) {
        return widget.isSelected();
    }

    public void setLineWidgetSelected(LineWidget widget, boolean selected) {
        if (widget != null && widget instanceof AbstractLineWidget) {
            AbstractLineWidget alf = (AbstractLineWidget)widget;
            alf.setSelected(selected);
        }
    }

    protected DefaultChunkModel createDefaultChunkModel() {
        int initChunkCapacity = 10;
        int initIntervalCapacity = 20;
        return new DefaultChunkModel(this.lock, initChunkCapacity, initIntervalCapacity);
    }
}

