/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineFeature;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.SyncFeature;
import com.waxmonster.waxlab.impl.SyncFeatureImpl;
import com.waxmonster.waxlab.impl.SyncHandler;
import com.waxmonster.waxlab.impl.SyncMediator;
import com.waxmonster.waxlab.impl.SyncMediatorImpl;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import javax.swing.SwingUtilities;

public abstract class AbstractLineFeature
implements LineFeature {
    private final AbstractLine line;
    private final String name;
    private boolean valid;
    private boolean enabled;
    private boolean active;
    private SyncMediatorImpl mediator;
    private SyncFeatureImpl syncFeature;
    private final FireFeatureChanged fireFeatureChanged = new FireFeatureChanged();
    private final FireFeatureSynced fireFeatureSynced = new FireFeatureSynced();

    public AbstractLineFeature(AbstractLine line, String name) {
        if (line == null) {
            throw new NullPointerException("line is null");
        }
        this.line = line;
        this.name = name;
        this.valid = true;
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public final Line getLine() {
        return this.line;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isValid() {
        return this.valid;
    }

    final void setValid(boolean valid) {
        this.valid = valid;
    }

    protected final void invalidate() {
        this.valid = false;
        SwingUtilities.invokeLater(this.fireFeatureChanged);
    }

    protected void fireFeatureChanged() {
        this.line.fireFeatureChanged(this);
    }

    protected void validate() {
        this.valid = true;
    }

    public final synchronized boolean isEnabled() {
        return this.enabled;
    }

    protected synchronized void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.invalidate();
    }

    public final boolean isActive() {
        return this.active;
    }

    final void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        SwingUtilities.invokeLater(this.fireFeatureSynced);
    }

    protected void fireFeatureSynced() {
        this.line.fireFeatureSynced(this);
    }

    protected final SyncMediator getMediator() {
        return this.mediator;
    }

    final SyncMediatorImpl getMediatorImpl() {
        return this.mediator;
    }

    final void setMediatorImpl(SyncMediatorImpl mediator) {
        this.mediator = mediator;
    }

    protected final SyncFeature getSyncFeature() {
        return this.syncFeature;
    }

    final SyncFeatureImpl getSyncFeatureImpl() {
        return this.syncFeature;
    }

    final void setSyncFeatureImpl(SyncFeatureImpl syncFeature) {
        this.syncFeature = syncFeature;
    }

    protected abstract void mediateFeature(SyncFeature var1);

    protected abstract void prepareSyncHandler(SyncHandler var1, WaxLabAudioSyncGroup var2, long var3, long var5, long var7);

    protected abstract void prepareSyncHandler(SyncHandler var1, WaxLabMidiInputPort var2, long var3, long var5, long var7);

    protected abstract void prepareSyncHandler(SyncHandler var1, WaxLabMidiOutputPort var2, long var3, long var5, long var7);

    protected abstract void releaseSyncHandler(SyncHandler var1);

    protected class FireFeatureSynced
    implements Runnable {
        protected FireFeatureSynced() {
        }

        @Override
        public void run() {
            AbstractLineFeature.this.fireFeatureSynced();
        }
    }

    protected class FireFeatureChanged
    implements Runnable {
        protected FireFeatureChanged() {
        }

        @Override
        public void run() {
            AbstractLineFeature.this.fireFeatureChanged();
        }
    }
}

