/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Platform;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.LineMidiMapping;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.impl.AbstractLine;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiMessage;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public abstract class AbstractLineWidget
implements LineWidget {
    private static final Logger logger = Platform.getLogger(AbstractLineWidget.class);
    protected static final String PREFIX_WIDGET_ENABLE = "Enable";
    protected static final String PREFIX_WIDGET_DISABLE = "Disable";
    protected static final String PREFIX_WIDGET_TOGGLE = "Toggle";
    private final AbstractLine line;
    private final String name;
    private String tooltip;
    private boolean selected;
    private boolean active;
    private MidiAction[] midiActions;
    private MidiAction toggleMidiAction;
    private String[] midiEvents;
    private Icon iconDisabled16;
    private Icon iconEnabled16;
    private Icon iconActive16;
    private final FireWidgetChanged fireWidgetChanged = new FireWidgetChanged();

    public AbstractLineWidget(AbstractLine line, String name) {
        if (line == null) {
            throw new NullPointerException("line is null");
        }
        this.line = line;
        this.name = name;
        this.initMidiActions();
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public final Line getLine() {
        return this.line;
    }

    public final String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    protected void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public final synchronized boolean isSelected() {
        return this.selected;
    }

    protected synchronized void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        SwingUtilities.invokeLater(this.fireWidgetChanged);
    }

    public final boolean isActive() {
        return this.active;
    }

    final void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        SwingUtilities.invokeLater(this.fireWidgetChanged);
    }

    public MidiAction[] getMidiActions() {
        MidiAction[] orig = this.midiActions;
        int num = orig == null ? 0 : orig.length;
        MidiAction[] arr = new MidiAction[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    protected void setMidiActions(MidiAction[] midiActions) {
        this.midiActions = midiActions;
    }

    public MidiAction getToggleMidiAction() {
        return this.toggleMidiAction;
    }

    protected void setToggleMidiAction(MidiAction toggleMidiAction) {
        this.toggleMidiAction = toggleMidiAction;
    }

    public String[] getMidiEvents() {
        String[] orig = this.midiEvents;
        int num = orig == null ? 0 : orig.length;
        String[] arr = new String[num];
        if (num > 0) {
            System.arraycopy(orig, 0, arr, 0, num);
        }
        return arr;
    }

    protected void setMidiEvents(String[] midiEvents) {
        this.midiEvents = midiEvents;
    }

    protected void initMidiActions() {
        EnableMidiAction midiActionEnable = new EnableMidiAction(PREFIX_WIDGET_ENABLE + this.name);
        DisableMidiAction midiActionDisable = new DisableMidiAction(PREFIX_WIDGET_DISABLE + this.name);
        ToggleMidiAction midiActionToggle = new ToggleMidiAction(PREFIX_WIDGET_TOGGLE + this.name);
        this.setMidiActions(new MidiAction[]{midiActionEnable, midiActionDisable, midiActionToggle});
        this.setToggleMidiAction(midiActionToggle);
    }

    public Icon getUnselectedIcon(int kind) {
        switch (kind) {
            default: 
        }
        if (this.iconDisabled16 == null) {
            this.iconDisabled16 = this.createDisabledIcon16();
        }
        return this.iconDisabled16;
    }

    public Icon getSelectedIcon(int kind) {
        switch (kind) {
            default: 
        }
        if (this.iconEnabled16 == null) {
            this.iconEnabled16 = this.createEnabledIcon16();
        }
        return this.iconEnabled16;
    }

    public Icon getActiveIcon(int kind) {
        switch (kind) {
            default: 
        }
        if (this.iconActive16 == null) {
            this.iconActive16 = this.createActiveIcon16();
        }
        return this.iconActive16;
    }

    protected abstract Icon createDisabledIcon16();

    protected abstract Icon createEnabledIcon16();

    protected abstract Icon createActiveIcon16();

    protected class ToggleMidiAction
    extends AbstractWidgetMidiAction {
        public ToggleMidiAction(String name) {
            super(name);
        }

        @Override
        protected void execute(long time, int status, int data1, int data2) {
            AbstractLineWidget.this.line.toggleLineWidgetSelected(AbstractLineWidget.this);
        }
    }

    protected class DisableMidiAction
    extends AbstractWidgetMidiAction {
        public DisableMidiAction(String name) {
            super(name);
        }

        @Override
        protected void execute(long time, int status, int data1, int data2) {
            AbstractLineWidget.this.line.setLineWidgetSelected(AbstractLineWidget.this, false);
        }
    }

    protected class EnableMidiAction
    extends AbstractWidgetMidiAction {
        public EnableMidiAction(String name) {
            super(name);
        }

        @Override
        protected void execute(long time, int status, int data1, int data2) {
            AbstractLineWidget.this.line.setLineWidgetSelected(AbstractLineWidget.this, true);
        }
    }

    protected abstract class AbstractWidgetMidiAction
    implements MidiAction {
        private final String actionName;

        public AbstractWidgetMidiAction(String actionName) {
            this.actionName = actionName;
        }

        public String getName() {
            return LineMidiMapping.formatLineAction((Line)AbstractLineWidget.this.line, (String)this.actionName);
        }

        public String getTitle() {
            return this.actionName;
        }

        public String toString() {
            return super.toString() + "[name=" + this.getName() + "]";
        }

        public void invoke(final long time, final int status, final int data1, final int data2) {
            switch (status & 0xF0) {
                case 144: 
                case 176: {
                    if (data2 >= 1) break;
                    return;
                }
                default: {
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractWidgetMidiAction.this.execute(time, status, data1, data2);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            });
        }

        public void systemExclusive(long time, MidiMessage mm) {
        }

        protected abstract void execute(long var1, int var3, int var4, int var5);
    }

    protected class FireWidgetChanged
    implements Runnable {
        protected FireWidgetChanged() {
        }

        @Override
        public void run() {
            AbstractLineWidget.this.line.fireWidgetChanged(AbstractLineWidget.this);
        }
    }
}

