/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.waxmonster.waxlab.PitchFactorControl;

public abstract class AbstractPitchFactorControl
extends AbstractDoubleControl
implements PitchFactorControl {
    private static final String[] COMMON_PITCH_RANGES = new String[]{AbstractPitchFactorControl.formatPitchRange(92.0, 108.0), AbstractPitchFactorControl.formatPitchRange(90.0, 110.0), AbstractPitchFactorControl.formatPitchRange(84.0, 116.0), AbstractPitchFactorControl.formatPitchRange(68.0, 132.0), AbstractPitchFactorControl.formatPitchRange(50.0, 150.0), AbstractPitchFactorControl.formatPitchRange(36.0, 164.0), AbstractPitchFactorControl.formatPitchRange(0.0, 200.0), AbstractPitchFactorControl.formatPitchRange(-100.0, 100.0), AbstractPitchFactorControl.formatPitchRange(-200.0, 200.0)};
    private static final double MIN_PITCH_FACTOR = -10.0;
    private static final double MAX_PITCH_FACTOR = 10.0;

    public AbstractPitchFactorControl() {
        this.setMinimum(-10.0);
        this.setMaximum(10.0);
    }

    public void setPitchRange(double pitchMin, double pitchMax) {
        this.setMinimum(pitchMin);
        this.setMaximum(pitchMax);
        this.adjustPitchValue();
    }

    protected void adjustPitchValue() {
        double value = this.getDouble();
        double pitchMin = this.getMinimum();
        double pitchMax = this.getMaximum();
        double min = Math.min(pitchMin, pitchMax);
        double max = Math.max(pitchMin, pitchMax);
        if (value < min) {
            value = min;
            this.setDouble(value);
        } else if (value > max) {
            value = max;
            this.setDouble(value);
        } else {
            this.fireControlChanged();
        }
    }

    public static final String[] getCommonPitchRanges() {
        String[] arr = new String[COMMON_PITCH_RANGES.length];
        System.arraycopy(COMMON_PITCH_RANGES, 0, arr, 0, arr.length);
        return arr;
    }

    public static final String formatPitchRange(double pitchMin, double pitchMax) {
        String sMax;
        String sMin = "" + pitchMin;
        if (sMin.endsWith(".0")) {
            sMin = sMin.substring(0, sMin.length() - 2);
        }
        if ((sMax = "" + pitchMax).endsWith(".0")) {
            sMax = sMax.substring(0, sMax.length() - 2);
        }
        return sMin + "/" + sMax;
    }

    public static final double[] parsePitchRange(String range) throws NumberFormatException {
        if (range == null) {
            return null;
        }
        int x = range.indexOf(47);
        if (x < 0) {
            return null;
        }
        String sMin = range.substring(0, x).trim();
        String sMax = range.substring(x + 1).trim();
        double pitchMin = Double.parseDouble(sMin);
        double pitchMax = Double.parseDouble(sMax);
        return new double[]{pitchMin, pitchMax};
    }
}

