/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.media.control.AbstractEnumControl;
import com.waxmonster.waxlab.PitchModeControl;

public abstract class AbstractPitchModeControl
extends AbstractEnumControl
implements PitchModeControl {
    private static final String[] PITCH_MODES = new String[]{"Normal", "Custom", "Deck", "BPM"};

    public AbstractPitchModeControl() {
        this.setValues(AbstractPitchModeControl.getPitchModes());
    }

    public static String[] getPitchModes() {
        String[] arr = new String[PITCH_MODES.length];
        System.arraycopy(PITCH_MODES, 0, arr, 0, arr.length);
        return arr;
    }

    public static String getPrevPitchMode(Object value) {
        for (int i = 0; i < PITCH_MODES.length; ++i) {
            if (!PITCH_MODES[i].equals(value)) continue;
            return i > 0 ? PITCH_MODES[i - 1] : PITCH_MODES[PITCH_MODES.length - 1];
        }
        return "Normal";
    }

    public static String getNextPitchMode(Object value) {
        for (int i = 0; i < PITCH_MODES.length; ++i) {
            if (!PITCH_MODES[i].equals(value)) continue;
            return i < PITCH_MODES.length - 1 ? PITCH_MODES[i + 1] : PITCH_MODES[0];
        }
        return "Normal";
    }

    public static int getScratchPlayerPitchMode(String pitchMode) {
        if ("Normal".equalsIgnoreCase(pitchMode)) {
            return 0;
        }
        if ("Custom".equalsIgnoreCase(pitchMode)) {
            return 1;
        }
        if ("BPM".equalsIgnoreCase(pitchMode)) {
            return 2;
        }
        if ("Deck".equalsIgnoreCase(pitchMode)) {
            return 3;
        }
        return 1;
    }

    public static String getPitchModeString(int scratchPlayerPitchMode) {
        switch (scratchPlayerPitchMode) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Custom";
            }
            case 2: {
                return "BPM";
            }
            case 3: {
                return "Deck";
            }
        }
        return "Custom";
    }

    public int getPitchMode() {
        return this.getPitchMode(this.getValue());
    }

    public int getPitchMode(Object v) {
        String modeName = String.valueOf(v);
        return AbstractPitchModeControl.getScratchPlayerPitchMode(modeName);
    }
}

