/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Resource;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.media.AbstractMediaPlayer;
import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.EntryOrder;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.control.Control;
import com.waxmonster.midi.AbstractMidiAction;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiTrigger;
import com.waxmonster.midi.common.AbstractButtonMidiAction;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.waxlab.PitchFactorControl;
import com.waxmonster.waxlab.PitchModeControl;
import com.waxmonster.waxlab.PitchTuneControl;
import com.waxmonster.waxlab.ScratchDeck;
import com.waxmonster.waxlab.ScratchLine;
import com.waxmonster.waxlab.ScratchModeControl;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractPitchModeControl;
import com.waxmonster.waxlab.impl.AbstractScratchModeControl;
import com.waxmonster.waxlab.impl.ScratchManager;
import com.waxmonster.waxlab.impl.ScratchManagerImpl;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabImpl;
import com.waxmonster.waxlab.impl.WaxLabLiveFeederResource;
import com.waxmonster.waxlab.impl.WaxLabPitchDeck;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;
import com.waxmonster.waxlab.impl.WaxLabScratchDeckMediator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiMessage;
import javax.swing.Icon;

public abstract class AbstractScratchLine
extends AbstractLine
implements ScratchLine {
    private static final Logger logger = Logger.getLogger(AbstractScratchLine.class.getName());
    public static final int LOOP_ROLL_COUNT = 5;
    public static final int AUTO_LOOP_COUNT = 6;
    public static final double SPIN_NORMAL = 1.0;
    public static final double SPIN_FORWARD = 2.0;
    public static final double SPIN_BACKWARD = -2.0;
    private final WaxLabPitchDeck pitchDeck = new WaxLabPitchDeck(this.getName());
    protected String playerNamePrefix;
    protected WaxLabAudioSyncGroup audioSyncGroup;
    protected ScratchManager scratchManager;
    protected WaxLabScratchDeck scratchDeck;
    protected Control[] scratchControls;
    protected Resource scratchAudioResource;
    protected MediaEntry scratchMediaEntry;
    protected MediaPlayerImpl mediaPlayer = new MediaPlayerImpl();
    protected MediaPlayerContext mediaPlayerContext;
    protected double timecodeScrollPosition;
    protected long doubleClickMaxMillis = 500L;
    protected EntryOrder entryOrder;
    protected EntryOrder normalEntryOrder;
    protected EntryOrder shuffleEntryOrder;
    protected boolean shuffleMode;
    protected boolean spinForward;
    protected boolean spinBackward;

    public AbstractScratchLine(ReadWriteLock lock) {
        super(lock);
    }

    @Override
    public synchronized void setName(String name) {
        super.setName(name);
        this.adjustPlayerName();
        this.pitchDeck.setName(name);
    }

    public synchronized ScratchManager getScratchManager() {
        if (this.scratchManager == null) {
            this.setScratchManager(this.createScratchManager());
        }
        return this.scratchManager;
    }

    protected synchronized void setScratchManager(ScratchManager scratchManager) {
        this.scratchManager = scratchManager;
    }

    protected ScratchManager createScratchManager() {
        ScratchManagerImpl manager = new ScratchManagerImpl(this);
        return manager;
    }

    public ScratchDeck getScratchDeck() {
        return this.getWaxLabScratchDeck();
    }

    protected synchronized WaxLabScratchDeck getWaxLabScratchDeck() {
        if (this.scratchDeck == null) {
            this.setWaxLabScratchDeck(this.createWaxLabScratchDeck());
        }
        return this.scratchDeck;
    }

    protected WaxLabScratchDeck createWaxLabScratchDeck() {
        WaxLabImpl waxLab = this.getWaxLabImpl();
        WaxLabDevice device = waxLab.getWaxLabDevice();
        WaxLabScratchDeckMediator deckMediator = WaxLabScratchDeckMediator.getInstance();
        Clock clock = device.getClock();
        LockSupport lockSupport = waxLab.getLockSupport();
        LockFactory lockFactory = waxLab.getLockFactory();
        ThreadManager threadManager = device.getThreadManager();
        WaxLabScratchDeck deck = new WaxLabScratchDeck(device, this, deckMediator, clock, lockSupport, lockFactory, threadManager);
        return deck;
    }

    protected synchronized void setWaxLabScratchDeck(WaxLabScratchDeck scratchDeck) {
        this.scratchDeck = scratchDeck;
        this.pitchDeck.setScratchDeck(scratchDeck);
        scratchDeck.refreshMidiMappings();
        scratchDeck.refreshMidiTriggers();
        Control[] oldControls = this.scratchControls;
        Control[] newControls = null;
        if (scratchDeck != null) {
            newControls = scratchDeck.getScratchControls();
        }
        this.scratchControls = newControls;
        if (oldControls != null) {
            int num = oldControls.length;
            for (int i = num - 1; i >= 0; --i) {
                Control control = oldControls[i];
                if (control == null) continue;
                this.removeLineControl(control);
            }
        }
        if (newControls != null) {
            for (Control control : newControls) {
                if (control == null) continue;
                this.addLineControl(control);
            }
        }
    }

    public PitchDeck getPitchDeck() {
        return this.pitchDeck;
    }

    public WaxLabPitchDeck getWaxLabPitchDeck() {
        return this.pitchDeck;
    }

    public Resource getScratchAudioResource() {
        return this.scratchAudioResource;
    }

    public MediaEntry getScratchMediaEntry() {
        return this.scratchMediaEntry;
    }

    public synchronized void setScratchResource(Resource resource, MediaEntry mediaEntry) {
        if (resource == null && mediaEntry != null) {
            resource = mediaEntry.getResource();
        }
        this.scratchAudioResource = resource;
        this.scratchMediaEntry = mediaEntry;
    }

    public MediaEntry loadScratchResource(Resource resource, MediaEntry mediaEntry) {
        if (resource == null && mediaEntry != null) {
            resource = mediaEntry.getResource();
        }
        WaxLabScratchDeck scratchDeck = this.scratchDeck;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("loadScratchResource: line=" + this + ", resource=" + resource + ", entry=" + mediaEntry + ", scratchDeck=" + scratchDeck);
        }
        if (scratchDeck != null) {
            MediaEntry loadedEntry = null;
            try {
                loadedEntry = scratchDeck.loadScratchResource(resource, mediaEntry);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (loadedEntry != null) {
                this.scratchMediaEntry = mediaEntry = loadedEntry;
            }
        }
        return mediaEntry;
    }

    public MediaMarker createMediaMarker() {
        WaxLabScratchDeck scratchDeck = this.scratchDeck;
        if (scratchDeck != null) {
            AudioScratchPlayer asp = scratchDeck.getScratchPlayer();
            AudioScratchModel asm = scratchDeck.getScratchModel();
            double position = asp.getOffset() - asm.getAnchor();
            if (!Double.isNaN(position)) {
                int type = 3;
                int index = -1;
                String name = null;
                return new DefaultMediaMarker(type, index, position, name);
            }
        }
        return null;
    }

    protected WaxLabAudioSyncGroup getAudioSyncGroup() {
        return this.audioSyncGroup;
    }

    protected void setAudioSyncGroup(WaxLabAudioSyncGroup audioSyncGroup) {
        this.audioSyncGroup = audioSyncGroup;
    }

    public double getTimecodeScrollPosition() {
        return this.timecodeScrollPosition;
    }

    public void setTimecodeScrollPosition(double timecodeScrollPosition) {
        this.timecodeScrollPosition = timecodeScrollPosition;
    }

    public long getDoubleClickMaxMillis() {
        return this.doubleClickMaxMillis;
    }

    public void setDoubleClickMaxMillis(long doubleClickMaxMillis) {
        this.doubleClickMaxMillis = doubleClickMaxMillis;
    }

    protected MediaPlayerContext getMediaPlayerContext() {
        return this.mediaPlayerContext;
    }

    protected synchronized void setMediaPlayerContext(MediaPlayerContext mediaPlayerContext) {
        if (this.mediaPlayerContext == mediaPlayerContext) {
            return;
        }
        this.mediaPlayerContext = mediaPlayerContext;
        if (mediaPlayerContext != null) {
            this.normalEntryOrder = mediaPlayerContext.createNormalEntryOrder();
            this.shuffleEntryOrder = null;
            this.entryOrder = this.shuffleMode ? (this.shuffleEntryOrder = mediaPlayerContext.createShuffledEntryOrder()) : this.normalEntryOrder;
        } else {
            this.normalEntryOrder = null;
            this.shuffleEntryOrder = null;
            this.entryOrder = null;
        }
    }

    public boolean isShuffleMode() {
        return this.shuffleMode;
    }

    public synchronized void setShuffleMode(boolean shuffleMode) {
        if (this.shuffleMode == shuffleMode) {
            return;
        }
        this.shuffleMode = shuffleMode;
        MediaCrateEntry currentEntry = null;
        int currentIndex = -1;
        if (this.entryOrder != null) {
            currentEntry = this.entryOrder.getCurrentEntry();
            currentIndex = this.entryOrder.getCurrentIndex();
        }
        if (shuffleMode) {
            MediaPlayerContext mpc;
            if (this.shuffleEntryOrder == null && (mpc = this.mediaPlayerContext) != null) {
                this.shuffleEntryOrder = mpc.createShuffledEntryOrder();
            }
            this.entryOrder = this.shuffleEntryOrder;
        } else {
            this.entryOrder = this.normalEntryOrder;
        }
        if (this.entryOrder != null) {
            this.entryOrder.setCurrentEntry(currentEntry);
            this.entryOrder.setCurrentIndex(currentIndex);
        }
    }

    public synchronized boolean skipPrevEntry() {
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc == null) {
            return false;
        }
        EntryOrder order = this.entryOrder;
        if (order == null) {
            return false;
        }
        MediaCrateEntry mce = order.skipPrevEntry();
        if (mce == null) {
            return false;
        }
        int index = order.getCurrentIndex();
        MediaEntry me = mpc.getMediaEntry(mce);
        if (me == null) {
            return false;
        }
        this.setScratchResource(null, me);
        this.loadScratchResource(null, me);
        mpc.playerEntryChanged((MediaPlayer)this.mediaPlayer, mce, index);
        return true;
    }

    public synchronized boolean skipNextEntry() {
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc == null) {
            return false;
        }
        EntryOrder order = this.entryOrder;
        if (order == null) {
            return false;
        }
        MediaCrateEntry mce = order.skipNextEntry();
        if (mce == null) {
            return false;
        }
        int index = order.getCurrentIndex();
        MediaEntry me = mpc.getMediaEntry(mce);
        if (me == null) {
            return false;
        }
        this.setScratchResource(null, me);
        this.loadScratchResource(null, me);
        mpc.playerEntryChanged((MediaPlayer)this.mediaPlayer, mce, index);
        return true;
    }

    public synchronized boolean startLiveFeed() {
        WaxLabPortInfo[] liveFeedPorts;
        boolean liveFeedAvailable = false;
        ScratchManager scratchManager = this.getScratchManager();
        if (scratchManager != null && (liveFeedPorts = scratchManager.getAudioLiveFeedPorts()) != null) {
            for (int i = 0; i < liveFeedPorts.length; ++i) {
                if (liveFeedPorts[i] == null) continue;
                liveFeedAvailable = true;
                break;
            }
        }
        if (!liveFeedAvailable) {
            return false;
        }
        WaxLabLiveFeederResource liveFeedResource = new WaxLabLiveFeederResource();
        MediaEntry me = null;
        this.setScratchResource(liveFeedResource, me);
        this.loadScratchResource(liveFeedResource, me);
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc != null) {
            MediaCrateEntry mce = null;
            mpc.playerEntryChanged((MediaPlayer)this.mediaPlayer, mce, -1);
        }
        return true;
    }

    public boolean navigateCrateTree() {
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc == null) {
            return false;
        }
        return mpc.navigateCrateTree((MediaPlayer)this.mediaPlayer);
    }

    public boolean navigatePlayList() {
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc == null) {
            return false;
        }
        return mpc.navigatePlayList((MediaPlayer)this.mediaPlayer);
    }

    public boolean navigateMove(int amount) {
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc == null) {
            return false;
        }
        return mpc.navigateMove((MediaPlayer)this.mediaPlayer, amount);
    }

    public boolean navigatePush() {
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc == null) {
            return false;
        }
        return mpc.navigatePush((MediaPlayer)this.mediaPlayer);
    }

    public boolean navigateBack() {
        MediaPlayerContext mpc = this.mediaPlayerContext;
        if (mpc == null) {
            return false;
        }
        return mpc.navigateBack((MediaPlayer)this.mediaPlayer);
    }

    @Override
    public MediaPlayer[] getMediaPlayers() {
        return new MediaPlayer[]{this.mediaPlayer};
    }

    public String getPlayerNamePrefix() {
        return this.playerNamePrefix;
    }

    public void setPlayerNamePrefix(String playerNamePrefix) {
        this.playerNamePrefix = playerNamePrefix;
        this.adjustPlayerName();
    }

    protected void adjustPlayerName() {
        this.mediaPlayer.setPlayerName(String.valueOf(this.playerNamePrefix) + String.valueOf(this.getName()));
    }

    protected void applySpinFactor() {
        WaxLabScratchDeck deck = this.scratchDeck;
        if (deck != null) {
            double spin = this.spinForward ? (this.spinBackward ? 1.0 : 2.0) : (this.spinBackward ? -2.0 : 1.0);
            deck.setSpin(spin);
        }
    }

    @Override
    protected synchronized void setMidiActions(MidiAction[] midiActions) {
        super.setMidiActions(midiActions);
        WaxLabScratchDeck deck = this.scratchDeck;
        if (deck != null) {
            deck.refreshMidiMappings();
        }
    }

    @Override
    public synchronized void setMidiMappings(MidiMapping[] midiMappings) {
        super.setMidiMappings(midiMappings);
        WaxLabScratchDeck deck = this.scratchDeck;
        if (deck != null) {
            deck.refreshMidiMappings();
        }
    }

    @Override
    protected synchronized void setMidiEvents(String[] midiEvents) {
        super.setMidiEvents(midiEvents);
        WaxLabScratchDeck deck = this.scratchDeck;
        if (deck != null) {
            deck.refreshMidiTriggers();
        }
    }

    @Override
    public synchronized void setMidiTriggers(MidiTrigger[] midiTriggers) {
        super.setMidiTriggers(midiTriggers);
        WaxLabScratchDeck deck = this.scratchDeck;
        if (deck != null) {
            deck.refreshMidiTriggers();
        }
    }

    protected class RefreshDeckLightingAction
    extends AbstractMidiAction {
        public RefreshDeckLightingAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (data2 < 1) {
                return;
            }
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.refreshDeckLightings();
            }
        }

        public void systemExclusive(long time, MidiMessage mm) {
            super.systemExclusive(time, mm);
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.refreshDeckLightings();
            }
        }
    }

    protected class BeatSliceHalfAction
    extends AbstractButtonMidiAction {
        public BeatSliceHalfAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getBeatSliceControl().setHalfBeatSlice();
            }
        }
    }

    protected class BeatSliceDoubleAction
    extends AbstractButtonMidiAction {
        public BeatSliceDoubleAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getBeatSliceControl().setDoubleBeatSlice();
            }
        }
    }

    protected class BeatSliceControlAction
    extends AbstractButtonMidiAction {
        private final double beats;

        public BeatSliceControlAction(String name, double beats) {
            super(name);
            this.beats = beats;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getBeatSliceControl().setDouble(this.beats);
            }
        }
    }

    protected class BeatSlicerJumpAction
    extends AbstractButtonMidiAction {
        protected final int sliceIndex;

        public BeatSlicerJumpAction(String name, int sliceIndex) {
            super(name);
            this.sliceIndex = sliceIndex;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.beatSliceTriggered(this.sliceIndex);
            }
        }

        public void buttonReleased(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.beatSliceReleased(this.sliceIndex);
            }
        }
    }

    protected class BeatSlicerLoopModeToggleAction
    extends AbstractButtonMidiAction {
        public BeatSlicerLoopModeToggleAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.setBeatSlicerLoopMode(!deck.isBeatSlicerLoopMode());
            }
        }
    }

    protected class BeatSlicerToggleAction
    extends AbstractButtonMidiAction {
        public BeatSlicerToggleAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                if (deck.isBeatSlicerActive()) {
                    deck.stopBeatSlicer();
                } else {
                    deck.startBeatSlicer();
                }
            }
        }
    }

    protected class BeatSlicerStopAction
    extends AbstractButtonMidiAction {
        public BeatSlicerStopAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.stopBeatSlicer();
            }
        }
    }

    protected class BeatSlicerStartAction
    extends AbstractButtonMidiAction {
        public BeatSlicerStartAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.startBeatSlicer();
            }
        }
    }

    protected class AutoLoopAction
    extends AbstractButtonMidiAction {
        protected final int autoLoopIndex;

        public AutoLoopAction(String name, int autoLoopIndex) {
            super(name);
            this.autoLoopIndex = autoLoopIndex;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.toggleAutoLoop(this.autoLoopIndex);
            }
        }
    }

    protected class LoopRollAction
    extends AbstractButtonMidiAction {
        protected final int loopRollIndex;

        public LoopRollAction(String name, int loopRollIndex) {
            super(name);
            this.loopRollIndex = loopRollIndex;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.startLoopRoll(this.loopRollIndex);
            }
        }

        public void buttonReleased(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.stopLoopRoll(this.loopRollIndex);
            }
        }
    }

    protected class BeatJumpControlAction
    extends AbstractButtonMidiAction {
        protected final double beats;

        public BeatJumpControlAction(String name, double beats) {
            super(name);
            this.beats = beats;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getBeatJumpControl().setDouble(this.beats);
            }
        }
    }

    protected class BeatJumpHalfAction
    extends AbstractButtonMidiAction {
        public BeatJumpHalfAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getBeatJumpControl().setHalfBeatJump();
            }
        }
    }

    protected class BeatJumpDoubleAction
    extends AbstractButtonMidiAction {
        public BeatJumpDoubleAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getBeatJumpControl().setDoubleBeatJump();
            }
        }
    }

    protected class BeatJumpBackwardAction
    extends AbstractButtonMidiAction {
        public BeatJumpBackwardAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.beatJumpBackward();
            }
        }
    }

    protected class BeatJumpForwardAction
    extends AbstractButtonMidiAction {
        public BeatJumpForwardAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                if (deck.isLiveFeed() && deck.jumpLiveFeedHead()) {
                    return;
                }
                deck.beatJumpForward();
            }
        }
    }

    protected class InstantDoubleAction
    extends AbstractButtonMidiAction {
        private final boolean doubleClick;
        private long lastClickTime;
        private int clickCount;

        public InstantDoubleAction(String name, boolean doubleClick) {
            super(name);
            this.lastClickTime = Long.MIN_VALUE;
            this.clickCount = 0;
            this.doubleClick = doubleClick;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck;
            if (this.doubleClick) {
                long clickTime = System.currentTimeMillis();
                long clickInterval = clickTime - this.lastClickTime;
                this.lastClickTime = clickTime;
                if (clickInterval > AbstractScratchLine.this.doubleClickMaxMillis) {
                    this.clickCount = 1;
                    return;
                }
                ++this.clickCount;
                if (this.clickCount != 2) {
                    return;
                }
            }
            if ((deck = AbstractScratchLine.this.scratchDeck) != null) {
                deck.instantDouble();
            }
        }
    }

    protected class ShuffleModeOffAction
    extends AbstractButtonMidiAction {
        public ShuffleModeOffAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.setShuffleMode(false);
        }
    }

    protected class ShuffleModeOnAction
    extends AbstractButtonMidiAction {
        public ShuffleModeOnAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.setShuffleMode(true);
        }
    }

    protected class ToggleShuffleModeAction
    extends AbstractButtonMidiAction {
        public ToggleShuffleModeAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.setShuffleMode(!AbstractScratchLine.this.isShuffleMode());
        }
    }

    protected class NavigateBackAction
    extends AbstractButtonMidiAction {
        public NavigateBackAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.navigateBack();
        }
    }

    protected class NavigatePushAction
    extends AbstractButtonMidiAction {
        public NavigatePushAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.navigatePush();
        }
    }

    protected class NavigateMoveAction
    extends AbstractMidiAction {
        public NavigateMoveAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if ((status & 0xF0) != 176) {
                return;
            }
            if (data2 > 64) {
                AbstractScratchLine.this.navigateMove(1);
            } else if (data2 < 64) {
                AbstractScratchLine.this.navigateMove(-1);
            }
        }
    }

    protected class NavigatePlayList
    extends AbstractButtonMidiAction {
        public NavigatePlayList(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.navigatePlayList();
        }
    }

    protected class NavigateCrateTree
    extends AbstractButtonMidiAction {
        public NavigateCrateTree(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.navigateCrateTree();
        }
    }

    protected class SkipNextEntryAction
    extends AbstractButtonMidiAction {
        ShiftAction shiftInstantDoubleAction;
        ShiftAction shiftLiveFeedAction;

        public SkipNextEntryAction(String name, ShiftAction shiftInstantDoubleAction, ShiftAction shiftLiveFeedAction) {
            super(name);
            this.shiftInstantDoubleAction = shiftInstantDoubleAction;
            this.shiftLiveFeedAction = shiftLiveFeedAction;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                if (this.shiftInstantDoubleAction != null && this.shiftInstantDoubleAction.isShiftPressed()) {
                    deck.instantDouble();
                    return;
                }
                if (this.shiftLiveFeedAction != null && this.shiftLiveFeedAction.isShiftPressed()) {
                    AbstractScratchLine.this.startLiveFeed();
                    return;
                }
            }
            AbstractScratchLine.this.skipNextEntry();
        }
    }

    protected class SkipPrevEntryAction
    extends AbstractButtonMidiAction {
        public SkipPrevEntryAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.skipPrevEntry();
        }
    }

    protected class JumpLiveFeedHeadAction
    extends AbstractButtonMidiAction {
        public JumpLiveFeedHeadAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.jumpLiveFeedHead();
            }
        }
    }

    protected class RemoveCuePointAction
    extends AbstractButtonMidiAction {
        protected final int cuePointIndex;

        public RemoveCuePointAction(String name, int cuePointIndex) {
            super(name);
            this.cuePointIndex = cuePointIndex;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.removeCuePoint(this.cuePointIndex);
            }
        }
    }

    protected class JumpOrSetOrRemoveCuePointAction
    extends AbstractButtonMidiAction {
        protected final int cuePointIndex;
        protected final ShiftAction shiftRemoveCuePointAction;

        public JumpOrSetOrRemoveCuePointAction(String name, int cuePointIndex, ShiftAction shiftRemoveCuePointAction) {
            super(name);
            this.cuePointIndex = cuePointIndex;
            this.shiftRemoveCuePointAction = shiftRemoveCuePointAction;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                if (this.shiftRemoveCuePointAction != null && this.shiftRemoveCuePointAction.isShiftPressed()) {
                    deck.removeCuePoint(this.cuePointIndex);
                } else {
                    deck.jumpOrSetCuePoint(this.cuePointIndex);
                }
            }
        }

        public void buttonReleased(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.cuePointReleased(this.cuePointIndex);
            }
        }
    }

    protected class JumpOrSetCuePointAction
    extends AbstractButtonMidiAction {
        protected final int cuePointIndex;

        public JumpOrSetCuePointAction(String name, int cuePointIndex) {
            super(name);
            this.cuePointIndex = cuePointIndex;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.jumpOrSetCuePoint(this.cuePointIndex);
            }
        }

        public void buttonReleased(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.cuePointReleased(this.cuePointIndex);
            }
        }
    }

    protected class SetCuePointAction
    extends AbstractButtonMidiAction {
        protected final int cuePointIndex;

        public SetCuePointAction(String name, int cuePointIndex) {
            super(name);
            this.cuePointIndex = cuePointIndex;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.setCuePointPosition(this.cuePointIndex);
            }
        }
    }

    protected class JumpCuePointAction
    extends AbstractButtonMidiAction {
        protected final int cuePointIndex;

        public JumpCuePointAction(String name, int cuePointIndex) {
            super(name);
            this.cuePointIndex = cuePointIndex;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.jumpCuePoint(this.cuePointIndex);
            }
        }

        public void buttonReleased(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.cuePointReleased(this.cuePointIndex);
            }
        }
    }

    protected class ShiftAction
    extends AbstractMidiAction {
        private boolean shiftPressed;
        private int shiftNote;

        public ShiftAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (data2 > 0) {
                if (!this.shiftPressed) {
                    this.shiftNote = data1;
                    this.shiftPressed = true;
                }
            } else if (this.shiftPressed && data1 == this.shiftNote) {
                this.shiftPressed = false;
            }
        }

        public boolean isShiftPressed() {
            return this.shiftPressed;
        }

        protected void setShiftPressed(boolean shiftPressed) {
            this.shiftPressed = shiftPressed;
        }
    }

    protected class CensorAction
    extends AbstractButtonMidiAction {
        private ShiftAction shiftCensorGoofyAction;

        public CensorAction(String name, ShiftAction shiftCensorGoofyAction) {
            super(name);
            this.shiftCensorGoofyAction = shiftCensorGoofyAction;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                if (deck.isGoofyMode()) {
                    deck.setGoofyMode(false);
                    return;
                }
                if (this.shiftCensorGoofyAction != null && this.shiftCensorGoofyAction.isShiftPressed()) {
                    deck.setGoofyMode(true);
                    return;
                }
                deck.setCensor(true);
            }
        }

        public void buttonReleased(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                if (deck.isGoofyMode()) {
                    return;
                }
                deck.setCensor(false);
            }
        }
    }

    protected class SpinBackwardAction
    extends AbstractButtonMidiAction {
        public SpinBackwardAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.spinBackward = true;
            AbstractScratchLine.this.applySpinFactor();
        }

        public void buttonReleased(long time) {
            AbstractScratchLine.this.spinBackward = false;
            AbstractScratchLine.this.applySpinFactor();
        }
    }

    protected class SpinForwardAction
    extends AbstractButtonMidiAction {
        public SpinForwardAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            AbstractScratchLine.this.spinForward = true;
            AbstractScratchLine.this.applySpinFactor();
        }

        public void buttonReleased(long time) {
            AbstractScratchLine.this.spinForward = false;
            AbstractScratchLine.this.applySpinFactor();
        }
    }

    protected class ToggleSlipModeAction
    extends AbstractButtonMidiAction {
        public ToggleSlipModeAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.setSlipMode(!deck.isSlipMode());
            }
        }
    }

    protected class PitchTuneControlAction
    extends AbstractMidiAction {
        public PitchTuneControlAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if ((status & 0xF0) != 176) {
                return;
            }
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck == null) {
                return;
            }
            PitchTuneControl control = deck.getPitchTuneControl();
            if (control == null) {
                return;
            }
            double min = control.getMinimum();
            double max = control.getMaximum();
            if (data2 < 0) {
                data2 = 0;
            } else if (data2 > 127) {
                data2 = 127;
            }
            double tune = min + (max - min) * (double)data2 / 128.0;
            control.setDouble(tune);
        }
    }

    protected class PitchFactorControlAction
    extends AbstractMidiAction {
        public PitchFactorControlAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if ((status & 0xF0) != 176) {
                return;
            }
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck == null) {
                return;
            }
            PitchFactorControl control = deck.getPitchFactorControl();
            if (control == null) {
                return;
            }
            double min = control.getMinimum();
            double max = control.getMaximum();
            if (data2 < 0) {
                data2 = 0;
            } else if (data2 > 127) {
                data2 = 127;
            }
            double pitch = min + (max - min) * (double)data2 / 127.0;
            control.setDouble(pitch);
        }
    }

    protected class PitchModeNextAction
    extends AbstractButtonMidiAction {
        private ShiftAction shiftPitchModeAction;

        public PitchModeNextAction(String name, ShiftAction shiftPitchModeAction) {
            super(name);
            this.shiftPitchModeAction = shiftPitchModeAction;
        }

        public void buttonPressed(long time) {
            PitchModeControl pitchModeControl;
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null && (pitchModeControl = deck.getPitchModeControl()) != null) {
                if (this.shiftPitchModeAction != null && this.shiftPitchModeAction.isShiftPressed()) {
                    String prevPitchMode = AbstractPitchModeControl.getPrevPitchMode(pitchModeControl.getValue());
                    pitchModeControl.setValue((Object)prevPitchMode);
                } else {
                    String nextPitchMode = AbstractPitchModeControl.getNextPitchMode(pitchModeControl.getValue());
                    pitchModeControl.setValue((Object)nextPitchMode);
                }
            }
        }
    }

    protected class PitchModePrevAction
    extends AbstractButtonMidiAction {
        public PitchModePrevAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            PitchModeControl pitchModeControl;
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null && (pitchModeControl = deck.getPitchModeControl()) != null) {
                String prevPitchMode = AbstractPitchModeControl.getPrevPitchMode(pitchModeControl.getValue());
                pitchModeControl.setValue((Object)prevPitchMode);
            }
        }
    }

    protected class PitchModeAction
    extends AbstractButtonMidiAction {
        protected final String pitchMode;

        public PitchModeAction(String name, String pitchMode) {
            super(name);
            this.pitchMode = pitchMode;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getPitchModeControl().setValue((Object)this.pitchMode);
            }
        }
    }

    protected class ScratchModeNextAction
    extends AbstractButtonMidiAction {
        private ShiftAction shiftScratchModeAction;

        public ScratchModeNextAction(String name, ShiftAction shiftScratchModeAction) {
            super(name);
            this.shiftScratchModeAction = shiftScratchModeAction;
        }

        public void buttonPressed(long time) {
            ScratchModeControl scratchModeControl;
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null && (scratchModeControl = deck.getScratchModeControl()) != null) {
                if (this.shiftScratchModeAction != null && this.shiftScratchModeAction.isShiftPressed()) {
                    String prevScratchMode = AbstractScratchModeControl.getPrevScratchMode(scratchModeControl.getValue());
                    scratchModeControl.setValue((Object)prevScratchMode);
                } else {
                    String nextScratchMode = AbstractScratchModeControl.getNextScratchMode(scratchModeControl.getValue());
                    scratchModeControl.setValue((Object)nextScratchMode);
                }
            }
        }
    }

    protected class ScratchModePrevAction
    extends AbstractButtonMidiAction {
        public ScratchModePrevAction(String name) {
            super(name);
        }

        public void buttonPressed(long time) {
            ScratchModeControl scratchModeControl;
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null && (scratchModeControl = deck.getScratchModeControl()) != null) {
                String prevScratchMode = AbstractScratchModeControl.getPrevScratchMode(scratchModeControl.getValue());
                scratchModeControl.setValue((Object)prevScratchMode);
            }
        }
    }

    protected class ScratchModeAction
    extends AbstractButtonMidiAction {
        protected final String scratchMode;

        public ScratchModeAction(String name, String scratchMode) {
            super(name);
            this.scratchMode = scratchMode;
        }

        public void buttonPressed(long time) {
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getScratchModeControl().setValue((Object)this.scratchMode);
            }
        }
    }

    protected class PreFaderVolumeControlAction
    extends AbstractMidiAction {
        public PreFaderVolumeControlAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if ((status & 0xF0) != 176) {
                return;
            }
            if (data2 < 0) {
                data2 = 0;
            } else if (data2 > 127) {
                data2 = 127;
            }
            double volume = (double)data2 / 127.0;
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getPreFaderVolumeControl().setDouble(volume);
            }
        }
    }

    protected class PostFaderVolumeControlAction
    extends AbstractMidiAction {
        public PostFaderVolumeControlAction(String name) {
            super(name);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if ((status & 0xF0) != 176) {
                return;
            }
            if (data2 < 0) {
                data2 = 0;
            } else if (data2 > 127) {
                data2 = 127;
            }
            double volume = (double)data2 / 127.0;
            WaxLabScratchDeck deck = AbstractScratchLine.this.scratchDeck;
            if (deck != null) {
                deck.getPostFaderVolumeControl().setDouble(volume);
            }
        }
    }

    protected class MediaPlayerImpl
    extends AbstractMediaPlayer
    implements MediaPlayer {
        private String playerName;
        private Icon playerIcon16 = Tools.getIcon(((Object)((Object)this)).getClass(), (String)"/com/waxmonster/waxlab/impl/icons/wax_studio_icon16.png");

        public String getPlayerName() {
            return this.playerName;
        }

        protected void setPlayerName(String playerName) {
            this.playerName = playerName;
        }

        public Icon getPlayerIcon(int iconKind) {
            return this.playerIcon16;
        }

        public void setCurrentEntry(MediaCrateEntry entry, MediaPlayerContext context, int index) {
            EntryOrder order;
            MediaEntry mediaEntry = null;
            if (context != null) {
                mediaEntry = context.getMediaEntry(entry);
            }
            AbstractScratchLine.this.setMediaPlayerContext(context);
            WaxLabScratchDeck deck = AbstractScratchLine.this.getWaxLabScratchDeck();
            if (deck != null) {
                deck.setPlayerContext(context);
            }
            if ((order = AbstractScratchLine.this.entryOrder) != null) {
                order.setCurrentEntry(entry);
                order.setCurrentIndex(index);
            }
            AbstractScratchLine.this.setScratchResource(null, mediaEntry);
            AbstractScratchLine.this.loadScratchResource(null, mediaEntry);
            if (context != null) {
                context.playerEntryChanged((MediaPlayer)this, entry, index);
            }
        }

        public MediaMarker createMediaMarker() {
            return AbstractScratchLine.this.createMediaMarker();
        }
    }
}

