/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.media.control.AbstractEnumControl;
import com.waxmonster.waxlab.ScratchModeControl;

public abstract class AbstractScratchModeControl
extends AbstractEnumControl
implements ScratchModeControl {
    private static final String[] SCRATCH_MODES = new String[]{"Absolute", "Relative", "Splatter", "Ultimate", "Internal"};

    public AbstractScratchModeControl() {
        this.setValues(AbstractScratchModeControl.getScratchModes());
    }

    public static String[] getScratchModes() {
        String[] arr = new String[SCRATCH_MODES.length];
        System.arraycopy(SCRATCH_MODES, 0, arr, 0, arr.length);
        return arr;
    }

    public static String getPrevScratchMode(Object value) {
        for (int i = 0; i < SCRATCH_MODES.length; ++i) {
            if (!SCRATCH_MODES[i].equals(value)) continue;
            return i > 0 ? SCRATCH_MODES[i - 1] : SCRATCH_MODES[SCRATCH_MODES.length - 1];
        }
        return "Relative";
    }

    public static String getNextScratchMode(Object value) {
        for (int i = 0; i < SCRATCH_MODES.length; ++i) {
            if (!SCRATCH_MODES[i].equals(value)) continue;
            return i < SCRATCH_MODES.length - 1 ? SCRATCH_MODES[i + 1] : SCRATCH_MODES[0];
        }
        return "Relative";
    }

    public static int getTimecodeDecoderMode(String scratchMode) {
        if ("Absolute".equals(scratchMode)) {
            return 2;
        }
        if ("Relative".equals(scratchMode)) {
            return 1;
        }
        if ("Splatter".equals(scratchMode)) {
            return 3;
        }
        if ("Ultimate".equals(scratchMode)) {
            return 4;
        }
        if ("Internal".equals(scratchMode)) {
            return 0;
        }
        return -1;
    }

    public static String getScratchModeString(int timecodeDecoderMode) {
        switch (timecodeDecoderMode) {
            case 2: {
                return "Absolute";
            }
            case 1: {
                return "Relative";
            }
            case 3: {
                return "Splatter";
            }
            case 4: {
                return "Ultimate";
            }
            case 0: {
                return "Internal";
            }
        }
        return "Relative";
    }
}

