/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Platform;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockSupport;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.sound.CubicInterpolatedSampleModel;
import com.spacekiller.util.sound.DefaultSampleCursor;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.sound.SoundUtil;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.CachedTimecodeModel;
import com.waxmonster.model.impl.DefaultTimecodeChunk;
import com.waxmonster.model.impl.RealFaderModel;
import com.waxmonster.model.impl.RealTimecodeModel;
import com.waxmonster.model.impl.TimecodeFile;
import com.waxmonster.scratch.AudioScratchModel;
import com.waxmonster.scratch.AudioScratchPlayer;
import com.waxmonster.scratch.PitchDeck;
import com.waxmonster.scratch.TimecodeScratchModel;
import com.waxmonster.scratch.impl.AbstractAudioScratchPlayer;
import com.waxmonster.scratch.impl.CubicTimecodeScratchModel;
import com.waxmonster.scratch.impl.DefaultAudioScratchPlayer;
import com.waxmonster.studio.Port;
import com.waxmonster.waxlab.Line;
import com.waxmonster.waxlab.TimecodeLine;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.WaxLabPreferences;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.AbstractLineFeature;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.WaxLabAudioInputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioOutputPort;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabLiveFeeder;
import com.waxmonster.waxlab.impl.WaxLabMidiInputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiOutputPort;
import com.waxmonster.waxlab.impl.WaxLabMidiSyncGroup;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;
import com.waxmonster.waxlab.impl.WaxLabScratchDeckMediator;
import com.waxmonster.waxlab.old.WaxLabScratchCursorFader;
import com.waxmonster.waxlab.proc.WaxLabTimecodeRecorder;
import com.waxmonster.waxlab.util.LineWrapper;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public abstract class CommonLineFeature
extends AbstractLineFeature {
    private static final Logger logger = Platform.getLogger(CommonLineFeature.class);

    public CommonLineFeature(AbstractLine line, String name) {
        super(line, name);
    }

    protected static String buildFileNamePrefix(WaxLab waxLab, Line line, String timestampString) {
        String fileNamePrefix = String.valueOf(timestampString) + "_" + String.valueOf(waxLab.getName()) + "_" + String.valueOf(line.getName());
        return fileNamePrefix;
    }

    protected static boolean equalsPortArray(WaxLabPortInfo[] a, WaxLabPortInfo[] b) {
        int bLen;
        if (a == b) {
            return true;
        }
        int aLen = a == null ? 0 : a.length;
        int n = bLen = b == null ? 0 : b.length;
        if (aLen != bLen) {
            return false;
        }
        for (int i = 0; i < aLen; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected static boolean equalsPortArray(Port[] a, Port[] b) {
        int bLen;
        if (a == b) {
            return true;
        }
        int aLen = a == null ? 0 : a.length;
        int n = bLen = b == null ? 0 : b.length;
        if (aLen != bLen) {
            return false;
        }
        for (int i = 0; i < aLen; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected static AudioFormat createAudioFormat(int channels, float frameRate, int sampleType) throws AudioException {
        int sampleBits;
        AudioFormat.Encoding encoding;
        switch (sampleType) {
            case 1: {
                encoding = SoundUtil.PCM_SIGNED;
                sampleBits = 16;
                break;
            }
            case 2: {
                encoding = SoundUtil.PCM_SIGNED;
                sampleBits = 24;
                break;
            }
            case 3: {
                encoding = SoundUtil.PCM_SIGNED;
                sampleBits = 32;
                break;
            }
            case 4: {
                encoding = SoundUtil.PCM_FLOAT;
                sampleBits = 32;
                break;
            }
            case 5: {
                encoding = SoundUtil.PCM_FLOAT;
                sampleBits = 64;
                break;
            }
            default: {
                return null;
            }
        }
        int frameSize = (sampleBits + 7) / 8 * channels;
        boolean bigEndian = false;
        return new AudioFormat(encoding, frameRate, sampleBits, channels, frameSize, frameRate, bigEndian);
    }

    protected static WaxLabAudioOutputPort[] validateAudioOutputPorts(int frameType, WaxLabPortInfo[] infos) throws AudioException {
        if (infos == null) {
            return null;
        }
        int numPorts = infos.length;
        if (numPorts < 1) {
            return null;
        }
        switch (frameType) {
            case 1: {
                WaxLabAudioOutputPort wp;
                Port port;
                WaxLabPortInfo info = infos[0];
                Port port2 = port = info == null ? null : info.getPort();
                if (port != null && port instanceof WaxLabAudioOutputPort && (wp = (WaxLabAudioOutputPort)port).getChannels() == 1) {
                    return new WaxLabAudioOutputPort[]{wp};
                }
                return null;
            }
            case 2: {
                WaxLabAudioOutputPort wp;
                Port port;
                WaxLabPortInfo info = infos[0];
                Port port3 = port = info == null ? null : info.getPort();
                if (port != null && port instanceof WaxLabAudioOutputPort && (wp = (WaxLabAudioOutputPort)port).getChannels() == 2) {
                    return new WaxLabAudioOutputPort[]{wp};
                }
                if (numPorts > 1) {
                    numPorts = 2;
                    WaxLabAudioOutputPort[] arr = new WaxLabAudioOutputPort[numPorts];
                    boolean valid = false;
                    for (int i = 0; i < numPorts; ++i) {
                        info = infos[i];
                        Port port4 = port = info == null ? null : info.getPort();
                        if (port == null || !(port instanceof WaxLabAudioOutputPort) || (wp = (WaxLabAudioOutputPort)port) == null) continue;
                        arr[i] = wp;
                        valid = true;
                    }
                    if (valid) {
                        return arr;
                    }
                }
                return null;
            }
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Invalid audio output frame type: " + frameType);
        }
        return null;
    }

    protected static WaxLabAudioInputPort[] validateAudioInputPorts(WaxLabPortInfo[] infos, int frameType) throws AudioException {
        if (infos == null) {
            return null;
        }
        int numPorts = infos.length;
        if (numPorts < 1) {
            return null;
        }
        switch (frameType) {
            case 1: {
                WaxLabAudioInputPort wp;
                Port port;
                WaxLabPortInfo info = infos[0];
                Port port2 = port = info == null ? null : info.getPort();
                if (port != null && port instanceof WaxLabAudioInputPort && (wp = (WaxLabAudioInputPort)port).getChannels() == 1) {
                    return new WaxLabAudioInputPort[]{wp};
                }
                return null;
            }
            case 2: {
                WaxLabAudioInputPort wp;
                Port port;
                WaxLabPortInfo info = infos[0];
                Port port3 = port = info == null ? null : info.getPort();
                if (port != null && port instanceof WaxLabAudioInputPort && (wp = (WaxLabAudioInputPort)port).getChannels() == 2) {
                    return new WaxLabAudioInputPort[]{wp};
                }
                if (numPorts > 1) {
                    numPorts = 2;
                    WaxLabAudioInputPort[] arr = new WaxLabAudioInputPort[numPorts];
                    boolean valid = false;
                    for (int i = 0; i < numPorts; ++i) {
                        info = infos[i];
                        Port port4 = port = info == null ? null : info.getPort();
                        if (port == null || !(port instanceof WaxLabAudioInputPort) || (wp = (WaxLabAudioInputPort)port) == null) continue;
                        arr[i] = wp;
                        valid = true;
                    }
                    if (valid) {
                        return arr;
                    }
                }
                return null;
            }
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Invalid audio input frame type: " + frameType);
        }
        return null;
    }

    protected static WaxLabAudioSyncGroup getAudioSyncGroup(WaxLabAudioOutputPort port) {
        AudioSyncGroup group;
        AudioSupport support;
        if (port != null && (support = port.getAudioSupport()) != null && (group = support.getAudioSyncGroup((AudioPort)port)) != null && group instanceof WaxLabAudioSyncGroup) {
            return (WaxLabAudioSyncGroup)group;
        }
        return null;
    }

    protected static WaxLabAudioSyncGroup getAudioSyncGroup(WaxLabAudioInputPort port) {
        AudioSyncGroup group;
        AudioSupport support;
        if (port != null && (support = port.getAudioSupport()) != null && (group = support.getAudioSyncGroup((AudioPort)port)) != null && group instanceof WaxLabAudioSyncGroup) {
            return (WaxLabAudioSyncGroup)group;
        }
        return null;
    }

    protected static WaxLabAudioSyncGroup validateAudioSyncGroup(WaxLabAudioOutputPort[] ports) {
        if (ports == null) {
            return null;
        }
        int num = ports.length;
        if (num < 1) {
            return null;
        }
        WaxLabAudioSyncGroup syncGroup = null;
        for (int i = 0; i < num; ++i) {
            WaxLabAudioOutputPort port = ports[i];
            WaxLabAudioSyncGroup group = CommonLineFeature.getAudioSyncGroup(port);
            if (group == null) continue;
            if (syncGroup == null) {
                syncGroup = group;
                continue;
            }
            if (group == syncGroup) continue;
            return null;
        }
        return syncGroup;
    }

    protected static WaxLabAudioSyncGroup validateAudioSyncGroup(WaxLabAudioInputPort[] ports) {
        if (ports == null) {
            return null;
        }
        int num = ports.length;
        if (num < 1) {
            return null;
        }
        WaxLabAudioSyncGroup syncGroup = null;
        for (int i = 0; i < num; ++i) {
            WaxLabAudioInputPort port = ports[i];
            WaxLabAudioSyncGroup group = CommonLineFeature.getAudioSyncGroup(port);
            if (group == null) continue;
            if (syncGroup == null) {
                syncGroup = group;
                continue;
            }
            if (group == syncGroup) continue;
            return null;
        }
        return syncGroup;
    }

    protected static WaxLabMidiInputPort validateMidiInputPort(WaxLabPortInfo info) {
        Port port;
        if (info != null && (port = info.getPort()) != null && port instanceof WaxLabMidiInputPort) {
            WaxLabMidiInputPort wp = (WaxLabMidiInputPort)port;
            return wp;
        }
        return null;
    }

    protected static WaxLabMidiOutputPort validateMidiOutputPort(WaxLabPortInfo info) {
        Port port;
        if (info != null && (port = info.getPort()) != null && port instanceof WaxLabMidiOutputPort) {
            WaxLabMidiOutputPort wp = (WaxLabMidiOutputPort)port;
            return wp;
        }
        return null;
    }

    protected static WaxLabMidiSyncGroup getMidiSyncGroup(WaxLabMidiInputPort port) {
        MidiSyncGroup group;
        MidiSupport support;
        if (port != null && (support = port.getMidiSupport()) != null && (group = support.getMidiSyncGroup((MidiPort)port)) != null && group instanceof WaxLabMidiSyncGroup) {
            return (WaxLabMidiSyncGroup)group;
        }
        return null;
    }

    protected static WaxLabMidiSyncGroup getMidiSyncGroup(WaxLabMidiOutputPort port) {
        MidiSyncGroup group;
        MidiSupport support;
        if (port != null && (support = port.getMidiSupport()) != null && (group = support.getMidiSyncGroup((MidiPort)port)) != null && group instanceof WaxLabMidiSyncGroup) {
            return (WaxLabMidiSyncGroup)group;
        }
        return null;
    }

    protected static WaxLabMidiSyncGroup validateMidiSyncGroup(WaxLabMidiInputPort port) {
        if (port == null) {
            return null;
        }
        WaxLabMidiSyncGroup syncGroup = CommonLineFeature.getMidiSyncGroup(port);
        if (syncGroup == null) {
            return null;
        }
        return syncGroup;
    }

    protected static WaxLabMidiSyncGroup validateMidiSyncGroup(WaxLabMidiOutputPort port) {
        if (port == null) {
            return null;
        }
        WaxLabMidiSyncGroup syncGroup = CommonLineFeature.getMidiSyncGroup(port);
        if (syncGroup == null) {
            return null;
        }
        return syncGroup;
    }

    protected static float computeAudioInputSampleRate(WaxLabAudioInputPort[] recPorts, int recPortCount) {
        float audioInputSampleRate = -1.0f;
        for (int i = 0; i < recPortCount; ++i) {
            float rate;
            SampleBuffer sb;
            WaxLabAudioInputPort port = recPorts[i];
            if (port == null || (sb = recPorts[i].getBuffer()) == null || (rate = sb.getFrameRate()) <= 0.0f) continue;
            audioInputSampleRate = rate;
            break;
        }
        return audioInputSampleRate;
    }

    protected static int computeAudioInputChannels(WaxLabAudioInputPort[] ports, int portCount) throws AudioException {
        int audioInputChannels;
        block3: {
            block2: {
                int channels;
                audioInputChannels = 0;
                if (portCount != 1) break block2;
                WaxLabAudioInputPort port = ports[0];
                if (port == null || (channels = port.getChannels()) <= 0) break block3;
                audioInputChannels = channels;
                break block3;
            }
            if (portCount > 1) {
                audioInputChannels = portCount;
                for (int i = 0; i < portCount; ++i) {
                    WaxLabAudioInputPort port = ports[i];
                    if (port == null || port.getChannels() == 1) continue;
                    audioInputChannels = 0;
                    break;
                }
            }
        }
        return audioInputChannels;
    }

    protected static int computeAudioInputBufferFrames(WaxLabAudioSyncGroup recSyncGroup, WaxLabAudioInputPort[] recPorts, int recPortCount) throws AudioException {
        int channels;
        SampleBuffer sb;
        WaxLabAudioInputPort port;
        int audioBufferFrames = 0;
        for (int i = 0; i < recPortCount && ((port = recPorts[i]) == null || (sb = port.getBuffer()) == null || (channels = sb.getChannels()) < 1 || (audioBufferFrames = sb.getSamples() / channels) < 1); ++i) {
        }
        return audioBufferFrames;
    }

    protected static float computeAudioOutputSampleRate(WaxLabAudioOutputPort[] playPorts, int playPortCount) {
        float audioOutputSampleRate = -1.0f;
        for (int i = 0; i < playPortCount; ++i) {
            float rate;
            SampleBuffer sb;
            WaxLabAudioOutputPort port = playPorts[i];
            if (port == null || (sb = port.getBuffer()) == null || (rate = sb.getFrameRate()) <= 0.0f) continue;
            audioOutputSampleRate = rate;
            break;
        }
        return audioOutputSampleRate;
    }

    protected static int computeAudioOutputChannels(WaxLabAudioOutputPort[] ports, int portCount) throws AudioException {
        int audioOutputChannels;
        block3: {
            block2: {
                int channels;
                audioOutputChannels = 0;
                if (portCount != 1) break block2;
                WaxLabAudioOutputPort port = ports[0];
                if (port == null || (channels = port.getChannels()) <= 0) break block3;
                audioOutputChannels = channels;
                break block3;
            }
            if (portCount > 1) {
                audioOutputChannels = portCount;
                for (int i = 0; i < portCount; ++i) {
                    WaxLabAudioOutputPort port = ports[i];
                    if (port == null || port.getChannels() == 1) continue;
                    audioOutputChannels = 0;
                    break;
                }
            }
        }
        return audioOutputChannels;
    }

    protected static int computeAudioOutputBufferFrames(WaxLabAudioSyncGroup playSyncGroup, WaxLabAudioOutputPort[] playPorts, int playPortCount) throws AudioException {
        int channels;
        SampleBuffer sb;
        WaxLabAudioOutputPort port;
        int audioBufferFrames = 0;
        for (int i = 0; i < playPortCount && ((port = playPorts[i]) == null || (sb = port.getBuffer()) == null || (channels = sb.getChannels()) < 1 || (audioBufferFrames = sb.getSamples() / channels) < 1); ++i) {
        }
        return audioBufferFrames;
    }

    protected WaxLabScratchCursorFader createFadedAudioProcessor(AudioProcessor audioPreProcessor, DoubleArraySampleBuffer targetAudioBuffer, Line studioLine, FaderModel faderModel, double faderModelStartMillis, FaderCurve faderCurve) throws AudioException {
        DefaultSampleCursor faderCursor;
        float targetFrameRate = targetAudioBuffer.getFrameRate();
        boolean closeModel = false;
        CubicInterpolatedSampleModel cubicFaderSampleModel = new CubicInterpolatedSampleModel(targetFrameRate, (SampleModel)faderModel, closeModel);
        long faderSampleIndex = (long)(faderModelStartMillis * (double)targetFrameRate / 1000.0);
        boolean batchMode = this.getMediator().isBatchMode();
        if (batchMode) {
            faderCursor = new DefaultSampleCursor((SampleModel)cubicFaderSampleModel, faderSampleIndex);
        } else {
            WaxLabPreferences waxLabPreferences = this.getMediator().getWaxLabPreferences();
            LockFactory lockFactory = this.getMediator().getLockFactory();
            ThreadPool loaderThreadPool = this.getMediator().getLoaderThreadPool();
            int bufferCount = waxLabPreferences.getAudioPlayerBufferCount();
            int bufferSize = (int)((double)waxLabPreferences.getAudioPlayerBufferMillis() * (double)targetFrameRate / 1000.0);
            boolean fair = waxLabPreferences.isAudioPlayerBufferFair();
            SampleBuffer[] sampleBuffers = new SampleBuffer[bufferCount];
            for (int i = 0; i < bufferCount; ++i) {
                sampleBuffers[i] = new FloatArraySampleBuffer(1, bufferSize, targetFrameRate, new float[bufferSize]);
            }
            try {
                boolean readOnly = true;
                ReadWriteLock bufLock = lockFactory.createReadWriteLock(fair);
                FaderModel cubicFaderModel = null;
                RealFaderModel realtimeModel = new RealFaderModel(cubicFaderModel, (SampleModel)cubicFaderSampleModel, faderSampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, loaderThreadPool);
                realtimeModel.setName(faderModel.getName());
                faderCursor = realtimeModel.openRealtimeCursor(faderSampleIndex);
            }
            catch (IOException e) {
                throw new AudioException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new AudioException((Throwable)e);
            }
        }
        return new WaxLabScratchCursorFader(audioPreProcessor, targetAudioBuffer, (SampleCursor)faderCursor, faderCurve);
    }

    protected PitchDeck lookupPitchDeck(WaxLab waxLab, TimecodeLine line) {
        return null;
    }

    protected WaxLabTimecodeRecorder createRecordingTimecodeConsumer(WaxLab waxLab, TimecodeLine tcLine, long lineOfs, float frameRate, String fileNamePrefix, AudioModel cachedAudioModel) throws AudioException, IOException {
        CachedTimecodeModel targetTimecodeModel;
        WaxLabPreferences waxLabPreferences = this.getMediator().getWaxLabPreferences();
        boolean deleteTempTimecodeFiles = true;
        TimecodeFile timecodeFile = waxLab.createNewTimecodeFile(fileNamePrefix, frameRate);
        CachedTimecodeModel cachedTimecodeModel = waxLab.createCachedTimecodeModel(timecodeFile, deleteTempTimecodeFiles);
        long sampleIndex = 0L;
        boolean batchMode = this.getMediator().isBatchMode();
        if (batchMode) {
            targetTimecodeModel = cachedTimecodeModel;
            CachedTimecodeModel targetSampleModel = cachedTimecodeModel;
            DefaultSampleCursor targetCursor = new DefaultSampleCursor((SampleModel)cachedTimecodeModel, sampleIndex);
        } else {
            int bufferCount = waxLabPreferences.getTimecodeRecorderBufferCount();
            int bufferSize = (int)((double)waxLabPreferences.getTimecodeRecorderBufferMillis() * (double)frameRate / 1000.0);
            boolean fair = waxLabPreferences.isTimecodeRecorderBufferFair();
            int channels = 1;
            SampleBuffer[] sampleBuffers = new SampleBuffer[bufferCount];
            for (int i = 0; i < bufferCount; ++i) {
                sampleBuffers[i] = new DoubleArraySampleBuffer(channels, bufferSize, frameRate, new double[bufferSize]);
            }
            try {
                boolean readOnly = false;
                boolean closeModel = false;
                LockFactory lockFactory = this.getMediator().getLockFactory();
                ThreadPool writerThreadPool = this.getMediator().getWriterThreadPool();
                ReadWriteLock bufLock = lockFactory.createReadWriteLock(fair);
                RealTimecodeModel realtimeModel = new RealTimecodeModel((TimecodeModel)cachedTimecodeModel, (SampleModel)cachedTimecodeModel, sampleIndex, readOnly, closeModel, bufferCount, bufferSize, sampleBuffers, bufLock, writerThreadPool);
                targetTimecodeModel = realtimeModel;
                RealTimecodeModel targetSampleModel = realtimeModel;
                SampleCursor targetCursor = realtimeModel.openRealtimeCursor(sampleIndex);
            }
            catch (IOException e) {
                throw new AudioException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new AudioException((Throwable)e);
            }
        }
        long chunkOfs = lineOfs;
        long chunkEnd = Long.MAX_VALUE;
        long modelOfs = 0L;
        long modelEnd = Long.MAX_VALUE;
        DefaultTimecodeChunk targetTimecodeChunk = new DefaultTimecodeChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, (TimecodeModel)targetTimecodeModel);
        tcLine.setRecChunk((LineChunk)targetTimecodeChunk);
        tcLine.getMutableChunkModel().addChunk((LineChunk)targetTimecodeChunk);
        throw new UnsupportedOperationException("OLD");
    }

    protected AbstractAudioScratchPlayer createAudioScratchPlayer(AbstractScratchLine scratchLine, double startTime, TimecodeModel tcModel, double beatJump, SampleModel audioModel, float resampleRate, MediaEntry mediaEntry, double startTrackPos, double volume, int pitchMode, double pitchFactor, double pitchBPM, PitchDeck pitchDeck, DoubleArraySampleBuffer target) throws AudioException {
        double initNeedlePos;
        CubicTimecodeScratchModel timecodeScratchModel;
        double tcStartTime;
        double skipThreshold;
        int asyncSleepMillis;
        if (scratchLine == null) {
            throw new IllegalArgumentException("ScratchLine must not be null");
        }
        if (tcModel == null) {
            throw new IllegalArgumentException("TimecodeModel must not be null");
        }
        if (audioModel == null) {
            throw new IllegalArgumentException("AudioModel must not be null");
        }
        WaxLabPreferences waxLabConfig = this.getMediator().getWaxLabPreferences();
        boolean batchMode = this.getMediator().isBatchMode();
        ThreadPool loaderThreadPool = this.getMediator().getLoaderThreadPool();
        float audioModelRate = audioModel.getFrameRate();
        int scratchBufFrames = -1;
        int scratchBufCount = waxLabConfig.getScratchBufferCount();
        if (scratchBufCount < 0) {
            scratchBufCount = 7;
        }
        if (scratchBufCount < 5) {
            scratchBufCount = 5;
        }
        if ((asyncSleepMillis = waxLabConfig.getScratchLoaderIntervalMillis()) < 1) {
            asyncSleepMillis = 1;
        }
        if ((skipThreshold = waxLabConfig.getScratchNeedleSkipThreshold()) < 0.0) {
            skipThreshold = 10.0;
        }
        if (skipThreshold < 2.0) {
            skipThreshold = 2.0;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("createAudioScratchPlayer: line=" + scratchLine.getName() + ", startTime=" + startTime + ", tcModel=" + tcModel + ", audioModel=" + audioModel + ", targetBuffer=" + target);
        }
        if ((tcStartTime = startTime) < 0.0) {
            throw new AudioException("Invalid timecode model start position: " + tcStartTime);
        }
        long tcSamples = tcModel.getSamples();
        if (tcSamples < 1L) {
            return null;
        }
        float tcFrameRate = tcModel.getFrameRate();
        double tcStartFramePos = tcStartTime * (double)tcFrameRate / 1000.0;
        if (tcStartFramePos >= (double)tcSamples) {
            return null;
        }
        try {
            timecodeScratchModel = new CubicTimecodeScratchModel((SampleModel)tcModel, tcStartFramePos, scratchBufFrames, scratchBufCount, loaderThreadPool, batchMode, asyncSleepMillis);
        }
        catch (IOException e) {
            throw new AudioException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new AudioException((Throwable)e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("TimecodeScratchModel: " + timecodeScratchModel);
        }
        if ((initNeedlePos = timecodeScratchModel.get(tcStartFramePos)) != initNeedlePos) {
            logger.warning("Init needle position is NaN: tcStartFramePos=" + tcStartFramePos + ", tcModel=" + tcModel + ", tcScratchModel=" + timecodeScratchModel);
            initNeedlePos = 0.0;
            try {
                long p = (long)tcStartFramePos - 10L;
                double[] arr = new double[20];
                tcModel.get(p, arr, 0, arr.length);
                for (int i = 0; i < arr.length; ++i) {
                    logger.info("Debug #" + (p + (long)i) + " = " + arr[i]);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        double tcInitVelocity = 0.0;
        double tcInitVolume = 0.0;
        double initNeedleFramePos = initNeedlePos * (double)audioModelRate / 1000.0;
        AudioScratchModel audioScratchModel = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("AudioScratchModel: " + audioScratchModel);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating playback scratch player: line=" + scratchLine.getName() + ", skipThreshold=" + skipThreshold);
        }
        DefaultAudioScratchPlayer audioScratchPlayer = new DefaultAudioScratchPlayer((TimecodeScratchModel)timecodeScratchModel, tcStartFramePos, tcInitVelocity, tcInitVolume, audioScratchModel, startTrackPos, volume, pitchMode, pitchFactor, pitchBPM, pitchDeck, target, skipThreshold);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("AudioScratchPlayer: " + audioScratchPlayer);
        }
        WaxLabLiveFeeder scratchFeeder = null;
        if (audioModel instanceof WaxLabLiveFeeder) {
            scratchFeeder = (WaxLabLiveFeeder)audioModel;
        }
        WaxLabDevice device = this.getMediator().getWaxLabDevice();
        Clock clock = this.getMediator().getClock();
        LockSupport lockSupport = this.getMediator().getLockSupport();
        LockFactory lockFactory = this.getMediator().getLockFactory();
        ThreadManager threadManager = this.getMediator().getThreadManager();
        WaxLabScratchDeckMediator scratchDeckMediator = null;
        WaxLabScratchDeck scratchDeck = new WaxLabScratchDeck(device, scratchLine, scratchDeckMediator, clock, lockSupport, lockFactory, threadManager);
        scratchDeck.setScratchPlayer((AbstractAudioScratchPlayer)audioScratchPlayer);
        scratchDeck.setScratchModel(audioScratchModel);
        scratchDeck.setScratchFeeder(scratchFeeder);
        List scratchDeckList = null;
        scratchDeckList.add(scratchDeck);
        scratchDeckMediator.registerScratchDeck(scratchDeck);
        LineWrapper lineWrapper = null;
        if (scratchLine instanceof AbstractScratchLine) {
            AbstractScratchLine asl = scratchLine;
            lineWrapper = asl.getWrapper();
        }
        if (lineWrapper != null) {
            lineWrapper.setScratchPlayer((AudioScratchPlayer)audioScratchPlayer);
        }
        return audioScratchPlayer;
    }
}

