/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.waxmonster.model.AudioChunk;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.waxlab.AudioLine;
import com.waxmonster.waxlab.AudioLineConfig;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.FeatureAudioLinePlayer;
import com.waxmonster.waxlab.impl.FeatureAudioLineRecorder;
import com.waxmonster.waxlab.impl.WaxLabAudioSyncGroup;

public class DefaultAudioLine
extends AbstractLine
implements AudioLine {
    public static final AudioChunk[] NO_AUDIO_CHUNKS = new AudioChunk[0];
    public static final int DEFAULT_RECORDING_SAMPLE_TYPE = 1;
    public static final int DEFAULT_RECORDING_FRAME_TYPE = 2;
    public static final int DEFAULT_PLAYBACK_FRAME_TYPE = 2;
    private AudioLineConfig audioLineConfig;
    private FeatureAudioLineRecorder featureAudioLineRecorder;
    private FeatureAudioLinePlayer featureAudioLinePlayer;
    private WaxLabAudioSyncGroup audioSyncGroup;
    private DefaultChunkModel audioChunkModel = this.createDefaultChunkModel();

    public DefaultAudioLine(ReadWriteLock lock) {
        super(lock);
        this.initLineFeatures();
        this.initLineWidgets();
        AudioLineConfig alc = new AudioLineConfig();
        alc.setRecordingSampleType(1);
        alc.setRecordingFrameType(2);
        alc.setPlaybackFrameType(2);
        this.setAudioLineConfig(alc);
    }

    public boolean isPlaybackSupported() {
        return true;
    }

    public boolean isRecordingSupported() {
        return true;
    }

    public synchronized AudioLineConfig getAudioLineConfig() {
        return this.audioLineConfig;
    }

    public synchronized void setAudioLineConfig(AudioLineConfig audioLineConfig) {
        this.audioLineConfig = audioLineConfig;
        this.setLineDirty();
        if (this.featureAudioLineRecorder != null) {
            int recFrameType = -1;
            int recSampleType = -1;
            boolean recEnabled = false;
            WaxLabPortInfo[] recPorts = null;
            if (audioLineConfig != null) {
                recFrameType = audioLineConfig.getRecordingFrameType();
                recSampleType = audioLineConfig.getRecordingSampleType();
                recPorts = audioLineConfig.getRecordingPorts();
                recEnabled = audioLineConfig.isRecordingEnabled();
            }
            this.featureAudioLineRecorder.setRecordingFrameType(recFrameType);
            this.featureAudioLineRecorder.setRecordingSampleType(recSampleType);
            this.featureAudioLineRecorder.setRecordingPorts(recPorts);
            this.featureAudioLineRecorder.getWidgetAudioRecorder().setSelected(recEnabled);
        }
        if (this.featureAudioLinePlayer != null) {
            int playFrameType = -1;
            boolean playEnabled = false;
            WaxLabPortInfo[] playPorts = null;
            if (audioLineConfig != null) {
                playFrameType = audioLineConfig.getPlaybackFrameType();
                playPorts = audioLineConfig.getPlaybackPorts();
                playEnabled = audioLineConfig.isPlaybackEnabled();
            }
            this.featureAudioLinePlayer.setPlaybackFrameType(playFrameType);
            this.featureAudioLinePlayer.setPlaybackPorts(playPorts);
            this.featureAudioLinePlayer.getWidgetAudioPlayer().setSelected(playEnabled);
        }
    }

    public synchronized LineConfig getLineConfig() {
        return this.audioLineConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioChunk[] getAudioChunks() {
        DefaultChunkModel model = this.audioChunkModel;
        if (model == null) {
            return NO_AUDIO_CHUNKS;
        }
        try {
            LineChunk chunk;
            this.lock.lockRead();
            int num = 0;
            int n = model.getChunkCount();
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof AudioChunk)) continue;
                ++num;
            }
            if (num < 1) {
                AudioChunk[] i = NO_AUDIO_CHUNKS;
                return i;
            }
            AudioChunk[] chunks = new AudioChunk[num];
            int idx = 0;
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof AudioChunk)) continue;
                chunks[idx++] = (AudioChunk)chunk;
            }
            AudioChunk[] audioChunkArray = chunks;
            return audioChunkArray;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected WaxLabAudioSyncGroup getAudioSyncGroup() {
        return this.audioSyncGroup;
    }

    protected void setAudioSyncGroup(WaxLabAudioSyncGroup audioSyncGroup) {
        this.audioSyncGroup = audioSyncGroup;
    }

    public synchronized FeatureAudioLinePlayer getFeatureAudioLinePlayer() {
        if (this.featureAudioLinePlayer == null) {
            this.setFeatureAudioLinePlayer(this.createFeatureAudioLinePlayer());
        }
        return this.featureAudioLinePlayer;
    }

    protected synchronized void setFeatureAudioLinePlayer(FeatureAudioLinePlayer featureAudioLinePlayer) {
        this.featureAudioLinePlayer = featureAudioLinePlayer;
    }

    protected FeatureAudioLinePlayer createFeatureAudioLinePlayer() {
        FeatureAudioLinePlayer feature = new FeatureAudioLinePlayer(this);
        return feature;
    }

    public synchronized FeatureAudioLineRecorder getFeatureAudioLineRecorder() {
        if (this.featureAudioLineRecorder == null) {
            this.setFeatureAudioLineRecorder(this.createFeatureAudioLineRecorder());
        }
        return this.featureAudioLineRecorder;
    }

    protected synchronized void setFeatureAudioLineRecorder(FeatureAudioLineRecorder featureAudioLineRecorder) {
        this.featureAudioLineRecorder = featureAudioLineRecorder;
    }

    protected FeatureAudioLineRecorder createFeatureAudioLineRecorder() {
        FeatureAudioLineRecorder feature = new FeatureAudioLineRecorder(this);
        return feature;
    }

    protected void initLineFeatures() {
        this.addLineFeature(this.getFeatureAudioLinePlayer());
        this.addLineFeature(this.getFeatureAudioLineRecorder());
    }

    protected void initLineWidgets() {
        this.addLineWidget(this.featureAudioLinePlayer.getWidgetAudioPlayer());
        this.addLineWidget(this.featureAudioLineRecorder.getWidgetAudioRecorder());
    }

    @Override
    protected void fireWidgetChanged(LineWidget widget) {
        super.fireWidgetChanged(widget);
        AudioLineConfig config = this.getAudioLineConfig();
        if (config != null && widget != null) {
            if (widget == this.featureAudioLinePlayer.getWidgetAudioPlayer()) {
                config.setPlaybackEnabled(widget.isSelected());
            }
            if (widget == this.featureAudioLineRecorder.getWidgetAudioRecorder()) {
                config.setRecordingEnabled(widget.isSelected());
            }
        }
    }

    public DefaultChunkModel getAudioChunkModel() {
        return this.audioChunkModel;
    }

    public ChunkModel getChunkModel() {
        return this.audioChunkModel;
    }

    public MutableChunkModel getMutableChunkModel() {
        return this.audioChunkModel;
    }

    @Override
    public boolean isLineDirty() {
        if (super.isLineDirty()) {
            return true;
        }
        DefaultChunkModel model = this.audioChunkModel;
        return model != null && model.isDirty();
    }

    @Override
    public void clearLineDirty() {
        super.clearLineDirty();
        DefaultChunkModel model = this.audioChunkModel;
        if (model != null) {
            model.clearDirty();
        }
    }

    public long computeTimeLength() {
        DefaultChunkModel model = this.audioChunkModel;
        return model == null ? 0L : model.computeTimeLength();
    }
}

