/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.LineFeature;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.ScratchLineConfig;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractScratchLine;
import com.waxmonster.waxlab.impl.FeatureEditorLinePlayer;
import com.waxmonster.waxlab.impl.ScratchManager;
import com.waxmonster.waxlab.impl.WaxLabScratchDeck;

public class DefaultEditorLine
extends AbstractScratchLine
implements EditorLine {
    public static final WaxEditorModel[] NO_EDITOR_CHUNKS = new WaxEditorModel[0];
    public static final int DEFAULT_PLAYBACK_FRAME_TYPE = 2;
    private EditorLineConfig editorLineConfig;
    private FeatureEditorLinePlayer featureEditorLinePlayer;
    private DefaultChunkModel editorChunkModel = this.createDefaultChunkModel();

    public DefaultEditorLine(ReadWriteLock lock) {
        super(lock);
        this.initLineFeatures();
        this.initLineWidgets();
        EditorLineConfig elc = new EditorLineConfig();
        elc.setPlaybackFrameType(2);
        this.setEditorLineConfig(elc);
    }

    public synchronized EditorLineConfig getEditorLineConfig() {
        return this.editorLineConfig;
    }

    public synchronized void setEditorLineConfig(EditorLineConfig editorLineConfig) {
        ScratchManager scratchManager;
        this.editorLineConfig = editorLineConfig;
        this.setLineDirty();
        WaxLabScratchDeck scratchDeck = this.scratchDeck;
        if (scratchDeck != null) {
            boolean force = scratchDeck.getScratchPlayer() == null;
            scratchDeck.applyScratchLineConfig((ScratchLineConfig)editorLineConfig, force);
        }
        if ((scratchManager = this.scratchManager) != null) {
            int playFrameType = -1;
            WaxLabPortInfo[] audioPreFaderPorts = null;
            WaxLabPortInfo[] audioPostFaderPorts = null;
            if (editorLineConfig != null) {
                playFrameType = editorLineConfig.getPlaybackFrameType();
                audioPostFaderPorts = editorLineConfig.getPlaybackPorts();
            }
            scratchManager.setAudioFrameType(playFrameType);
            scratchManager.setAudioPreFaderPorts(audioPreFaderPorts);
            scratchManager.setAudioPostFaderPorts(audioPostFaderPorts);
        }
        if (this.featureEditorLinePlayer != null) {
            boolean playerEnabled = false;
            if (editorLineConfig != null) {
                playerEnabled = editorLineConfig.isPlaybackEnabled();
            }
            this.featureEditorLinePlayer.getWidgetEditorPlayer().setSelected(playerEnabled);
        }
    }

    public synchronized LineConfig getLineConfig() {
        return this.editorLineConfig;
    }

    public synchronized ScratchLineConfig getScratchLineConfig() {
        return this.editorLineConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaxEditorModel[] getEditorChunks() {
        DefaultChunkModel model = this.editorChunkModel;
        if (model == null) {
            return NO_EDITOR_CHUNKS;
        }
        try {
            LineChunk chunk;
            this.lock.lockRead();
            int num = 0;
            int n = model.getChunkCount();
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof WaxEditorModel)) continue;
                ++num;
            }
            if (num < 1) {
                WaxEditorModel[] i = NO_EDITOR_CHUNKS;
                return i;
            }
            WaxEditorModel[] chunks = new WaxEditorModel[num];
            int idx = 0;
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof WaxEditorModel)) continue;
                chunks[idx++] = (WaxEditorModel)chunk;
            }
            WaxEditorModel[] waxEditorModelArray = chunks;
            return waxEditorModelArray;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    public boolean isPlaybackSupported() {
        return true;
    }

    public boolean isRecordingSupported() {
        return false;
    }

    public synchronized FeatureEditorLinePlayer getFeatureEditorLinePlayer() {
        if (this.featureEditorLinePlayer == null) {
            this.setFeatureEditorLinePlayer(this.createFeatureEditorLinePlayer());
        }
        return this.featureEditorLinePlayer;
    }

    protected synchronized void setFeatureEditorLinePlayer(FeatureEditorLinePlayer featureEditorLinePlayer) {
        this.featureEditorLinePlayer = featureEditorLinePlayer;
    }

    protected FeatureEditorLinePlayer createFeatureEditorLinePlayer() {
        ScratchManager scratchManager = this.getScratchManager();
        FeatureEditorLinePlayer feature = new FeatureEditorLinePlayer(this, scratchManager);
        scratchManager.setLineFeature(feature);
        feature.setScratchManager(scratchManager);
        return feature;
    }

    protected void initLineFeatures() {
        this.addLineFeature(this.getFeatureEditorLinePlayer());
    }

    protected void initLineWidgets() {
        this.addLineWidget(this.featureEditorLinePlayer.getWidgetEditorPlayer());
    }

    @Override
    protected synchronized void fireFeatureChanged(LineFeature feature) {
        super.fireFeatureChanged(feature);
    }

    @Override
    protected void fireWidgetChanged(LineWidget widget) {
        super.fireWidgetChanged(widget);
        EditorLineConfig config = this.getEditorLineConfig();
        if (config != null && widget != null && widget == this.featureEditorLinePlayer.getWidgetEditorPlayer()) {
            config.setPlaybackEnabled(widget.isSelected());
        }
    }

    public DefaultChunkModel getEditorChunkModel() {
        return this.editorChunkModel;
    }

    public ChunkModel getChunkModel() {
        return this.editorChunkModel;
    }

    public MutableChunkModel getMutableChunkModel() {
        return this.editorChunkModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLineDirty() {
        if (super.isLineDirty()) {
            return true;
        }
        DefaultChunkModel model = this.editorChunkModel;
        if (model != null) {
            if (model.isDirty()) {
                return true;
            }
            try {
                this.lock.lockRead();
                int num = model.getChunkCount();
                for (int i = 0; i < num; ++i) {
                    WaxEditorModel wem;
                    LineChunk chunk = model.getChunkAt(i);
                    if (chunk == null || !(chunk instanceof WaxEditorModel) || !(wem = (WaxEditorModel)chunk).isDirty()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlockRead();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLineDirty() {
        super.clearLineDirty();
        DefaultChunkModel model = this.editorChunkModel;
        if (model != null) {
            model.clearDirty();
            try {
                this.lock.lockRead();
                int num = model.getChunkCount();
                for (int i = 0; i < num; ++i) {
                    LineChunk chunk = model.getChunkAt(i);
                    if (chunk == null || !(chunk instanceof WaxEditorModel)) continue;
                    WaxEditorModel wem = (WaxEditorModel)chunk;
                    wem.setDirty(false);
                }
            }
            finally {
                this.lock.unlockRead();
            }
        }
    }

    public long computeTimeLength() {
        DefaultChunkModel model = this.editorChunkModel;
        return model == null ? 0L : model.computeTimeLength();
    }
}

