/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.waxlab.impl;

import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.midi.MidiFilter;
import com.waxmonster.model.ChunkModel;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.MidiChunk;
import com.waxmonster.model.MutableChunkModel;
import com.waxmonster.model.impl.DefaultChunkModel;
import com.waxmonster.model.view.MidiColorPalette;
import com.waxmonster.waxlab.LineConfig;
import com.waxmonster.waxlab.LineWidget;
import com.waxmonster.waxlab.MidiLine;
import com.waxmonster.waxlab.MidiLineConfig;
import com.waxmonster.waxlab.WaxLabPortInfo;
import com.waxmonster.waxlab.impl.AbstractLine;
import com.waxmonster.waxlab.impl.FeatureMidiLinePlayer;
import com.waxmonster.waxlab.impl.FeatureMidiLineRecorder;

public class DefaultMidiLine
extends AbstractLine
implements MidiLine {
    public static final MidiChunk[] NO_MIDI_CHUNKS = new MidiChunk[0];
    private MidiLineConfig midiLineConfig;
    private FeatureMidiLineRecorder featureMidiLineRecorder;
    private FeatureMidiLinePlayer featureMidiLinePlayer;
    private MidiFilter recordingMidiFilter;
    private MidiFilter playbackMidiFilter;
    private MidiColorPalette midiColorPalette;
    private DefaultChunkModel midiChunkModel = this.createDefaultChunkModel();

    public DefaultMidiLine(ReadWriteLock lock) {
        super(lock);
        this.initLineFeatures();
        this.initLineWidgets();
        MidiLineConfig mlc = new MidiLineConfig();
        this.setMidiLineConfig(mlc);
    }

    public synchronized MidiLineConfig getMidiLineConfig() {
        return this.midiLineConfig;
    }

    public synchronized void setMidiLineConfig(MidiLineConfig midiLineConfig) {
        this.midiLineConfig = midiLineConfig;
        this.setLineDirty();
        if (this.featureMidiLineRecorder != null) {
            boolean recEnabled = false;
            WaxLabPortInfo recPort = null;
            float recTickRate = 0.0f;
            if (midiLineConfig != null) {
                recEnabled = midiLineConfig.isRecordingEnabled();
                recPort = midiLineConfig.getRecordingPort();
                recTickRate = midiLineConfig.getRecordingTickRate();
            }
            this.featureMidiLineRecorder.setRecordingTickRate(recTickRate);
            this.featureMidiLineRecorder.setRecordingPort(recPort);
            this.featureMidiLineRecorder.getWidgetMidiRecorder().setSelected(recEnabled);
        }
        if (this.featureMidiLinePlayer != null) {
            boolean playEnabled = false;
            WaxLabPortInfo playPort = null;
            if (midiLineConfig != null) {
                playEnabled = midiLineConfig.isPlaybackEnabled();
                playPort = midiLineConfig.getPlaybackPort();
            }
            this.featureMidiLinePlayer.setPlaybackPort(playPort);
            this.featureMidiLinePlayer.getWidgetMidiPlayer().setSelected(playEnabled);
        }
    }

    public synchronized LineConfig getLineConfig() {
        return this.midiLineConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiChunk[] getMidiChunks() {
        DefaultChunkModel model = this.midiChunkModel;
        if (model == null) {
            return NO_MIDI_CHUNKS;
        }
        try {
            LineChunk chunk;
            this.lock.lockRead();
            int num = 0;
            int n = model.getChunkCount();
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof MidiChunk)) continue;
                ++num;
            }
            if (num < 1) {
                MidiChunk[] i = NO_MIDI_CHUNKS;
                return i;
            }
            MidiChunk[] chunks = new MidiChunk[num];
            int idx = 0;
            for (int i = 0; i < n; ++i) {
                chunk = model.getChunkAt(i);
                if (!(chunk instanceof MidiChunk)) continue;
                chunks[idx++] = (MidiChunk)chunk;
            }
            MidiChunk[] midiChunkArray = chunks;
            return midiChunkArray;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    public boolean isPlaybackSupported() {
        return true;
    }

    public boolean isRecordingSupported() {
        return true;
    }

    public synchronized FeatureMidiLinePlayer getFeatureMidiLinePlayer() {
        if (this.featureMidiLinePlayer == null) {
            this.setFeatureMidiLinePlayer(this.createFeatureMidiLinePlayer());
        }
        return this.featureMidiLinePlayer;
    }

    protected synchronized void setFeatureMidiLinePlayer(FeatureMidiLinePlayer featureMidiLinePlayer) {
        this.featureMidiLinePlayer = featureMidiLinePlayer;
    }

    protected FeatureMidiLinePlayer createFeatureMidiLinePlayer() {
        FeatureMidiLinePlayer feature = new FeatureMidiLinePlayer(this);
        return feature;
    }

    public synchronized FeatureMidiLineRecorder getFeatureMidiLineRecorder() {
        if (this.featureMidiLineRecorder == null) {
            this.setFeatureMidiLineRecorder(this.createFeatureMidiLineRecorder());
        }
        return this.featureMidiLineRecorder;
    }

    protected synchronized void setFeatureMidiLineRecorder(FeatureMidiLineRecorder featureMidiLineRecorder) {
        this.featureMidiLineRecorder = featureMidiLineRecorder;
    }

    protected FeatureMidiLineRecorder createFeatureMidiLineRecorder() {
        FeatureMidiLineRecorder feature = new FeatureMidiLineRecorder(this);
        return feature;
    }

    protected void initLineFeatures() {
        this.addLineFeature(this.getFeatureMidiLinePlayer());
        this.addLineFeature(this.getFeatureMidiLineRecorder());
    }

    protected void initLineWidgets() {
        this.addLineWidget(this.featureMidiLinePlayer.getWidgetMidiPlayer());
        this.addLineWidget(this.featureMidiLineRecorder.getWidgetMidiRecorder());
    }

    @Override
    protected void fireWidgetChanged(LineWidget widget) {
        super.fireWidgetChanged(widget);
        MidiLineConfig config = this.getMidiLineConfig();
        if (config != null && widget != null) {
            if (widget == this.featureMidiLinePlayer.getWidgetMidiPlayer()) {
                config.setPlaybackEnabled(widget.isSelected());
            }
            if (widget == this.featureMidiLineRecorder.getWidgetMidiRecorder()) {
                config.setRecordingEnabled(widget.isSelected());
            }
        }
    }

    public synchronized MidiFilter getRecordingMidiFilter() {
        return this.recordingMidiFilter;
    }

    public synchronized void setRecordingMidiFilter(MidiFilter recordingMidiFilter) {
        if (this.recordingMidiFilter == recordingMidiFilter) {
            return;
        }
        this.recordingMidiFilter = recordingMidiFilter;
        if (this.featureMidiLineRecorder != null) {
            this.featureMidiLineRecorder.setRecordingMidiFilter(recordingMidiFilter);
        }
    }

    public synchronized MidiFilter getPlaybackMidiFilter() {
        return this.playbackMidiFilter;
    }

    public synchronized void setPlaybackMidiFilter(MidiFilter playbackMidiFilter) {
        if (this.playbackMidiFilter == playbackMidiFilter) {
            return;
        }
        this.playbackMidiFilter = playbackMidiFilter;
        if (this.featureMidiLinePlayer != null) {
            this.featureMidiLinePlayer.setPlaybackMidiFilter(playbackMidiFilter);
        }
    }

    public MidiColorPalette getMidiColorPalette() {
        return this.midiColorPalette;
    }

    public void setMidiColorPalette(MidiColorPalette midiColorPalette) {
        this.midiColorPalette = midiColorPalette;
    }

    public DefaultChunkModel getMidiChunkModel() {
        return this.midiChunkModel;
    }

    public ChunkModel getChunkModel() {
        return this.midiChunkModel;
    }

    public MutableChunkModel getMutableChunkModel() {
        return this.midiChunkModel;
    }

    @Override
    public boolean isLineDirty() {
        if (super.isLineDirty()) {
            return true;
        }
        DefaultChunkModel model = this.midiChunkModel;
        return model != null && model.isDirty();
    }

    @Override
    public void clearLineDirty() {
        super.clearLineDirty();
        DefaultChunkModel model = this.midiChunkModel;
        if (model != null) {
            model.clearDirty();
        }
    }

    public long computeTimeLength() {
        DefaultChunkModel model = this.midiChunkModel;
        return model == null ? 0L : model.computeTimeLength();
    }
}

